<?php
/**
 * Template Name: Blog full width
 *
 * @package luzuk Premium
 */
get_header(); 
?>
  <?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
<header class="page-main-header"  <?php  if (!empty($image)) : ?>
             style="background: url('<?php echo esc_url($image); ?>'); background-repeat: no-repeat; background-size:cover; position: relative;"
              <?php endif ?>>
    <!-- <div class="overlay1"></div> -->
    <div class="container">
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?>
        <div class="clearfix"></div>
    </div>
     <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') :
        ?>
        <div class="breadcrumbbox ">
            <div class="container">
                <div class='button'><?php luzuk_lite_the_breadcrumb(); ?></div>
                <!--  <?php //luzuk_lite_the_breadcrumb(); ?> -->
            </div>
        </div>
    <?php endif ?>  
    <div class="innheader">
        <svg class="innh-waves" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 24 150 28" preserveAspectRatio="none" shape-rendering="auto">
            <defs>
                <path id="gentle-wave" d="M-160 65c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352z" />
            </defs>
            <g class="parallax">
           <!-- <use xlink:href="#gentle-wave" class="wave3" x="48" y="0" fill="#d33" /> -->
                <use xlink:href="#gentle-wave" class="wave8" x="48" y="3" />
                <!-- <use xlink:href="#gentle-wave" class="wave4" x="48" y="5" fill="#000" /> -->
                <use xlink:href="#gentle-wave" class="wave9" x="48" y="6" />
            </g>
        </svg>
    </div> 
<div class="clearfix"></div>
</header><!-- .entry-header --> 

<main id="innerpage-box">
    <div class="container">
        <div class="inner_contentbox">
		    <div id="blog-box" class="ht-blog-wrap innerpage-whitebox">
    	    <?php
              $current_page = max(1, get_query_var('paged'));
              $luzuk_blog_cat_exclude = get_theme_mod('luzuk_blog_categories');
              $luzuk_blog_cat_exclude = explode(',', $luzuk_blog_cat_exclude);
              $excerpt = get_theme_mod('luzuk_blog_categories_settings');
              $args = array(
                  'category__not_in' => $luzuk_blog_cat_exclude,
                  // 'page'=,
                  'paged'=> $current_page,

              );
              $query = new WP_Query($args);
              if($query -> have_posts()):
                  while($query -> have_posts()) : $query -> the_post();
                   $luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id() , 'total-blog-thumb');
                   $img = (has_post_thumbnail())?esc_url($luzuk_image[0]):get_template_directory_uri().'/images/default.png';
            ?>
                <div class="inner-blog-post col-md-4 col-sm-6 col-xs-12 ">
                    <div class="inner-blogpost">
                        <div class="ht-blog-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                <img class="inner-blog-img" src="<?php echo $img; ?>" alt="<?php the_title(); ?>">
                                <div class="overlay"></div>
                            </a>
                        </div>
                        <div class="inner-blogpost-info">
                            <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
                            <div class="inner-blog-excerpt">
                              <?php 
                               if (has_excerpt()) {
                                          echo get_the_excerpt();
                                      } else {
                                          echo luzuk_excerpt(get_the_content(),160);  
                                   }
                              ?>
                            </div>
                        </div>
                        <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :?>
                        <div class="blog-Athr">
                            <li><i class="fa fa-calendar"></i><?php echo get_the_date( 'j M Y' ); ?></li>
                           <!--  <li><i class="fa fa-user"></i>by <//?php echo get_the_author(); ?> </li> -->
                            <li><i class="fa fa-comments-o"></i>Comments <?php echo $my_var = get_comments_number(); ?></li>
                        </div>
                        <?php endif ?>  
                    <div class="clearfix"></div>
                    </div>
                    <script>
                      jQuery.noConflict();
                      $(function(){
                        function innerblogpostHeight(){
                          var ht = 0;
                          $('.page-template-blog-template .inner-blogpost').each(function(i){
                            var tHt = $(this).height();
                            if(ht<tHt){
                              ht=tHt;
                            }
                          });
                          $('.page-template-blog-template .inner-blogpost').height(ht+'px');
                        }
                        innerblogpostHeight();
                      });
                      $( window ).resize(function(){
                        innerblogpostHeight();
                      });
                    </script>
                </div>    

                <?php
                   endwhile;
                endif;
                wp_reset_postdata();
                ?>
                <div class="clearfix"></div>
            </div>
            <div class="pagingation">
                <?php lzGetPagination($query);?>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
</main>
<?php get_footer(); ?>