<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package LZ Fitness Premium
 */
?><!DOCTYPE html>

<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Roboto+Condensed:300,300i,400,400i,700,700i" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Lobster&amp;subset=cyrillic,cyrillic-ext,latin-ext,vietnamese" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	  <script type="text/javascript">
	$(document).ready(function(){
		$("#formButton").click(function(){
			$("#form1").toggle();
		});
	});
 </script>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'gurukul' ); ?></a>

<header class="site-header header-transparent header mo-left header-seo">
<div class="top-header">
				<div class="row">
					

					<div class="col-md-3 col-md-offset-1 col-sm-5 col-xs-8 logomainboxx">
						<?php 
							if( get_theme_mod('pages_logoTmargin',true) ) {
				                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
				            }
				            if( get_theme_mod('pages_logoBmargin',true) ) {
				                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
				            }
				            if( get_theme_mod('pages_logoLmargin',true) ) {
				                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
				            }
				            if( get_theme_mod('pages_logoRmargin',true) ) {
				                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
				            }
	 					?>
						<div class="logobox"  style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>" >
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
						<?php endif; ?>
						<!-- .site-branding -->
					</div>
					<div class="clearfix"></div>
					</div>


					<div class="col-md-8 col-sm-7 padding0">
						<div class="shape-header">
							<div class="col-md-11 col-md-offset-1 col-sm-12 headershede col-xs-12">
								<?php
								$phone = get_theme_mod('lz_fitness_headermain_phone', '012 345 6789');

								$facebook = get_theme_mod('lz_fitness_header_fb', '//facebook.com/');
								$twitter = get_theme_mod('lz_fitness_header_tw', '//twitter.com/');
								$instagram = get_theme_mod('lz_fitness_header_insta', '//www.instagram.com/');
								$linkedIn = get_theme_mod('lz_fitness_header_in', '//linkedin.com/');
								?>
								<div class="col-md-4 col-md-offset-2 col-sm-5 col-sm-offset-1 col-xs-6"> 
									<?php if($phone){ ?>
									<div class="shadeheadbox">
										<div class="col-md-2 col-sm-2 col-xs-1 padding0 resspace">
											<i class="fa fa-phone" aria-hidden="true"></i>
										</div>
										<div class="col-md-10 col-sm-10 col-xs-11 padding0">
											<div class="contactspade-border">
												<div class="themetext"><a href="tel:<?php echo $phone;?>"><?php echo ($phone);  ?></a></div>
											</div>
										</div>
									</div>
									<?php } ?>
								</div>
								<div class="col-md-6 col-sm-6 col-xs-6">
								<div class="header-social-links">
										<?php if(!empty($facebook)){ ?>
											<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
										<?php }?>
										<?php if(!empty($twitter)){ ?>
											<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
										<?php }?>
										<?php if(!empty($linkedIn)){ ?>
											<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
										<?php }?>
										<?php if(!empty($instagram)){ ?>
											<a href="<?php echo $instagram ?>" target="_blank" title="Instagram"><span class="fa fa-instagram"></span></a>
										<?php }?>
										
									</div>
								</div>
							</div>
						</div>
					<div class="header-right col-md-4 col-md-offset-3 col-sm-6 padding0 col-xs-6">
					<div class="header-box">
						<?php 	
						
							$email = get_theme_mod('lz_fitness_headermain_email', 'info@example.com');					

						?>
							<div class="header-right-box">
									
									
									<?php if($email ){ ?>
									<div class="headbox">
										<div class="col-md-2 col-sm-2 col-xs-3 padding0 resspace">
											<i class="fa fa-envelope" aria-hidden="true"></i>
										</div>
										<div class="col-md-10 col-sm-10 col-xs-9 padding0">
											<div class="contact-border">
												
												<div class="mailto"><a href="mailto:<?php echo $email;?>"><?php echo $email ;?></a></div>
											</div>
										</div>
									</div>
									<?php } ?>
									<div class="clearfix"></div>	
							</div>
							<div class="clearfix"></div>	
						</div>
					</div>
					<div class="col-md-4 col-sm-6 headerbtn col-xs-6">
						<?php if( get_theme_mod('cds_button_display','show' ) == 'show') :
							?>
							<div class="header-inquiry-btn">
								<?php
								$headerinquirytitle = get_theme_mod('lz_fitness_headermain_headerinquirytitle', 'MAKE AN APPOINTMENT'); 
								$headerinquiry = get_theme_mod('lz_fitness_header_headerinquiry', 'Make an appointment link here');
								?>
								<?php if(!empty($headerinquiry)){ ?>
									<div class='head-button'><a href="<?php echo $headerinquiry ?>" title="headerinquiry"><?php echo ($headerinquirytitle);  ?></a></div>
								<?php }?> 
							</div>
						<?php endif ?>
					</div>

				</div>

				</div>
		</div>

		<!-- <div class="clearfix"></div> -->

			<div class="medal-header">
				
				<div class="container"> 
							<!-- main header -->
							<div class="col-md-12 col-sm-12 col-xs-12 head-menu main-bar-wraper padding0">
								<!-- <div class="col-md-offset-2 inside-full-height"> -->

									<div class="container">
										<div class="top-bar-head">
											<div class="site-navigation ">
												<div class="hamburger-menus">
													<span></span>
													<span></span>
													<span></span>
													<span></span>
													<span></span>
													<span></span>
													<span></span>
													<span></span>
													<span></span>
												</div>
												<nav class="navigation">
													<div class="overlaybg"></div><!--  /.overlaybg -->
													<!-- Main Menu -->
													<div class="menu-wrapper">
														<div class="menu-content">
															<?php
															if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
																wp_nav_menu ( array(
																	'menu_class' => 'mainmenu ht-clearfix',
																	'container'=> 'ul',
																	'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
																	'theme_location' => 'primary',  
																)); 
															} else {
																wp_nav_menu ( array(
																	'menu_class' => 'mainmenu ht-clearfix',
																	'container'=> 'ul',
																	'theme_location' => 'primary',  
																)); 
															}
															?>
														</div> <!-- /.hours-content-->
														

													</div><!-- /.menu-wrapper --> 
												</nav>
												<div class="clearfix"></div>
											</div><!--  /.site-navigation -->

										</div>
									</div>
									<!-- </div> -->
								</div>
							</div>
							<!-- main header END -->
							<div class="clearfix"></div>
						</div>
					</header><!-- #masthead -->
	</div>
