<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * * @package lz-fitness-premium
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function lz_fitness_lite_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	return $classes;
}
add_filter( 'body_class', 'lz_fitness_lite_body_classes' );



add_action( 'admin_menu', 'lz_fitness_register_backend' );
function lz_fitness_register_backend() {
	add_theme_page( __('Luzuk Themes', 'lz-fitness-premium'), __('Expert Lawyer', 'lz-fitness-premium'), 'edit_theme_options', 'about-lz-fitness-premium', 'lz_fitness_backend');
}

function lz_fitness_backend(){ ?>
<div class="theme-info-wrapper">
	<div class="theme-info-inner">
		<div class="theme-info-left">
			<div class="theme-info-left-inner">
				
				<h2>Theme issues?</h2>
				<p>
					If you are having theme related problems then please contact us through our <a href="https://www.luzuk.com/pages/contact-us/" target="_blank">contact form</a>, which can be found at <a href="https://www.luzuk.com/pages/contact-us/" target="_blank">https://www.luzuk.com/pages/contact-us/</a>
				</p>	

				<h2>Need more help?</h2>
				<ul>
					<li><a href="https://www.luzuk.com/products/free-lawyer-wordpress-theme/" target="_blank">Expert Lawyer</a></li>
					
				</ul>
			</div>
		</div>
		<div class="theme-info-right">
			<a href="https://www.luzukdemo.com/docs/expert-lawyer/" target="_blank" style="display:block;">
				<img src="<?php echo get_bloginfo('template_url')?>/images/lz-fitness-premium.png">
			</a>
		</div>
	</div>
</div>
<?php }

