<?php

/**
 * Liting the feature details 
 * @param : int $pageId default is null
 * @param : boolean $isCustomizer default is false, if set to true will get the data stored with customizer
 * @param : int $i default is null, it will used as a iteration for data with customizer, this will be used only if the $isCustomizer is set to true.
 * @return: Text $text
 */
function featuredShortCode($pageId = null, $isCustomizer = false, $i = null) {
    ob_start();

    $args = array('post_type' => 'our-services');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('services_npp_count', 5);
     $services_page_icon1 = get_theme_mod('services_page_icon1'.$i);
    $cols++;
    switch($cols){
        case 1:
            $colCls = 'col-md-12 col-sm-12 col-xs-12';
            break;
        case 2:
            $colCls = 'col-md-6 col-sm-6 col-xs-12';
            break;
        case 3:
        case 5:
        case 6:
        case 9:
            $colCls = 'col-md-4 col-sm-6 col-xs-12';
            break;
        default:
            $colCls = 'col-md-3 col-sm-6 col-xs-12';
            break;
    }
                
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $lz_fitness_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-features-thumb');

            

            if ($isCustomizer === true) {
                $feature_designation = get_theme_mod('feature_designation' . $i);
            }
            $post = get_post();
            //designation
            $designation = get_post_meta($post->ID, 'designation', false);
            $feature_designation = !empty($designation[0]) ? $designation[0] : '';
           
            ?> 
            <div class="row">
            <div class="<?php echo $colCls; ?> fpost">
                        
                <div class="featured-post-box wow fadeInLeft">
                   
                    <div class="featured-post">
                        <a class="secondry-bg" href="<?php echo esc_url(get_permalink()); ?>">
                             <div class="featured-icon">
                                <span class="<?php echo $services_page_icon1; ?>"></span>
                            </div>
                        </a>

                        <div class="featuredcontent-data">
                              <a class="secondry-bg" href="<?php echo esc_url(get_permalink()); ?>">
                                <div class="featured-img">
                                    <?php
                                    if (has_post_thumbnail()) {
                                        $image_url = $lz_fitness_image[0];
                                    } else {
                                        $image_url = get_template_directory_uri() . '/images/team-thumb.png';
                                    }
                                    ?>                  
                                    <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />
                                </div>
                                </a>
                        <div class="featured-data">
                           <h5 class="text"><?php the_title(); ?></h5> 
                               <!--  <h5 class="text"><?php //echo wp_trim_words( get_the_title(), 2 ); ?></h5> -->
                                <div class="featurborder"></div>
                            <div class="clearfix"></div> 
                            <p>
                                <?php

                                if(has_excerpt()){
                                  echo get_the_excerpt();
                                 }else{
                                  echo lz_fitness_excerpt( get_the_content() , 60 );
                                 } 
                                ?>
                            </p>
                        </div>
                    </div>
                </div> 
                           
                <div class="clearfix"></div>          
            </div>
            <script>
  jQuery.noConflict();
  $(function(){
    function featuredpostboxHeight(){
      var ht = 0;
      $('#innerpage-box .featured-post-box').each(function(i){
        var tHt = $(this).height();
        if(ht<tHt){
          ht=tHt;
        }
      });
      $('#innerpage-box .featured-post-box').height(ht+'px');
    }
    featuredpostboxHeight();
  });
  $( window ).resize(function(){
    featuredpostboxHeight();
  });
</script>
        </div>
        <?php
    endwhile;
    $text = ob_get_contents();
    ob_clean();
endif;
wp_reset_postdata();
return $text;
}
add_shortcode('SERVICES', 'featuredShortCode');


    