<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'lz-fitness-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'lz-fitness-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );


//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');


$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '35px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'lz-fitness-premium' )
	)
);


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );



//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'lz-fitness-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'lz-fitness-premium' ),
				'off' => __( 'Disable', 'lz-fitness-premium' )
			)	
		)
	)
);

$sectionHeader = 'lz_fitness_header_settings';


lzCustomLable($wp_customize, 'lz_fitness_header_clrlblbgTxt', 'lz_fitness_header_settings', 'Set Header Background Colors:');

//Set top header colour
addColorPalatOption($wp_customize, 'lz_fitness_topheader_color', 'lz_fitness_header_settings', 'Top Header Color', '#fff');


//Set top header shape colour
addColorPalatOption($wp_customize, 'lz_fitness_topheadershape_color', 'lz_fitness_header_settings', 'Top Header Shape Color', '#3a4559');

//Set nevigation header colour
addColorPalatOption($wp_customize, 'lz_fitness_header_color', 'lz_fitness_header_settings', 'Navigation Header Color', '#3a4559');


$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '012 345 6789', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'lz-fitness-premium' )
	)
);

//Set header phone icon  colour
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneiconColor', 'lz_fitness_header_settings', 'Header Phone Icon Color', '#d0ac62');

//Set header phone hover colour
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneiconhoverColor', 'lz_fitness_header_settings', 'Header Phone Icon Hover Color', '#fff');

//Set header phone colour
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneColor', 'lz_fitness_header_settings', 'Header Phone No.Color', '#fff');


// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');


// FACEBOOK 
$wp_customize->add_setting('lz_fitness_header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_fb',
	array(
		'settings'      => 'lz_fitness_header_fb',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'lz-fitness-premium' )
	)
);
// TWITTER
$wp_customize->add_setting('lz_fitness_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_tw',
	array(
		'settings'      => 'lz_fitness_header_tw',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'lz-fitness-premium' )
	)
);
// LINKED IN
$wp_customize->add_setting('lz_fitness_header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_in',
	array(
		'settings'      => 'lz_fitness_header_in',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'lz-fitness-premium' )
	)
);

// Instagram
$wp_customize->add_setting('lz_fitness_header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_insta',
	array(
		'settings'      => 'lz_fitness_header_insta',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Instagram', 'gurukul' )
	)
); 

 //header social color   
addColorPalatOption($wp_customize, 'lz_fitness_header_socialColor', 'lz_fitness_header_settings', ' Header social color', '#fff');

//header social hover color   
addColorPalatOption($wp_customize, 'lz_fitness_header_socialhoverColor', 'lz_fitness_header_settings', ' Header social hover color', '#d0ac62');


//header

// $wp_customize->add_setting(
// 	'lz_fitness_headermain_emaillabel',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( 'EMAIL SUPPORT', 'lz-fitness-premium' )
// 	)
// );
// $wp_customize->add_control(
// 	'lz_fitness_headermain_emaillabel',
// 	array(
// 		'settings'      => 'lz_fitness_headermain_emaillabel',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'text',
// 		'label'         => __( 'Email Label', 'lz-fitness-premium' )
// 	)
// );

$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Info@example.com', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Add Email Id', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_header_clrlblcontactTxt', 'lz_fitness_header_settings', 'Set Header Contact Details Colors:');

//Set header icon colour
addColorPalatOption($wp_customize, 'lz_fitness_header_iconColor', 'lz_fitness_header_settings', 'Header Icon Color', '#d0ac62');

//Set header icon hover colour
addColorPalatOption($wp_customize, 'lz_fitness_header_iconhoverColor', 'lz_fitness_header_settings', 'Header Icon Hover Color', '#3a4559');

//Set header contact label colour
addColorPalatOption($wp_customize, 'lz_fitness_header_contactlabelColor', 'lz_fitness_header_settings', 'Header Contact Label Color', '#303030');

//Set header email colour
addColorPalatOption($wp_customize, 'lz_fitness_header_emailColor', 'lz_fitness_header_settings', 'Header Email Color', '#303030');

//Set header email hover colour
addColorPalatOption($wp_customize, 'lz_fitness_header_emailhoverColor', 'lz_fitness_header_settings', 'Header Email Hover Color', '#d1ac66');


lzCustomLable($wp_customize, 'lz_fitness_premium_header_lblbutton1display', 'lz_fitness_header_settings', 'Header MAKE AN APPOINTMENT Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_button_display', array( 'label' => 'Button Display', 'section' => 'lz_fitness_header_settings', 'settings' => 'cds_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
	'lz_fitness_headermain_headerinquirytitle',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'MAKE AN APPOINTMENT' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_headerinquirytitle',
	array(
		'settings'      => 'lz_fitness_headermain_headerinquirytitle',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Header Button Text', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting('lz_fitness_header_headerinquiry',	array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_headerinquiry',
	array(
		'settings'      => 'lz_fitness_header_headerinquiry',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Add "Button" Link Here', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_header_clrlbtnTxt', 'lz_fitness_header_settings', 'Set Header Button Colors:');

//Set header button colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtn_color', 'lz_fitness_header_settings', 'Header Button Color', '#fff');

//Set header button bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnbg_color', 'lz_fitness_header_settings', 'Header Button Background Color', '#d0ac62');

//Set header button hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnhover_color', 'lz_fitness_header_settings', 'Header Button Hover Color', '#fff');

//Set header button bg hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnbghover_color', 'lz_fitness_header_settings', 'Header Button Background Hover Color', '#3a4559');


lzCustomLable($wp_customize, 'lz_fitness_header_clrlblImgTxt', 'lz_fitness_header_settings', 'Set Header Menu Colors:');

//Set header menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#fff');

//Set header current menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Header Current Menu Color', '#fff');

//Set header current menu bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenubg_color', 'lz_fitness_header_settings', 'Header Current Menu Background Color', '#d0ac62');

//Set header menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhover_color', 'lz_fitness_header_settings', 'Header Menu Hover Color', '#fff');

//Set header menu hover bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhoverbg_color', 'lz_fitness_header_settings', 'Header Menu Hover Background Color', '#d0ac62');

//Set header sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Sub Menu Color', '#fff');

//Set header dropdown Background colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownbg_color', 'lz_fitness_header_settings', 'Header dropdown Background Color', '#3a4559');

//Set header dropdown border colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownborder_color', 'lz_fitness_header_settings', 'Header dropdown Border Color', '#d1ac66');


//Set header sub menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Hover Color', '#d1ac66');

//Set header sub menu arrow hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuarrowhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Arrow Hover Color', '#d1ac66');

//Set header current sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentsubmenu_color', 'lz_fitness_header_settings', 'Header Current Sub Menu Color', '#fff');

//Set header current sub menu bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentsubmenubg_color', 'lz_fitness_header_settings', 'Header Current Sub Menu background Color', '#d1ac66');

//Set header navigation colour
addColorPalatOption($wp_customize, 'lz_fitness_headernavigation_color', 'lz_fitness_header_settings', 'Header Navigation Color', '#3a4559');

addColorPalatOption($wp_customize, 'lz_fitness_header_BorderRespColor', 'lz_fitness_header_settings', 'Header Navigation Border Color For Tablet & Mobile Screens', '#d0ac62');
addColorPalatOption($wp_customize, 'lz_fitness_template_togglebar_color', 'lz_fitness_header_settings', 'Toggle bar color', '#d0ac62');


//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'lz-fitness-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#d0ac62');
//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#d0ac62');

// touggle bar color


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

// end to show & hide button


//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#d0ac62');

//Inner page breadcrumbbox current hover title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#3a4559');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');

//Inner page breadcrumbbox border color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#3a4559');

//INNER feature PAGE COLOR SETTINGS
$wp_customize->add_section(
	'lz_fitness_feature_page_settings',
	array(
		'title' => __( 'Inner feature Page Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// title color
addColorPalatOption($wp_customize, 'lz_featuredinnertitle_Color', 'lz_fitness_feature_page_settings', 'Title color', '#3a4559');

// title hover color
addColorPalatOption($wp_customize, 'lz_featuredinnertitlehover_Color', 'lz_fitness_feature_page_settings', 'Title hover color', '#d0ac62');

// text color
addColorPalatOption($wp_customize, 'lz_featuredinnertext_Color', 'lz_fitness_feature_page_settings', 'Text color', '#383838');

//box bg color
addColorPalatOption($wp_customize, 'lz_featuredboxinnerbg_Color', 'lz_fitness_feature_page_settings', 'Box background color', '#fff');


// border color
addColorPalatOption($wp_customize, 'lz_featuredboxinnerborder_Color', 'lz_fitness_feature_page_settings', 'Border color', '#3a4559');

//INNER FAQS PAGE COLOR SETTINGS
$wp_customize->add_section(
	'lz_fitness_faqs_page_settings',
	array(
		'title' => __( 'Inner FAQS Page Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//ques border color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QborderColor', 'lz_fitness_faqs_page_settings', 'Question border color', '#3a4559');

//ques dark border color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QdarkborderColor', 'lz_fitness_faqs_page_settings', 'Question dark border color', '#d0ac62');

//ques text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QtextColor', 'lz_fitness_faqs_page_settings', 'Question text color', '#000');

//down arrow text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QdownarrowColor', 'lz_fitness_faqs_page_settings', 'Question indicator arrow color', '#fff');

//down arrow bg color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QdownarrowbgColor', 'lz_fitness_faqs_page_settings', 'Question indicator arrow background color', '#d0ac62');

//ans text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AtextColor', 'lz_fitness_faqs_page_settings', 'Answer text color', '#333333');

//ans bg color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AbgColor', 'lz_fitness_faqs_page_settings', 'Answer background color', '#fff9ec');

//ans border color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AborderColor', 'lz_fitness_faqs_page_settings', 'Answer border color', '#3a4559');

//ans dark border color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AdarkborderColor', 'lz_fitness_faqs_page_settings', 'Answer dark border color', '#d0ac62');



//INNER TESTIMONIALS PAGE COLOR SETTINGS
$wp_customize->add_section(
	'testimonialal_page_settings',
	array(
		'title' => __( 'Inner Testimonial Page Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

// text color
addColorPalatOption($wp_customize, 'testimonialalsinner_TextColor', 'testimonialal_page_settings', 'Testimonial color', '#fff');

// title color
addColorPalatOption($wp_customize, 'testimonialalsinner_TitleColor', 'testimonialal_page_settings', 'Title color', '#fff');

// title hover color
addColorPalatOption($wp_customize, 'testimonialalsinner_TitlehoverColor', 'testimonialal_page_settings', 'Title hover color', '#3b4559');

// desg color
addColorPalatOption($wp_customize, 'testimonialalsinner_desgColor', 'testimonialal_page_settings', 'Designation color', '#fff');

// Box color
addColorPalatOption($wp_customize, 'testimonialalsinner_boxColor', 'testimonialal_page_settings', 'Box color', '#3b4559');

// Box hover color
addColorPalatOption($wp_customize, 'testimonialalsinner_boxhoverColor', 'testimonialal_page_settings', 'Box hover color', '#d0ac62');

// Box highlight border color
addColorPalatOption($wp_customize, 'testimonialalsinner_boxhighlightborderColor', 'testimonialal_page_settings', 'Box highlight border color', '#d0ac62');


// Box highlight border hover color
addColorPalatOption($wp_customize, 'testimonialalsinner_boxhighlightborderhoverColor', 'testimonialal_page_settings', 'Box highlight border hover color', '#3b4559');



//INNER TEAM PAGE COLOR SETTINGS
$wp_customize->add_section(
	'team_page_settings',
	array(
		'title' => __( 'Inner Team Page Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

// img border color
addColorPalatOption($wp_customize, 'teaminner_imgborderColor', 'team_page_settings', 'Image border color', '#3a4559');

// img border highlight color
addColorPalatOption($wp_customize, 'teaminner_imghighlightborderColor', 'team_page_settings', 'Image border highlight color', '#d0ac62');

// title color
addColorPalatOption($wp_customize, 'teaminner_TitleColor', 'team_page_settings', 'Title color', '#3a4559');

// title hover color
addColorPalatOption($wp_customize, 'teaminner_TitlehoverColor', 'team_page_settings', 'Title hover color', '#d0ac62');

// desg color
addColorPalatOption($wp_customize, 'teaminner_DesColor', 'team_page_settings', 'Designation color', '#000');

// text color
addColorPalatOption($wp_customize, 'teaminner_TextColor', 'team_page_settings', 'Text color', '#2e2e2e');

// border color
addColorPalatOption($wp_customize, 'teaminner_borderColor', 'team_page_settings', 'Border color', '#3a4559');

// border hover color
addColorPalatOption($wp_customize, 'teaminner_highlightborderColor', 'team_page_settings', 'Border hover color', '#d0ac62');

// social color
addColorPalatOption($wp_customize, 'teaminner_SocialColor', 'team_page_settings', 'Social color', '#3a4559');

// social border color
addColorPalatOption($wp_customize, 'teaminner_SocialborderColor', 'team_page_settings', 'Social border color', '#3a4559');

// social hover color
addColorPalatOption($wp_customize, 'teaminner_SocialhoverColor', 'team_page_settings', 'Social hover color', '#d0ac62');

// social border hover color
addColorPalatOption($wp_customize, 'teaminner_SocialborderhoverColor', 'team_page_settings', 'Social border hover color', '#d0ac62');



//INNER GALLERY PAGE COLOR SETTINGS
$wp_customize->add_section(
	'gallery_page_settings',
	array(
		'title' => __( 'Inner Gallery Page Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

// img border color
addColorPalatOption($wp_customize, 'galleryinner_imgborderColor', 'gallery_page_settings', 'Image border color', '#d0ac62');

// img animated border color
addColorPalatOption($wp_customize, 'galleryinner_imganimatedborderColor', 'gallery_page_settings', 'Image animated border color', '#3a4559');
  
//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2019 Expert Lawyer. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#272c3f', get_template_directory_uri().'/images/default-gray.png', 'img');

//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer title border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_titleborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Border Color', '#d0ac62');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#fff');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', '#d0ac62');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#fff');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#fff');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#d0ac62');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Date Color', '#fff');

//theme Footer menu icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_navicon_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Color', '#fff');

//theme Footer menu icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuiconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Hover Color', '#d0ac62');


//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#fff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#fff');

//theme Footer Social Background hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialbghover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Background hover Color', '#d0ac62');


//theme Footer Social border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborder_color', 'lz_fitness_footer_copyright_settings', 'Footer  Social Border Color', '#4c3a37');

//theme Footer Social border hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborderhover_color', 'lz_fitness_footer_copyright_settings', 'Footer  Social Border Hover Color', '#d0ac62');

//theme Footer form Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Color', '#fff');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Border Color', '#fff');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Color', '#fff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#d0ac62');

//theme Copyright Footer Border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightborder_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Border Color', '#dadada');

//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#fff');

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Postpage Date Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 