<?php 
/**
 * Customiser section for featured
 **/
// Featured Section
$wp_customize->add_section(
    'services_section',
    array(
        'title'         => __( 'Services Section', 'lz-fitness-premium' ),
        'panel'   => 'lz_fitness_premium_home_panel',
    )
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
    'services_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'services_section_disable',
        array(
            'settings'      => 'services_section_disable',
            'section'       => 'services_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'featured', 'services_section', $color='#f4f4f4', get_template_directory_uri().'/images/default-gray.png', 'img');


$wp_customize->add_setting(
    'services_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'services_title_sub_title_heading',
        array(
            'settings'      => 'services_title_sub_title_heading',
            'section'       => 'services_section',
            'label'         => __( 'Section Title', 'lz-fitness-premium' ),
        )
    )
);

    $wp_customize->add_setting(
        'services_subtitle',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'LEGAL PRACTICE AREAS', 'lz-fitness-premium' )
        )
    );
    $wp_customize->add_control(
        'services_subtitle',
        array(
            'settings'      => 'services_subtitle',
            'section'       => 'services_section',
            'type'          => 'text',
            'label'         => __( 'Subtitle for section', 'lz-fitness-premium' )
        )
    );


// subHeading color
addColorPalatOption($wp_customize, 'lz_featured_SubHeadingColor', 'services_section', 'Subheading color','#292e42');

$wp_customize->add_setting(
    'services_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Law Services', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'services_title',
    array(
        'settings'      => 'services_title',
        'section'       => 'services_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'lz-fitness-premium' )
    )
);

// Heading color
addColorPalatOption($wp_customize, 'lz_featured_HeadingColor', 'services_section', 'Heading color','#272e3e');
// border color
addColorPalatOption($wp_customize, 'lz_featured_borderColor', 'services_section', 'Border color', '#d0ac62');


$wp_customize->add_setting('services_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'services_npp_heading',
        array(
            'settings'      => 'services_npp_heading',
            'section'       => 'services_section',
            'label'         => __( 'Number Of services to show', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting('services_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 5));
$wp_customize->add_control(
    'services_npp_count',
    array(
        'settings'      => 'services_npp_count',
        'section'       => 'services_section',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'lz-fitness-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

// TEAM PAGES
for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'services_section',
                'label'         => __( 'Services ', 'lz-fitness-premium' ).$i,
            )
        )
    );

    if(is_array($lzFitnessfeaturesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'services_section',
                'type'=> 'select',
                'label'         => __( 'Select a service', 'lz-fitness-premium' ),
                'choices' => $lzFitnessfeaturesSingleChoice,
            )
        );
    $wp_customize->add_setting(
        'services_page_icon1'.$i,
        array(
            'default'           => 'fa fa-truck',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'services_page_icon1'.$i,
            array(
                'settings'      => 'services_page_icon1'.$i,
                'section'       => 'services_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'gurukul' ),
            )
        )
    );


    }else{
        $wp_customize->add_setting('lz_fitness_Service_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
        $wp_customize->add_control(
            new lz_fitness_Info_Text( 
                $wp_customize,
                'lz_fitness_Service_section_lbl'.$i,
                array(
                    'settings'      => 'lz_fitness_Service_section_lbl'.$i,
                    'section'       => 'services_section',
                    'label'         => __( 'Note:', 'lz-fitness-premium' ), 
                    'description'   => __( '<strong>Changes will not reflect unless you select a service.</strong> <br/>Please add the service from "Service menu" and then select service to show information.', 'lz-fitness-premium' ),
                )
            )
        );
    }
}

// icon color
addColorPalatOption($wp_customize, 'lz_featuredicon_Color', 'services_section', 'Icon color', '#d0ac62');

// icon hover color
addColorPalatOption($wp_customize, 'lz_featurediconhover_Color', 'services_section', 'Icon hover color', '#3a4559');

// title color
addColorPalatOption($wp_customize, 'lz_featuredtitle_Color', 'services_section', 'Title color', '#282d40');

// title hover color
addColorPalatOption($wp_customize, 'lz_featuredtitlehover_Color', 'services_section', 'Title hover color', '#d0ac62');

// border color
addColorPalatOption($wp_customize, 'lz_featuredtitleborder_Color', 'services_section', 'Border color', '#d0ac62');

// border hover color
addColorPalatOption($wp_customize, 'lz_featuredtitleborderhover_Color', 'services_section', 'Border hover color', '#d0ac62');

// text color
addColorPalatOption($wp_customize, 'lz_featuredtext_Color', 'services_section', 'Text color', '#303030');

