<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'lz_fitness_premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'gurukul' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'lz_fitness_premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_premium_slider_show_content',
		array(
			'settings'      => 'lz_fitness_premium_slider_show_content',
			'section'       => 'lz_fitness_premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'gurukul' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'gurukul' ),
				'off' => __( 'No', 'gurukul' )
			),
		)
	)
);

$wp_customize->add_setting('lz_fitness_premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_premium_slider_section_lbl',
		array(
			'settings'		=> 'lz_fitness_premium_slider_section_lbl',
			'section'		=> 'lz_fitness_premium_slider_section',
			'label'			=> __( 'Note:', 'gurukul' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'gurukul' ),
		)
	)
);

// Slider Highlight Title color
addColorPalatOption($wp_customize, 'slider_highlightTitleColor', 'lz_fitness_premium_slider_section', 'Slider Highlight Title Color', '#fff');

// Slider Highlight Title bg color
addColorPalatOption($wp_customize, 'slider_highlightTitlebgColor', 'lz_fitness_premium_slider_section', 'Slider Highlight Title Background Color', '#d0ac62');

// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'lz_fitness_premium_slider_section', 'Slider Title Color', '#fff');
// Slider Sub Title color
addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Color', '#fff');

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Color', '#fff');
// Slider Button border color
addColorPalatOption($wp_customize, 'slider_buttonborderColor', 'lz_fitness_premium_slider_section', 'Slider Button Border Color', '#fff');

// Slider Button Text hover color
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Hover Color', '#fff');

// Slider Button Background hover color
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Hover Color', '#d0ac62');

// Slider Button border hover color
addColorPalatOption($wp_customize, 'slider_buttonborderhoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Border hover Color', '#d0ac62');
