<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins:600,800" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600,800|Poppins:600,800" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,700" rel="stylesheet">
	<!-- <link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.carousel.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.theme.default.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/style-ltr.css" /> -->

	<!-- new ico -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css
	" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>


</head>

<body <?php body_class(); ?>>
	<div class="overlay"></div>
    <div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'expertmovers' ); ?></a>
		<header id="ht-masthead" class="ht-site-header">
			<div class="main-header">
					<div class="overlap-header">
					<div class="row upper-header">	
						<div class="container">
							<div class="col-md-12 col-sm-9 col-xs-12 padding0 header-shape">
									<?php
										$email = get_theme_mod('lz_fitness_headermain_email', 'info@example.com');
										
										$phone = get_theme_mod('lz_fitness_headermain_phone', '123 456 7890');
										
									?>
											<ul class="themetext">
												<?php if($phone){ ?><li class="header-phoneicon"><i class="fa fa-phone blink" aria-hidden="true"></i><?php echo ($phone);?></li><?php } ?>

												<?php if($email){ ?>
												<li class="header-emailicon"><i class="fa fa-envelope blink" aria-hidden="true"></i><a href="mailto:<?php echo $email;?>"><?php echo ($email);?></a></li>
												<?php } ?>
											</ul>
							</div>	
						</div>
					</div>
					<div class="clearfix"></div>
				<div class="lower-header">	
					<div class="row row-eq-height">
					<div class="header-left col-md-4 col-sm-4 col-xs-9">
						<div class="inside-full-height">
						<!-- for logo margin -->
						<?php 
							if( get_theme_mod('pages_logoTmargin',true) ) {
				                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
				            }
				            if( get_theme_mod('pages_logoBmargin',true) ) {
				                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
				            }
				            if( get_theme_mod('pages_logoLmargin',true) ) {
				                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
				            }
				            if( get_theme_mod('pages_logoRmargin',true) ) {
				                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
				            }
	 					?>
	 					<!-- for logo margin -->
						<div class="logobox" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
							<?php 
							if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
								the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
								<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
						<?php endif; ?>
						<!-- .site-branding -->
						</div>
					</div>
					</div>
					<div class="col-md-8 col-sm-8 col-xs-3 padding0 socialalign">
						<div class="inside-full-height">
						<div class="col-md-11 header-about-theme">
							<div class="nav-menus">                 
								<a href="#" class="js-nav-toggle">
										<span></span>
								</a>
							    <div class="nav-wrapper">
									<nav role="navigation">
										<div class="nav-toggle">
												<span class="nav-back"></span>
												<span class="nav-title">Menu</span>
												<span class="nav-close"></span>
										</div>
										<?php
	                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainm ht-clearfix',
	                                                'container'=> 'ul',
	                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        } else {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainm ht-clearfix',
	                                                'container'=> 'ul',
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        }
	                                    ?>
									</nav>
								</div>
							</div>
							<nav id="ht-site-navigation" class="ht-main-navigation">
								<?php 
								wp_nav_menu( array( 
									'theme_location' => 'primary', 
									'container_class' => 'ht-menu clearfix' ,
									'menu_class' => 'ht-clearfix',
									'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								) ); 
								?>
								<div class="clearfix"></div>
							</nav><!-- #ht-site-navigation -->
							<div class="clearfix"></div>
						</div>
					</div>
				</div>
				</div>
				<div class="clearfix"></div>
			</div>			
			<div class="clearfix"></div>
		</div>
		
		</header><!-- #masthead -->
		<script>
 jQuery(document).ready(function($){
  $('.fa-search').on('click', function() {
   $('.search-bar').slideToggle();
  });
 });
</script>
	</div>
