<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );



//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'lz-fitness-premium' )
	)
);
//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);
	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'Luzuk Premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'Luzuk Premium' ),
				'off' => __( 'Disable', 'Luzuk Premium' )
			)	
		)
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '012 345 6789' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'Luzuk Premium' )
	)
);

 //header phone color
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneiconColor', 'lz_fitness_header_settings', 'header phone icon color', '#f9c12e'); 
addColorPalatOption($wp_customize, 'lz_fitness_header_phoneColor', 'lz_fitness_header_settings', 'header phone number color', '#ffffff'); 
  //header phone icon color
$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'info@example.com' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email', 'Luzuk Premium' )
	)
);


// header Email icon color
   addColorPalatOption($wp_customize, 'lz_fitness_header_emailiconColor', 'lz_fitness_header_settings', 'Header email icon color', '#f9c12e');
// header Email color
   addColorPalatOption($wp_customize, 'lz_fitness_header_emailColor', 'lz_fitness_header_settings', 'Header email text color', '#fff'); 
// header Email hover color
   addColorPalatOption($wp_customize, 'lz_fitness_header_emailhoverColor', 'lz_fitness_header_settings', 'Header email text hover color', '#f9c12e');

//$sectionHeader = 'lz_fitness_header_settings';


//Menu colors
   //Set header menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_headerhovermenu_color', 'lz_fitness_header_settings', 'Header Menu Hover Color', '#34322a');
addColorPalatOption($wp_customize, 'lz_fitness_headerhovermenuborder_color', 'lz_fitness_header_settings', 'Header Menu Hover Border Color', '#2e2e2e');

	//Set Current Menu Text colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Header Current Menu Color', '#34322a');

addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenuborderclr_color', 'lz_fitness_header_settings', 'Current Menu Border Color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenuhvrborder_color', 'lz_fitness_header_settings', 'Current Menu Hover Border Color', '#2e2e2e');

	//Set Menu Hover Text colour
	//Set header sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Dropdown Menu Color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Dropdown Menu hover Color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_headerdropdowncurrentsubmenu_color', 'lz_fitness_header_settings', 'Header Dropdown Current Menu Color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdowncurrentsubmenubrss_color', 'lz_fitness_header_settings', 'Header Dropdown Current Menu Border Color', '#2e2e2e');


addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubghover_color', 'lz_fitness_header_settings', 'Header Dropdown Menu hover Background Color', '#fff');

	//Set header sub menu Background colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubg_color', 'lz_fitness_header_settings', 'Header Dropdown Background Color', '#f9c12e');
	//Set header sub menu hover colour

	//Set header sub menu Background hover colour

	//Set header sub menu border colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuborder_color', 'lz_fitness_header_settings', 'Header Dropdown Border Color', '#343440');


//Upper header background color
addColorPalatOption($wp_customize, 'lz_fitness_header_backgroundColor', 'lz_fitness_header_settings', 'Logo Box Background color', '#ffffff');

  //Upper header highlight  background color
addColorPalatOption($wp_customize, 'lz_fitness_header_navigationbxColor', 'lz_fitness_header_settings', 'navigation box background color', '#f9c12e');

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', 'lz_fitness_header_settings', 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'lz_fitness_header_settings', 'Toggle Bar Color', '#000');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'lz_fitness_header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'lz_fitness_header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuttlbgColor', 'lz_fitness_header_settings', 'Menus Title BG Color', '#d5d5d5');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuColor', 'lz_fitness_header_settings', 'Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'lz_fitness_header_settings', 'Menus BG Color', '#212121');




//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#f7c12b');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#2e2e2e');
//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#f9c12c');

addColorPalatOption($wp_customize, 'lz_fitness_template_staticfrontinnerpage_bgcolor', 'colors', 'Static Front Page Top Header background color', '#2e2e2e');

//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'unboxthemes' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'unboxthemes' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#f9c12c');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#2e2e2e');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#ccc');

// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Postpage Date Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2019 Packages & Movers | All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#2a2a2a');



//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#f9c12c');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', '#fff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#fff');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuicon_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Color', '#f9c12c');
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuiconhvr_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Hover Color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#fff');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#f9c12c');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Date Color', '#f9c12c');

//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#2e2e2e');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#2e2e2e');

//theme Footer social border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Border Color', '#2e2e2e');

//theme Footer social border hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborderhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Border Hover Color', '#2e2e2e');

addColorPalatOption($wp_customize, 'lz_fitness_footer_socialbgss_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Background Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialbgsshvr_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Background Hover Color', '#f9c12c');

//theme Footer table text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tabletext_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Text Color', '#fff');


//theme Footer table border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tableborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Border Color', '#fff');


//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#fff');


//theme Copyright Footer bg Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightbg_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Background Color', '#202020');

addColorPalatOption($wp_customize, 'lz_fitness_footer_formlabeltxt_color', 'lz_fitness_footer_copyright_settings', 'Footer Form label Text Color', '#ffffff');

//theme Footer form Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Text & Placeholder Text Color', '#828282');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Border Color', '#fff');


//theme Footer form button Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Color', '#2e2e2e');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#f9c12c');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

addColorPalatOption($wp_customize, 'lz_fitness_shoppageheaderbg_color', 'lz_fitness_shopsidebar_settings', 'Shop Pages Top Header Background Color', '#2e2e2e');


$wp_customize->add_section(
	'lz_fitness_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_servicepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_snipservicetitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Service Title color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_snipservicetitlebackgroundcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Service Title Background color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_snipservicetextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Service Text color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_snipservicetextbxbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Service Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_snipservicetextbxbgssbtntxtColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Service Box Button Text color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_snipservicetextbxbgssbtntxtbackgroundColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Service Box Button Background color', '#f9c12c');


lzCustomLable($wp_customize, 'lz_fitness_teaminnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembernametextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Member Name Text color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermemberdesignationtextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Member Designation Text color', '#f9c12c');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialiconboxbgsColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Social Icon Box Background color', '#f9c12c');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialiconhvrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Hover color', '#f9c12c');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialiconhvrbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Hover background color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermemberboxbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Box background color', '#2e2e2e');


lzCustomLable($wp_customize, 'lz_fitness_testimonialinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Image Border color', '#f9c12c');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpagetextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclientnametextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Client Name Text color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclientnametexthoverColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Client Name Text Hover color', '#f9c12c');

addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclientdesignationtextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Designation Text color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclienttestboxbgddColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclienttestboxborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Border color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_testimonialinnerpageclienttestboxhighlightborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Highlight Border color', '#f9c12c');


lzCustomLable($wp_customize, 'lz_fitness_galleryinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_galleryimgiconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Icon color', '#f9c12c');


lzCustomLable($wp_customize, 'lz_fitness_faqinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnertitlebxbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title Box Border color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleboxborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleIconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title Icon color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleIconborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title Icon Border color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpageimageborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Image Border color', '#f9c12c');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetextcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Text color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetextboxbgsscColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Text Box Background color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetextboxbgsscbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Text Box Border color', '#f9c12c');
