<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'lz_fitness_premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'expertmovers' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'lz_fitness_premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_premium_slider_show_content',
		array(
			'settings'      => 'lz_fitness_premium_slider_show_content',
			'section'       => 'lz_fitness_premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'expertmovers' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'expertmovers' ),
				'off' => __( 'No', 'expertmovers' )
			),
		)
	)
);

$wp_customize->add_setting('lz_fitness_premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_premium_slider_section_lbl',
		array(
			'settings'		=> 'lz_fitness_premium_slider_section_lbl',
			'section'		=> 'lz_fitness_premium_slider_section',
			'label'			=> __( 'Note:', 'expertmovers' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'expertmovers' ),
		)
	)
);


// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'lz_fitness_premium_slider_section', 'Slider Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_TitleSubttlColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Color', '#fff');
addColorPalatOption($wp_customize, 'slider_HighlightTitleColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Highlight Text Color', '#e4b42c');
// Slider Sub Title color
addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'lz_fitness_premium_slider_section', 'Slider Text Color', '#fff');

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Color', '#2e2e2e');
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Hover Color', '#fff');
// Slider Button Background color
addColorPalatOption($wp_customize, 'slider_buttonbgColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Color', '#f9c12c');
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Hover Color', '#000');
// Slider Button Background color
addColorPalatOption($wp_customize, 'slider_buttonbghoverbrssColor', 'lz_fitness_premium_slider_section', 'Slider Button Hover Border Color', '#f9c12c');

