<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,700i,800,800i&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css?family=lato:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	 <script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?> 
</head>


<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'InsideTours' ); ?></a> -->
		<div id="loading-area">
			<div class="la-anim-10"></div>
		</div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header header-seo">
			<div class="header-inn"> 
				<div class="top-bar-head">
					<div class="up-header">
						<?php																	 
							$phone = get_theme_mod('luzuk_headermain_phone', '1800 123 456 789');	
																
						?>
						<div class="col-lg-4 col-md-4 col-sm-12"></div>
						<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 up-h-inn  ">
							<?php if($phone){ ?>
								<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 rtbo padding0">
									<div class="themetext">								
										<i class="fa fa-phone" aria-hidden="true"></i>
											<a class="phno" href="tel:<?php echo $phone;?>"><?php echo ($phone);?></a>
										<div class="clearfix"></div>
									</div>
									<!-- <button type="button" class="btn share-icn"><i class="fa fa-phone" aria-hidden="true"></i> </button>
									<div class="share-btn headphone">
										<a href="tel:<?php echo $phone;?>"><?php echo ($phone);  ?></a> 
									</div> -->
								</div>
							<?php } ?>
							<div class="col-lg-4 col-md-4 col-sm-4 col-xs-8 socialalign padding0">
								<?php
								$facebook = get_theme_mod('luzuk_header_fb', '//facebook.com/');
								$twitter = get_theme_mod('luzuk_header_tw', '//twitter.com/');
								$linkedIn = get_theme_mod('luzuk_header_in', '//linkedin.com/');
								$youtube = get_theme_mod('luzuk_header_yt', '//www.youtube.com/');
								?>
								<div class="header-social-links">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
										<a href="<?php echo $linkedIn ?>" target="_blank" title="linkedIn"><span class="fa fa-linkedin"></span></a>
									<?php }?>							
									
									<?php if(!empty($youtube)){ ?>
										<a href="<?php echo $youtube ?>" target="_blank" title="Youtube"><span class="fa fa-youtube"></span></a>
									<?php }?>
								</div>	
								<div class="clearfix"></div>
							</div>
							<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4 padding0">
			
							<?php if( get_theme_mod('cds_button_display','show' ) == 'show') :?>
								<div class="headenquiry">
								<?php
									$headerinquirytitle = get_theme_mod('luzuk_headermain_headerinquirytitle', 'Get Quick Quote'); 
									$headerinquiry = get_theme_mod('luzuk_header_headerinquiry', 'add link here');
									?>
									<?php if(!empty($headerinquiry)){ ?>
										<a href="<?php echo $headerinquiry ?>" ><?php echo ($headerinquirytitle);  ?></a>
									<?php }?> 
								</div>
							<?php endif ?>
							</div> 	
						</div>
						<div class="clearfix"></div>
					</div>
				<div class="clearfix"></div>
		<div class="col-md-12 low-header">
			<!-- <div class="container"> -->
				<div class="header-left logo col-lg-4 col-md-4 col-sm-4 col-xs-6 ">
				<?php 

					if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
						$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
					}
					?>
					<!-- website logo -->
					<div class="logo-header mostion">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
						<?php endif; ?>
					</div> 
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>  
					<!-- nav toggle button -->
					<div class="resp_header_logo">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
						<?php endif; ?>
					</div>
				</div>
				<div class="col-lg-8 col-md-8 col-sm-8 col-xs-6 head-menu">
					<div class="site-navigation ">
                        <div class="nav-menus">                 
							<a class="js-nav-toggle">
								<span></span>
							</a>
						    <div class="nav-wrapper">
								<nav role="navigation">
									<div class="nav-toggle">
											<span class="nav-back"></span>
											<span class="nav-title">Menu</span>
											<span class="nav-close"></span>
									</div>
									<?php
                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainm ht-clearfix',
                                                'container'=> 'ul',
                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                                'theme_location' => 'primary',  
                                            )); 
                                        } else {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainm ht-clearfix',
                                                'container'=> 'ul',
                                                'theme_location' => 'primary',  
                                            )); 
                                        }
                                    ?>
								</nav>
							</div>
						</div>
                        <nav class="navigation">
                            <div class="overlaybg"></div><!--  /.overlaybg -->
                            <!-- Main Menu -->
                            <div class="menu-wrapper">
                                <div class="menu-content">
                                    <?php
                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu ht-clearfix',
                                                'container'=> 'ul',
                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                                'theme_location' => 'primary',  
                                            )); 
                                        } else {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu ht-clearfix',
                                                'container'=> 'ul',
                                                'theme_location' => 'primary',  
                                            )); 
                                        }
                                    ?>
                                </div> <!-- /.hours-content-->
							<div class="clearfix"></div>
                            </div><!-- /.menu-wrapper --> 
                        </nav>
                        <div class="clearfix"></div>
                    </div><!--  /.site-navigation -->
				  </div>
				  
				<!-- </div> -->
			</div><!--low-header-->

		</div><!--top-bar-head-->
		<div class="clearfix"></div>
		</div> 		
	</header>
</div>
<!-- <script type="text/javascript">
    $( document ).ready(function() {
     $( "header .share-icn" ).click(function(e) {
         $('header .share-btn').not($(this).next( "header .share-btn" )).each(function(){
            $(this).removeClass("active");
         });
     
            $(this).next( "header .share-btn" ).toggleClass( "active" );
    });   
});
</script>  -->