<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'title_tagline', 'Tagline Color', '#4a4a4a');

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';

lzCustomLable($wp_customize, 'header_bgColorssettings', $sectionHeader, 'Header Setting');

//top header

// Phone call

$wp_customize->add_setting(
    'luzuk_headermain_phone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1800 123 456 789' )
    )
);
$wp_customize->add_control(
    'luzuk_headermain_phone',
    array(
        'settings'      => 'luzuk_headermain_phone',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'luzuk Themes Premium' )
    )
);

addColorPalatOption($wp_customize, 'header_ticonColor', 'header_settings', 'Top Header Phone Text Color', '#005394');

addColorPalatOption($wp_customize, 'header_tphiconColor', 'header_settings', 'Top Header Phone Icon Color', '#fddb1f');

addColorPalatOption($wp_customize, 'header_ticonhvColor', 'header_settings', 'Top Header Phone Text Hover Color', '#131313');

addColorPalatOption($wp_customize, 'header_tibgColor', 'header_settings', 'Header Background Color', '#fff');


lzCustomLable($wp_customize, 'luzuk_reservation_lblImgTxt', $sectionHeader, 'Social media icons Setting');

// FACEBOOK 
$wp_customize->add_setting('luzuk_header_fb',  array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_fb',
    array(
        'settings'      => 'luzuk_header_fb',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'Luzuk-premium' )
    )
);
// TWITTER
$wp_customize->add_setting('luzuk_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_tw',
    array(
        'settings'      => 'luzuk_header_tw',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'Luzuk-premium' )
    )
);

// LINKED IN
$wp_customize->add_setting('luzuk_header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_in',
    array(
        'settings'      => 'luzuk_header_in',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Linkedin Url', 'Luzuk-premium' )
    )
);

// Youtube IN
$wp_customize->add_setting('luzuk_header_yt',array('default'=> 'https://www.youtube.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_yt',
    array(
        'settings'      => 'luzuk_header_yt',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Youtube Url', 'gurukul' )
    )
);


addColorPalatOption($wp_customize, 'header_scliconColor', 'header_settings', 'Social Icon Color', '#757575');

addColorPalatOption($wp_customize, 'header_scliconbrdColor', 'header_settings', 'Social Icon Border Color', '#a69f9fb8');

addColorPalatOption($wp_customize, 'header_scliconhvColor', 'header_settings', 'Social Icon And Border Hover Color', '#fddb1f');


lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Colors');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus color', '#4a4a4a');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover color', '#1276c4');

addColorPalatOption($wp_customize, 'header_topmenusbgColor', 'header_settings', 'Menus Background color', '#e1e1e14d');

addColorPalatOption($wp_customize, 'header_topmenusbghoverColor', 'header_settings', 'Menus Background Hover color', '#fedb1f');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus color', '#1276c4');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus color', '#fff');

addColorPalatOption($wp_customize, 'header_topsubmenushvrColor', 'header_settings', 'Sub Menus Hover & Sub Menu Active color', '#000000');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Background color', '#1276c4');

addColorPalatOption($wp_customize, 'header_topsubmenushvranimatedbgColor', 'header_settings', 'Sub Menus Hover Animated Background color', '#fedb1f');

addColorPalatOption($wp_customize, 'header_topsubmenushvrbgColor', 'header_settings', 'Sub Menus Hover Background color', '#fedb1f');



lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#000');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuttlbgColor', 'header_settings', 'Menus Title BG Color', '#d5d5d5');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuColor', 'header_settings', 'Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'header_settings', 'Menus BG Color', '#0664ad');

lzCustomLable($wp_customize, 'header_MenuBtnsettings', $sectionHeader, 'Header Button Setting');


// to show & hide another button
$wp_customize->add_setting( 'cds_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_button_display', array( 'label' => 'Phone Button Display', 'section' => 'header_settings', 'settings' => 'cds_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
$wp_customize->add_setting(
    'luzuk_headermain_headerinquirytitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get Quick Quote' )
    )
);
$wp_customize->add_control(
    'luzuk_headermain_headerinquirytitle',
    array(
        'settings'      => 'luzuk_headermain_headerinquirytitle',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Header Button Text', 'Luzuk-premium' )
    )
);
$wp_customize->add_setting('luzuk_header_headerinquiry',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_headerinquiry',
    array(
        'settings'      => 'luzuk_header_headerinquiry',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Add "Header Button" link here', 'Luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'header_btnColor', 'header_settings', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'header_btnbgColor', 'header_settings', 'Button Background Color', '#ff9310');

addColorPalatOption($wp_customize, 'header_btnbghvColor', 'header_settings', 'Button Background Hover Color', '#013258');




//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#013258');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#fedb1f');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#000');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor1', 'colors', 'Inner page title background color one', '#dec416'); 
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor2', 'colors', 'Inner page title background color two', '#ffe000'); 

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading 1 Color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading 2 Color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading 3 Color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading 4 Color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading 5 Color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading 6 Color', '#2e2e2e');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlecolor', 'colors', 'Inner Page Sidebar Heading & Heading Border Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text Color', '#777777');


addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextcolcolor_color', 'colors', 'Other Text Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextbgsscolcolor_color', 'colors', 'Other Fields Background Color', '#fff');



addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links Color', '#4f4c4c');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover Color', '#fedb1f');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list Number Color', '#004072');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list Number Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & text field Border Color', '#e9e7e7');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & all text fields Border Color', '#e9e7e7');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaytxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaybgsstxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Background Color', '#777777');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettnavbackttoarrdisplay', 'colors', 'Color Setting For Navigation Back to top arrow:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbgcolor', 'colors', 'Site Navigation Arrow Color', '#004072');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbghvrcolor', 'colors', 'Site Navigation Arrow Hover Color', '#fedb1f');


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumb box title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumb box current title color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumb box current title hover color', '#000');
// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Blog Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'allblog_heading2label', 'luzuk_blogpage_settings', 'Post Heading Font Size Setting:');

$wp_customize->add_setting(
    'blogpages_innerpageheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogpages_innerpageheading2',
    array(
        'settings'      => 'blogpages_innerpageheading2',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Post Heading Font Size', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'allblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Date Display Setting:');

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button


lzCustomLable($wp_customize, 'singleblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post social Icons Display Setting:');


//for POSTPAGEsocialsshare to show & hide button

$wp_customize->add_setting( 'postsocialsshare_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postsocialsshare_button_display', array( 'label' => 'Post social Icons Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postsocialsshare_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Social Icons', 'hide' => 'Hide Social Icons', ), ) ); 

// end to show & hide button

//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialcolor', 'luzuk_blogpage_settings', 'Blog page social color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbgcolor', 'luzuk_blogpage_settings', 'Blog page social background color', '#004072');
//Blog page social hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialhovercolor', 'luzuk_blogpage_settings', 'Blog page social hover color', '#fddb1f');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbghovercolor', 'luzuk_blogpage_settings', 'Blog page social background hover color', '#fff');


lzCustomLable($wp_customize, 'blog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Button Display & Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'blogpage_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'blogpage_button_display', array( 'label' => 'Blog Button Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'blogpage_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


$wp_customize->add_setting(
    'blogbutninner_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Continue Reading', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogbutninner_text',
    array(
        'settings'      => 'blogbutninner_text',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Blog Button Text', 'luzuk-premium' )
    )
);

//Blog page button color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoncolor', 'luzuk_blogpage_settings', 'Blog Page Button & Bar Color', '#004072');
//Blog page button hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttonhovercolor', 'luzuk_blogpage_settings', 'Blog Page Button Hover Color', '#fddb1f');


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#002f54', get_template_directory_uri().'/images/footer-bg.png', 'image');

addColorPalatOption($wp_customize, 'footerarea_overlay_color', 'footer_area', 'Footer Overlay Color', '#002f54');


lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Set Footer Section Padding:');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_areabottomfPadding', 'footer_area', 'Set Bottom Footer Padding:');

$wp_customize->add_setting(
    'sec_bottomareaTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '30px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareaTmargin',
    array(
        'settings'      => 'sec_bottomareaTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_bottomareabottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '50px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareabottommargin',
    array(
        'settings'      => 'sec_bottomareabottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text:');


$wp_customize->add_setting(
    'footer_termtitle1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Copyright © 2024 Agency WordPress Themes. All rights reserved.' )
    )
);
$wp_customize->add_control(
    'footer_termtitle1',
    array(
        'settings'      => 'footer_termtitle1',
        'section'       => 'footer_area',
        'type'          => 'text',
        'description' => __('<b>This feature is only available in the premium version.</b>', 'luzuk-premium'),
        'label'         => __( 'Tearm Text', 'luzuk-premium' ),
        'input_attrs' => array(
			'readonly' => 'readonly',
		),
    )
);

$wp_customize->add_setting(
    'footer_termtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Terms of Service' )
    )
);
$wp_customize->add_control(
    'footer_termtitle',
    array(
        'settings'      => 'footer_termtitle',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Tearm Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('footer_termlink',   array('default'=> ' Add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_termlink',
    array(
        'settings'      => 'footer_termlink',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Add tearm link here', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'footer_privacytitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Privacy Policy' )
    )
);
$wp_customize->add_control(
    'footer_privacytitle',
    array(
        'settings'      => 'footer_privacytitle',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Privacy Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('footer_privacylink',   array('default'=> ' Add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_privacylink',
    array(
        'settings'      => 'footer_privacylink',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Add privacy link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'footerarea_Copyrightbg_color', 'footer_area', 'Footer Copyright Text Background Color', '#001e36');

//theme Footer title Color
addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Footer Title Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Footer Text Color', '#fff');
addColorPalatOption($wp_customize, 'footerarea_hglightsctext_color', 'footer_area', 'Footer Hightlight Text Color', '#fddb1f');
//addColorPalatOption($wp_customize, 'footerarea_icon_color', 'footer_area', 'Footer Icon Color', '#f72985');
addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Footer Social Icon Color', '#6a6a6a');
addColorPalatOption($wp_customize, 'footerarea_siconhover_color', 'footer_area', 'Footer Social Icon Hover Color', '#fddb1f');

addColorPalatOption($wp_customize, 'footerarea_siconbg_color', 'footer_area', 'Footer Social Icon Background Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_conicon_color', 'footer_area', 'Footer Contact Icon Color', '#fddb1f');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Footer Menu Color', '#fff');
addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Footer Menu Hover Color', '#fddb1f');
addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Active Menu  Color', '#fddb1f');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#fff');
addColorPalatOption($wp_customize, 'footerarea_tableborder_color', 'footer_area', 'Border Color', '#547186');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#fff');
addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formbuttontext_color', 'footer_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerareabutton_border_color', 'footer_area', 'Button Background Color', '#fddb1f');

addColorPalatOption($wp_customize, 'footerareabutton_bghv_color', 'footer_area', 'Button Background Hover Color', '#ff9310');

addColorPalatOption($wp_customize, 'footerarea_otherfbgs_color', 'footer_area', 'Other Fields Background Color', '#003f71');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_servicepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:'); 


lzCustomLable($wp_customize, 'luzuk_servicepagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Services page images of equal height.');


addColorPalatOption($wp_customize, 'luzuk_InnerServiceTitleColor', 'luzuk_innerpageshortcode_page_settings', 'Services Title Color', '#1a67d3');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTitlehoverColor', 'luzuk_innerpageshortcode_page_settings', 'Services Title Hover Color', '#ff9310');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTextColor', 'luzuk_innerpageshortcode_page_settings', 'Services Text Color', '#131313');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceimghoveroverlaybgColor1', 'luzuk_innerpageshortcode_page_settings', 'Services Image Hover Color', '#ff9310');

addColorPalatOption($wp_customize, 'luzuk_InnerServicebxbrdhvclr', 'luzuk_innerpageshortcode_page_settings', 'Services Box Boeder Hover Color', '#ff9310');



lzCustomLable($wp_customize, 'luzuk_teaminnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_teampagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Team member images of equal height.');

addColorPalatOption($wp_customize, 'pages_innerteamimghoveroverlayColor1', 'luzuk_innerpageshortcode_page_settings', 'Select Team Image Hover Background Color One', '#004072');
addColorPalatOption($wp_customize, 'pages_innerteamimghoveroverlayColor2', 'luzuk_innerpageshortcode_page_settings', 'Select Team Image Hover Background Color Two', '#018dfa');

addColorPalatOption($wp_customize, 'pages_innerTeamNameCColor', 'luzuk_innerpageshortcode_page_settings', 'Select Team Member Color', '#1d65d3');

addColorPalatOption($wp_customize, 'pages_innerTeamNobxCColor', 'luzuk_innerpageshortcode_page_settings', 'Select Team Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'pages_innerTeamNamehoverCColor', 'luzuk_innerpageshortcode_page_settings', 'Select Team Member Hover Color', '#ff9310');

addColorPalatOption($wp_customize, 'pages_innerTeamDesignationCColor', 'luzuk_innerpageshortcode_page_settings', 'Select Team Designation Color', '#000');

addColorPalatOption($wp_customize, 'pages_innerTeamTextCColor', 'luzuk_innerpageshortcode_page_settings', 'Select Team Text Color', '#666666');

addColorPalatOption($wp_customize, 'pages_innerTeamsocialsColor', 'luzuk_innerpageshortcode_page_settings', 'Select Team Socials Color', '#004072');
addColorPalatOption($wp_customize, 'pages_innerTeamsocialshvrsColor', 'luzuk_innerpageshortcode_page_settings', 'Select Team Socials Hover Color', '#ff9310');


lzCustomLable($wp_customize, 'luzuk_testimonialinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_box2color', 'luzuk_innerpageshortcode_page_settings', 'Select Box Background Color 1', '#004072');

 addColorPalatOption($wp_customize, 'luzuk_innertestimonials_box1color', 'luzuk_innerpageshortcode_page_settings', 'Select Box Background Color 2', '#018dfa');

 addColorPalatOption($wp_customize, 'luzuk_innertestimonials_boxbrd', 'luzuk_innerpageshortcode_page_settings', 'Box Border Color ', '#ff9310');
 
addColorPalatOption($wp_customize, 'luzuk_innertestimonials_textcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Content Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_Namecolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_degNamecolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Designation Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_imgoverlaycolor1', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Background Color ', '#ff9310');




lzCustomLable($wp_customize, 'luzuk_galleryinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_galleryinnerpagegallresclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Note: Kindly Use Gallery image of same resolution. Recomended image size is 650x500');

addColorPalatOption($wp_customize, 'pages_innerimghoveroverlayColor1', 'luzuk_innerpageshortcode_page_settings', 'Select Image Hover Color', '#004072');

addColorPalatOption($wp_customize, 'pages_innerimghoveroverlayColor2', 'luzuk_innerpageshortcode_page_settings', 'Select Image Border Hover Color', '#fddb1f');

lzCustomLable($wp_customize, 'luzuk_faqinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

 addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Icon Color', '#004072');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Text Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select Question Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextcColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Text Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg1Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color One', '#018dfa');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg2Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color Two', '#004072');


$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpage_titlepaddset', 'luzuk_innerpagefont_settings', ' Set Header Title Box Padding:');

$wp_customize->add_setting(
    'inner_headertitleboxTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxTpadding',
    array(
        'settings'      => 'inner_headertitleboxTpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'inner_headertitleboxBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxBpadding',
    array(
        'settings'      => 'inner_headertitleboxBpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_innerpageh1_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '35px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);


lzCustomLable($wp_customize, 'luzuk_innerpageh2_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);
 

lzCustomLable($wp_customize, 'luzuk_innerpageh3_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh4_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh5_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '17px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh6_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '16px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);