<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'luzuk_about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_about_area_disable',
            array(
                'settings'      => 'luzuk_about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'about', 'about_area', $color='#f9f9f9', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


  $wp_customize->add_setting(
        'about_image_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'about_image_heading',
            array(
                'settings'      => 'about_image_heading',
                'section'       => 'about_area',
                'label'         => __( 'Left Image', 'luzuk-premium' ),
            )
        )
    );

      $wp_customize->add_setting(
        'about_image',
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'about_image',
            array(
                'section' => 'about_area',
                'settings' => 'about_image',
                'description' => __('Recommended Image Size: 525X650px', 'luzuk-premium')
            )
        )
    );


    $wp_customize->add_setting(
        'about_title_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'about_title_heading',
            array(
                'settings'      => 'about_title_heading',
                'section'       => 'about_area',
                'label'         => __( 'Section Heading, Section Text', 'luzuk-premium' ),
            )
        )
    );    

    $wp_customize->add_setting(
        'about_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'About Us', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'about_title',
        array(
            'settings'      => 'about_title',
            'section'       => 'about_area',
            'type'          => 'text',
            'label'         => __( 'Section Heading', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'about_area_sectitle_color', 'about_area', 'Heading Color ', '#2b3f59');

addColorPalatOption($wp_customize, 'about_area_sectitlebrd_color', 'about_area', 'Heading Border & Icon Color ', '#ff9310');

    $wp_customize->add_setting(
        'about_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed vitae ante a nibh ornare tristique laoreet ac odio. Donec ac eleifend lacus. Etiam bibendum nec mi non consequat. ', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'about_text',
        array(
            'settings'      => 'about_text',
            'section'       => 'about_area',
            'type'          => 'textarea',
            'label'         => __( 'Section Text', 'luzuk-premium' )
        )
    );
addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Section Text color', '#535353');


$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'about_area',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_area',
        'type'          => 'select',
        'label'         => __( 'Number of About plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'About Page ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-check',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'about_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Consectetur Adipcing');  
}


lzCustomLable($wp_customize, 'about_colors', 'about_area', 'Section Color Setting');

addColorPalatOption($wp_customize, 'about_area_pageicon', 'about_area', 'About Page Icon color', '#2b3f59');

addColorPalatOption($wp_customize, 'about_area_pageiconhv', 'about_area', 'About Page Icon Hover color', '#fddb1f');

addColorPalatOption($wp_customize, 'about_area_pageiconbg', 'about_area', 'About Page Icon Background color', '#fddb1f');

addColorPalatOption($wp_customize, 'about_area_pageiconbghv', 'about_area', 'About Page Icon Background Hover color', '#2b3f59');

addColorPalatOption($wp_customize, 'about_area_pagetitle', 'about_area', 'About Page Icon Text Color', '#535353');

addColorPalatOption($wp_customize, 'about_area_pagetitlehv', 'about_area', 'About Page Icon Text Hover Color', '#fddb1f');


lzCustomLable($wp_customize, 'lz_fitness_premium_aboutus_lblbutton1display', 'about_area', 'About Us Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'aboutscd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'aboutscd_button_display', array( 'label' => 'Button Display', 'section' => 'about_area', 'settings' => 'aboutscd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'lz_fitness_headermain_aboutreadmore1button',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'LEARN MORE' )
    )
);
$wp_customize->add_control(
    'lz_fitness_headermain_aboutreadmore1button',
    array(
        'settings'      => 'lz_fitness_headermain_aboutreadmore1button',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('lz_fitness_header_aboutreadmore1buttonlink',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_aboutreadmore1buttonlink',
    array(
        'settings'      => 'lz_fitness_header_aboutreadmore1buttonlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Button Url', 'luzuk' )
    )
);



addColorPalatOption($wp_customize, 'about_area_btntitle', 'about_area', 'About Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_btntitleicon', 'about_area', 'About Button Icon Color', '#fddb1f');

addColorPalatOption($wp_customize, 'about_area_btntitleiconhv', 'about_area', 'About Button Icon And Text HoverColor', '#004072');

addColorPalatOption($wp_customize, 'about_area_btnbg', 'about_area', 'About Button Background Color', '#004072');

addColorPalatOption($wp_customize, 'about_area_btnbghv', 'about_area', 'About Button Background  Hover Color', '#fddb1f');

