<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'premium_slider_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'premium_slider_show_content',
		array(
			'settings'      => 'premium_slider_show_content',
			'section'       => 'premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			),
		)
	)
);

$wp_customize->add_setting('luzuk_premium_slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'luzuk_premium_slider_section_lbl',
		array(
			'settings'		=> 'luzuk_premium_slider_section_lbl',
			'section'		=> 'premium_slider_section',
			'label'			=> __( 'Note:', 'luzuk-premium' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'luzuk-premium' ),
		)
	)
);

backgroundManager($wp_customize, 'slider', 'premium_slider_section', $color='#fff', get_template_directory_uri().'/images/banner-bg.jpg', 'color');


// Slider Overlay color
addColorPalatOption($wp_customize, 'slider_OverlayColor', 'premium_slider_section', 'Slider Overlay Color', '#0664ad');


// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'premium_slider_section', 'Slider Title Color', '#fddb1f');

// Slider Title highlight color
addColorPalatOption($wp_customize, 'slider_TitlehighlightColor', 'premium_slider_section', 'Slider Sub Title Color', '#fff');

// Slider Sub Title color
addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'premium_slider_section', 'Slider Text Color', '#fff');

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'premium_slider_section', 'Slider Button Text Color', '#fff');


// Slider Button Text hover color
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'premium_slider_section', 'Slider Button Text Hover Color', '#013258');

// Slider Button Icon color
addColorPalatOption($wp_customize, 'slider_buttonborderColor', 'premium_slider_section', 'Slider Button Icon Color', '#fddb1f');

// Slider Button Icon Hover color
addColorPalatOption($wp_customize, 'slider_buttonborderhvColor', 'premium_slider_section', 'Slider Button Icon Hover Color', '#013258');

// Slider Button Background color
addColorPalatOption($wp_customize, 'slider_buttonbgColor', 'premium_slider_section', 'Slider Button Background  Color', '#013258');

// Slider Button Background  color
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'premium_slider_section', 'Slider Button Background Hover Color', '#fddb1f');


// Slider image border color
addColorPalatOption($wp_customize, 'slider_imgborder1Color', 'premium_slider_section', 'Slider Image Border Color', '#fff');

// addColorPalatOption($wp_customize, 'slider_imgborder2Color', 'premium_slider_section', 'Slider Image Border Two Color', '#fddb1f');


// Slider Button Background  color
addColorPalatOption($wp_customize, 'slider_buttonarwbrdColor', 'premium_slider_section', 'Slider Arrow Button Border Color', '#000');

addColorPalatOption($wp_customize, 'slider_buttonarwbrdhvColor', 'premium_slider_section', 'Slider Arrow Button Border Hover Color', '#ff9310');

addColorPalatOption($wp_customize, 'slider_brdColor', 'premium_slider_section', 'Slider Border Color', '#fedb1f');