<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header mo-left header-seo">
			
			<div class="clearfix">
				<div class="top-bar-head">
						<?php 
							$context = get_theme_mod('headermain_context', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed');
							$dytime = get_theme_mod('headermain_dytime', 'Mon - Fri: 8:00 am - 7:00 pm');
				
							$headerinquirytitle = get_theme_mod('headermain_btntitle', 'Get Appointment'); 
							$headerinquiry = get_theme_mod('header_btnlink', '#');
						?>
				<?php if($context || $dytime || $headerinquirytitle || $headerinquiry ) { ?>	
					<div class="header-contact">
						<div class="container">
							
							<div class="col-md-10 padding0 head-inn">
								<div class="col-md-7 padding0">
									<div class="header-text">
										<?php echo $context ;?>
									</div>
								</div>
								<div class="col-md-5">
									<div class="header-dtime">
										<?php if($dytime){ ?>
										<li ><i class="fa fa-clock-o" aria-hidden="true"></i>
										<?php echo $dytime ;?></li>
										<?php } ?>
									</div>
								</div>
							</div>
							<div class="headerbtn col-md-2 padding0">
								
							<?php if( get_theme_mod('cds_button_display','show' ) == 'show') :
								?>
								<div class="header-btn">
									
									<?php if(!empty($headerinquiry)){ ?>
										<div class='head-button'><a href="<?php echo $headerinquiry ?>" title="<?php echo ($headerinquirytitle);?>"><?php echo ($headerinquirytitle);  ?></a></div>
									<?php }?> 
								</div>
							<?php endif ?>
						<!-- </div> -->
							</div>
						</div> 
						<div class="clearfix"></div>
					</div>
					<div class="clearfix"></div>
				<?php } ?> 
				<!-- </div> -->
				<div class="clearfix"></div>
				<div class="container">
					<div class="row row-eq-height logo-m-view">	
						<div class="logo-lhs col-sm-4 col-xs-12 ">
						<?php 	
							$email = get_theme_mod('headermain_email', 'needhelp@tailor.com');
						?>
							<ul class="hd-contact">
								<?php if($email){ ?>
								<li class="mailto"><i class="fa fa-envelope" aria-hidden="true"></i><a href="mailto:<?php echo $email;?>"><?php echo $email ;?></a>
								</li>
								<?php } ?>
							</ul>
						</div>				
						<div class="logo col-md-4 col-sm-4 col-xs-12">
							<div class="inside-full-height">
						<?php 
						
							if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
								$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
							}
							if( get_theme_mod('pages_logoTpadding',true) ) {
								$pages_logoTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTpadding')).';';
							}
							if( get_theme_mod('pages_logoBpadding',true) ) {
								$pages_logoBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBpadding')).';';
							}
							if( get_theme_mod('pages_logoLpadding',true) ) {
								$pages_logoLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLpadding')).';';
							}
							if( get_theme_mod('pages_logoRpadding',true) ) {
								$pages_logoRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRpadding')).';';
							}

						?>
							<!-- website logo -->
								<div class="logo-header mostion">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
								</div> 
								<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>  
							<!-- nav toggle button -->
								<div class="resp_header_logo">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
										<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
									<?php endif; ?>
								</div>
							</div>
						</div>
						<div class="logo-rhs col-sm-4 col-xs-12 ">
						<?php 
								
							$facebook = get_theme_mod('header_fb', '//facebook.com/');
							$twitter = get_theme_mod('header_tw', '//twitter.com/');
							$instagram = get_theme_mod('header_insta', 'https://www.instagram.com/');
							$youtube = get_theme_mod('header_you', '//youtube.com/');
							?>
							<div class="header-share"> 
									<div class="share-btn">
										<ul>
											<?php if(!empty($facebook)){ ?>
												<li><a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a></li>
											<?php }?>

											<?php if(!empty($twitter)){ ?>
												<li><a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa fa-twitter"></i></a></li>
											<?php }?>
											<?php if(!empty($instagram)){ ?>
												<li><a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
											<?php }?>
											<?php if(!empty($youtube)){ ?>
												<li><a href="<?php echo $youtube ?>" title="Youtube" class="site-button sharp" target="_blank"><i class="fa fa-youtube-play" aria-hidden="true"></i></a></li>
											<?php }?>
											<div class="clearfix"></div>
										</ul>
									</div>
									<div class="clearfix"></div>
								</div>
						</div>
				  	</div>
		  	
		  	<!-- <div class="header-right col-md-8 col-sm-9 col-xs-6"> -->
				<div class="header-right">
					<div class="hd-b-area "></div>
					<div class="row ">
						<!-- <div class="inner-nav-clip pd-0"> -->
						<div class="head-menu col-md-10 col-sm-11">
							<div class="inside-full-height">
								<div class="site-navigation ">
			                        <div class="hamburger-menus">
			                            <span></span>
			                            <span></span>
			                            <span></span>
			                            <span></span>
			                            <span></span>
			                            <span></span>
			                            <span></span>
			                            <span></span>
			                            <span></span>
			                        </div>
			                        <nav class="navigation">
	                            		<div class="overlaybg"></div><!--  /.overlaybg -->
	                            <!-- Main Menu -->
			                            <div class="menu-wrapper">
			                                <div class="menu-content">
			                                    <?php
			                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
			                                            wp_nav_menu ( array(
			                                                'menu_class' => 'mainmenu ht-clearfix',
			                                                'container'=> 'ul',
			                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
			                                                'theme_location' => 'primary',  
			                                            )); 
			                                        } else {
			                                            wp_nav_menu ( array(
			                                                'menu_class' => 'mainmenu ht-clearfix',
			                                                'container'=> 'ul',
			                                                'theme_location' => 'primary',  
			                                            )); 
			                                        }
			                                    ?>
			                                </div> <!-- /.hours-content-->
											<div class="clearfix"></div>
			                            </div><!-- /.menu-wrapper --> 
						                <?php 
											$phone = get_theme_mod('headermain_phone', '+123 456 7890');
											$phonetext = get_theme_mod('headermain_phonetext', 'CALL US NOW');
										?>
									 	<div class="mobnone">
											<div class=" header-phone">
												<a class="phno" href="tel:<?php echo $phone;?>"><?php echo $phone ;?></a><br>
												<?php echo $phonetext ;?>
											</div>
										</div>
	                        		</nav>
								 	<div class="clearfix"></div>
								</div><!--  /.site-navigation -->
							</div>
						</div>
							<?php if( get_theme_mod('mnu_button_display','show' ) == 'show') :
							?>
							<?php 
									$phone = get_theme_mod('headermain_phone', '+123 456 7890');
									$phonetext = get_theme_mod('headermain_phonetext', 'CALL US NOW');
								?>
								<?php if($phone || $phonetext ){ ?>
								<div class="menubtn col-md-2">
									<div class=" header-phone">
										<a class="phno" href="tel:<?php echo $phone;?>"><?php echo $phone ;?></a><br>
										<?php echo $phonetext ;?>
									
									</div>
								</div>
								<?php } ?>
							<?php endif ?>
						<!-- </div> -->
						<div class="clearfix"></div>
					</div>
					<div class="clearfix"></div>
				</div>
				<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="clearfix"></div>
	</div>			
	<div class="clearfix"></div>
</header>
</div>
