<?php
$wp_customize->add_section(
    'aboutus_section',
    array(
        'title' => __( 'About Us Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'aboutus_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'aboutus_section_disable',
        array(
            'settings'      => 'aboutus_section_disable',
            'section'       => 'aboutus_section',
            'label'         => __( 'Disable/ Enable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'about', 'aboutus_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'sec_aboutpadding', 'aboutus_section', 'Section Padding');

$wp_customize->add_setting(
    'aboutTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutTpadding',
    array(
        'settings'      => 'aboutTpadding',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'aboutBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutBpadding',
    array(
        'settings'      => 'aboutBpadding',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'About Heading & Sub Heading', 'Luzuk' ),
        )
    )
);   

$wp_customize->add_setting(
    'about_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_subtitle',
    array(
        'settings'      => 'about_subtitle',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading ', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'abou_subheadclr', 'aboutus_section', 'Section Sub Heading Color', '#9fd5f1'); 

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Welcome to Premium Tailor Store Theme!', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'aboutus_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Heading ', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'aboutReservation_SectionttlColor', 'aboutus_section', 'Section Heading Color', '#393c6f'); 

addColorPalatOption($wp_customize, 'about_haedbrd1', 'aboutus_section', 'Section Heading Border Color One', '#9fd5f1');
addColorPalatOption($wp_customize, 'about_haedbrd2', 'aboutus_section', 'Section Heading Border Color Two', '#393c6f');

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices  gravida. Risus commodo viverra.', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings' =>'about_text',
        'section' => 'aboutus_section',
        'type'=> 'textarea',
        'label'=> __('Content for the section', 'Luzuk')
    )
);

addColorPalatOption($wp_customize, 'aboutReservation_alltxtColor', 'aboutus_section', 'Section Text Color', '#bababa'); 


$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'aboutus_section',
        'type'          => 'select',
        'label'         => __( 'Number of About plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 4; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'aboutus_section',
                'label'         => __( 'About Page ', 'luzuk-premium' ).$i
            )
        )
    );

    //  $wp_customize->add_setting(
    //     'aboutus_page_icon'.$i,
    //     array(
    //         'default'           => 'fa fa-arrow-right',
    //         'sanitize_callback' => 'luzuk_sanitize_text'
    //     )
    // );        
    // $wp_customize->add_control(
    //     new luzuk_Fontawesome_Icon_Chooser(
    //         $wp_customize,
    //         'aboutus_page_icon'.$i,
    //         array(
    //             'settings'      => 'aboutus_page_icon'.$i,
    //             'section'       => 'aboutus_section',
    //             'type'          => 'icon',
    //             'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
    //         )
    //     )
    // );

    lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'aboutus_section', $type = 'textarea', $label="Title", $callback ='luzuk_sanitize_text', $default='This is a education sit amet, consectetur adipiscing elit.');  
}


lzCustomLable($wp_customize, 'about_lblbuttonabtdisplay', 'aboutus_section', 'Section Frist Button Display & Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'about_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_button_display', array( 'label' => 'Button Display', 'section' => 'aboutus_section', 'settings' => 'about_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
    'aboutus_abtbtntitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Request Service' )
    )
);
$wp_customize->add_control(
    'aboutus_abtbtntitle',
    array(
        'settings'      => 'aboutus_abtbtntitle',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Frist Button Text', 'Luzuk' )
    )
);
$wp_customize->add_setting('aboutus_abtbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('aboutus_abtbtnlink',
    array(
        'settings'      => 'aboutus_abtbtnlink',
        'section'       => 'aboutus_section',
        'type'          => 'url',
        'label'         => __( 'Add "Button link" here', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'about_color', 'aboutus_section', 'Section Color Setting');

addColorPalatOption($wp_customize, 'about_icntxtColor', 'aboutus_section', 'Section Title Color', '#bababa'); 

addColorPalatOption($wp_customize, 'aboutReservation_btntxtColor', 'aboutus_section', 'Section Frist Button Text Color', '#fff'); 
addColorPalatOption($wp_customize, 'aboutReservation_btntxthvrsColor', 'aboutus_section', 'Section Frist Button Text Hover Color', '#000'); 
addColorPalatOption($wp_customize, 'aboutReservation_btnbackgColor1', 'aboutus_section', 'Section Frist Button Background Color', '#393c6f'); 
addColorPalatOption($wp_customize, 'aboutReservation_btnbackghvrsColor1', 'aboutus_section', 'Section Frist Button Background Hover Color', '#9fd5f1'); 

lzCustomLable($wp_customize, 'about_2ndvtn', 'aboutus_section', 'Section Second Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'about_button1_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_button1_display', array( 'label' => 'Button Display', 'section' => 'aboutus_section', 'settings' => 'about_button1_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
    'abtbtntitle1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Know More' )
    )
);
$wp_customize->add_control(
    'abtbtntitle1',
    array(
        'settings'      => 'abtbtntitle1',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Second Button Text', 'Luzuk' )
    )
);
$wp_customize->add_setting('abtbtnlink1',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink1',
    array(
        'settings'      => 'abtbtnlink1',
        'section'       => 'aboutus_section',
        'type'          => 'url',
        'label'         => __( 'Add "Button link" here', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'about_2btntxtclr', 'aboutus_section', 'Section Second Button Text Color', '#393c6f'); 
addColorPalatOption($wp_customize, 'about_2btntxthvclr', 'aboutus_section', 'Section Second Button Text Hover Color', '#fff');
addColorPalatOption($wp_customize, 'about_2btnbgclr', 'aboutus_section', 'Section Second Button Background Color', '#fff');
addColorPalatOption($wp_customize, 'about_2btnbghvclr', 'aboutus_section', 'Section Second Button Background Hover Color', '#393c6f');
addColorPalatOption($wp_customize, 'about_2btnbrdclr', 'aboutus_section', 'Section Second Button Border Color', '#393c6f');

lzCustomLable($wp_customize, 'about_circle', 'aboutus_section', 'Section Circle Text Setting');

$wp_customize->add_setting(
    'abtnum',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '06+', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtnum',
    array(
        'settings'      => 'abtnum',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Circle Number ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'abtnumtext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Years Of Exp.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtnumtext',
    array(
        'settings'      => 'abtnumtext',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Circle Number Text ', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'about_numclr', 'aboutus_section', 'Section Circle Number Color', '#85c4bc'); 
addColorPalatOption($wp_customize, 'about_numxtclr', 'aboutus_section', 'Section Circle Text Color', '#393c6f'); 
addColorPalatOption($wp_customize, 'about_numxbgclr', 'aboutus_section', 'Section Circle Background Color', '#fff'); 

$wp_customize->add_setting(
        'abt_image_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'abt_image_heading',
        array(
            'settings'      => 'abt_image_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'About Section Right Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'abt_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'abt_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'abt_image',
            'description' => __('Recommended Image Size: 400X550px', 'luzuk-premium')
        )
    )
);

addColorPalatOption($wp_customize, 'about_imhtpbrdclr', 'aboutus_section', 'Section Image Top Border Color', '#393c6f'); 
addColorPalatOption($wp_customize, 'about_imhbttmbrdclr', 'aboutus_section', 'Section Image Bottom Border Color', '#85c4bc'); 
addColorPalatOption($wp_customize, 'about_imhbttmcrclclr', 'aboutus_section', 'Section Image Circle Color', '#edf0f5'); 
addColorPalatOption($wp_customize, 'about_tpcrclclr', 'aboutus_section', 'Section Top Small Circle Color', '#9fd5f1');
addColorPalatOption($wp_customize, 'about_bttmcrclclr', 'aboutus_section', 'Section Bottom Small Circle Color', '#393c6f'); 

addColorPalatOption($wp_customize, 'about_lftsvgclr', 'aboutus_section', 'Section Left Svg Shape Color', '#e6f4fb'); 
addColorPalatOption($wp_customize, 'about_rightsvgclr', 'aboutus_section', 'Section Right Svg Shape Color', '#393c6f'); 