<?php
/**
 * The template for displaying archive pages.
 *
 * Used for displaying archive-type pages. These views can be further customized by
 * creating a separate template for each one.
 *
 * - author.php (Author archive)
 * - category.php (Category archive)
 * - date.php (Date archive)
 * - tag.php (Tag archive)
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 */
?>
<?php get_header(); ?>
 <header class="page-main-header">
    <div class="container">
        <h1 class="ht-main-title"><?php single_cat_title(''); ?></h1>
        <div class="clearfix"></div>
    </div>
</header><!-- .entry-header --> 
<?php 
            if( get_theme_mod('innerpagesbox_toppadding',true) ) {
                $innerpagesbox_toppadding = 'padding-top:'.esc_attr(get_theme_mod('innerpagesbox_toppadding')).';';
            }
            if( get_theme_mod('innerpagesbox_bottompadding',true) ) {
                $innerpagesbox_bottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('innerpagesbox_bottompadding')).';';
            }
            if( get_theme_mod('innerpagesbox_leftpadding',true) ) {
                $innerpagesbox_leftpadding = 'padding-left:'.esc_attr(get_theme_mod('innerpagesbox_leftpadding')).';';
            }
            if( get_theme_mod('innerpagesbox_rightpadding',true) ) {
                $innerpagesbox_rightpadding = 'padding-right:'.esc_attr(get_theme_mod('innerpagesbox_rightpadding')).';';
            }
    ?>

<main id="innerpage-box" style="<?php echo esc_attr($innerpagesbox_toppadding); ?>" "<?php echo esc_attr($innerpagesbox_bottompadding); ?>" "<?php echo esc_attr($innerpagesbox_leftpadding); ?>" "<?php echo esc_attr($innerpagesbox_rightpadding); ?>">
    <div class="container">
        <div id="blog-box" class="col-md-9 innerpage-whitebox">
            
                <?php if ( have_posts() ) :
                    $luzuk_lite_full_posts = get_theme_mod('luzuk_lite_full_posts');
                    while ( have_posts() ) : the_post();
                        luzuk_lite_archive_post();
                    endwhile;
                    luzuk_lite_post_navigation();
                endif; ?>
            
        </div>
        <div class="col-md-3">
            <div id="secondary" class="widget-area">
                <?php dynamic_sidebar('luzuk-blog-sidebar'); ?>
            </div>
        </div>
        <div class="clearfix"></div>
        
        <div class="row">
            <div class="col-md-12">
                <div class="pagingation">
                    <?php lzGetPagination($query);?>
                </div>
            </div>
        </div>
    </div>
</main>
<?php get_footer(); ?>
