<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Raleway:600" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Raleway:300,400" rel="stylesheet">
	
	<!-- <script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script> -->
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'Luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<header class="site-header header-transparent header mo-left header-seo" id="myHeader">

		

			<div class="top-header"> 

				<div class="header-left col-md-4 col-sm-12 col-md-offset-1">
				<?php 
					if( get_theme_mod('pages_logoTmargin',true) ) {
		                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
		            }
		            if( get_theme_mod('pages_logoBmargin',true) ) {
		                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
		            }
		            if( get_theme_mod('pages_logoLmargin',true) ) {
		                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
		            }
		            if( get_theme_mod('pages_logoRmargin',true) ) {
		                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
		            }
		            if( get_theme_mod('pages_logomaxwidth',true) ) {
		                $pages_logomaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logomaxwidth')).';';
		            }

				?>
				<div class="logobox" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>" "<?php echo esc_attr($pages_logomaxwidth); ?>" >
					<?php 
					if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
						the_custom_logo();
				else : 
					if ( is_front_page() ) : ?>
						<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php endif; ?>
					<?php endif; ?>
					<!-- .site-branding -->
					<div class="clearfix"></div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
				</div>
				<div class="clearfix"></div>
			</div>
			<div class="header-right col-md-7 padding0">
				<div class="header-box">
						<?php 
						
							$facebook = get_theme_mod('luzuk_header_fb', '//facebook.com/');
							$twitter = get_theme_mod('luzuk_header_tw', '//twitter.com/');
							$googlePlus = get_theme_mod('luzuk_header_it', '//plus.google.com/');
							$linkedIn = get_theme_mod('luzuk_header_in', '//linkedin.com/');
							$youtube = get_theme_mod('luzuk_header_yt', '//www.youtube.com/');
							$instagram = get_theme_mod('header_insta', '//www.instagram.com/');
						?>
							<?php if($facebook || $twitter || $googlePlus || $instagram || $linkedIn || $youtube){ ?>

						<div class="col-md-9 col-md-offset-3 col-sm-12 upper-header padding0">					
						<div class="header-social-links">
								<?php if(!empty($facebook)){ ?>
									<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
								<?php }?>
								<?php if(!empty($twitter)){ ?>
									<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
								<?php }?>
								<?php if(!empty($googlePlus)){ ?>
									<a href="<?php echo $googlePlus ?>" target="_blank" title="Google Plus"><span class="fa fa-google-plus"></span></a>
								<?php }?>
								<?php if(!empty($linkedIn)){ ?>
									<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
								<?php }?>
								<?php if(!empty($youtube)){ ?>
									<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
								<?php }?>
								<?php if(!empty($instagram)){ ?>
									<a href="<?php echo $instagram ?>" target="_blank" title="Instagram"><span class="fa fa-instagram"></span></a>
								<?php }?>
							</div>
						<div class="clearfix"></div>
					</div>
						<?php }?>

					<div class="col-md-8 col-md-offset-3 col-sm-12">
						<?php 
						$email = get_theme_mod('luzuk_header_email', 'contact@example.com');
						$phone = get_theme_mod('luzuk_header_phone', '+1 999 999 9999');
						$emaillabel = get_theme_mod('luzuk_header_emaillabel', 'EMAIL SUPPORT');
						$phonelabel = get_theme_mod('luzuk_header_phonelabel', 'CALL SUPPORT');
							//$time = get_theme_mod('luzuk_contactus_time', 'Mon-Sat 0900-1900');
						?>
						<div class="header-right-box">
							<div class="col-md-6 col-sm-6">	
								<div class="contact-border">
									<?php if($emaillabel || $email){ ?>
									<div class="themetext"><?php echo $emaillabel;?></div>
									<div class="mailto"><a href="mailto:<?php echo $email;?>"><?php echo $email;?></a></div>
									<?php } ?>
								</div>
								<div class="clearfix"></div>
							</div>
							<div class="col-md-6 col-sm-6">	
								<div class="contact-border">
									<?php if($phonelabel || $phone){ ?>
									<div class="themetext"><?php echo $phonelabel;?></div>
									<div><?php echo $phone;?></div>
									<?php } ?>
								</div>
								<div class="clearfix"></div>
							</div>
							
								<div class="clearfix"></div>
							</div>

						</div>
						<div class="clearfix"></div>	
					</div><!--header-box-->
				</div>				
				<div class="clearfix"></div>
				<div class="sticky-header main-bar-wraper navbar-expand-lg">
					<div class="container">
				<div class="main-bar clearfix">
					<div class="top-bar-head">
							<div class="site-navigation">
		                        <div class="hamburger-menus">
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                            <span></span>
		                        </div>
		                        <nav class="navigation">
                            <div class="overlaybg"></div><!--  /.overlaybg -->
                            <!-- Main Menu -->
                            <div class="menu-wrapper">
                                <div class="menu-content">
                                    <?php
                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu ht-clearfix',
                                                'container'=> 'ul',
                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                                'theme_location' => 'primary',  
                                            )); 
                                        } else {
                                            wp_nav_menu ( array(
                                                'menu_class' => 'mainmenu ht-clearfix',
                                                'container'=> 'ul',
                                                'theme_location' => 'primary',  
                                            )); 
                                        }
                                    ?>
                                </div> <!-- /.hours-content-->

							<div class="clearfix"></div>

                            </div><!-- /.menu-wrapper --> 
                        </nav>
                        <div class="clearfix"></div>
                    </div><!--  /.site-navigation -->

					</div>
				</div>
			</div>
			</div>


			</div>

			<!-- main header END -->
			<div class="clearfix"></div>

		</header><!-- #masthead -->

	</div>
