<?php


/**
 * Liting the team/trainer details 
 * @param : int $pageId default is null
 * @param : boolean $isCustomizer default is false, if set to true will get the data stored with customizer
 * @param : int $i default is null, it will used as a iteration for data with customizer, this will be used only if the $isCustomizer is set to true.
 * @return: Text $text
 */
function coursesShortCode($pageId = null, $isCustomizer = false, $i = null, $cols=12) {
    ob_start();
    $args = array('post_type' => 'our-courses');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';

    if($isCustomizer == true){
        $luzuk_featured_page_icon = get_theme_mod('gurukul_courses_page_icon_'.$i);
        switch ($cols) {
            case 1:
                $colCls = 'col-md-12 col-sm-12 col-xs-12';
                break;
            case 2:
                $cols = 2;
                $colCls = 'col-md-6 col-sm-6 col-xs-12';
                break;
            case 3:
            case 5:
                $cols = 3;
                $colCls = 'col-md-4 col-sm-6 col-xs-12';
                break;
            case 4:
            case 7:
            case 8:
            case 16:
                $cols = 4;
                $colCls = 'col-md-3 col-sm-6 col-xs-12';
                break;
            case 6:
            case 9:
            case 10:
            case 12:
            default:
                $cols = 6;
                $colCls = 'col-md-2 col-sm-6 col-xs-12';
                break;
        }
    }
    else{
        $cols = 3;
        $colCls = 'col-md-4 col-sm-6 col-xs-12';
    }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;
        while ($query->have_posts()) : $query->the_post();
            $luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-courses-thumb');

            if (($postN % 3) == 0 && $isCustomizer == false) {
                ?>
                <div class="clearfix paddingBot20"></div>
                </div>
                <div class="row">
            <?php
            }
            ++$postN;
            ?>
            <div class="<?php echo $colCls; ?> courses padding0 margin0">
                <div class="featured-post wow fadeInUp text-center">
                    
                        <?php
                        if($isCustomizer == false){
                        ?>
                            <div class="Courses-image"><a href="<?php echo esc_url(get_permalink()); ?>"><span>
                               <?php
                                if (has_post_thumbnail()) {
                                    $image_url = $luzuk_image[0];
                                } else {
                                    $image_url = get_template_directory_uri() . '/images/team-thumb.png';
                                }
                                ?>                                                          
                                <img class="img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />
                            </span> </a></div>
                            <?php
                        }else{
                            ?>
                            <div class="featured-icon"><a href="<?php echo esc_url(get_permalink()); ?>"><span class="<?php echo $luzuk_featured_page_icon; ?>"></span></a></div>
                            <?php
                        }?>
                   
                    <div class="text-center Courses-title">
                        <h5><a href="<?php echo esc_url(get_permalink()); ?>"><?php the_title(); ?></a></h5>
                    </div>
                    <?php
                    if($isCustomizer == false){
                    ?>  
                        <a class="btn " href="<?php echo esc_url(get_permalink()); ?>">Read More</a>
                        <?php
                    }?>
                    <div class="clearfix"></div>
                </div>
                 <div class="clearfix"></div>
            </div>
            <?php
        endwhile;
        $text = ob_get_contents();
        ob_clean();
    endif;
    wp_reset_postdata();
    return $text;
}

add_shortcode('OURCOURSES', 'coursesShortCode');



