<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'gurukul')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'gurukul' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'gurukul'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'gurukul' ),
	'panel' => 'luzuk_general_panel',
) );


lzCustomLable($wp_customize, 'headerlogo_maxwidthtext', 'title_tagline', ' Site Header Logo Max Width:');

$wp_customize->add_setting(
	'pages_logomaxwidth',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '100%', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logomaxwidth',
	array(
		'settings'      => 'pages_logomaxwidth',
		'section'       => 'title_tagline',
		'type'          => 'text',
		'label'         => __( 'Logo Max Width', 'luzuk-premium' )
	)
);


   //Set header menu colour
addColorPalatOption($wp_customize, 'header_taglineColor', 'title_tagline', 'Header Tagline Color', '#000');


//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'luzuk_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'luzuk_headerlogo_settings', ' Site Header Logo Margin:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'luzuk-premium' )
	)
);



//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'gurukul' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'gurukul' ),
	'panel' => 'luzuk_general_panel',
) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'gurukul'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#e05b1d');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#2e2e2e');




lzCustomLable($wp_customize, 'innerpage_colorsetting', 'colors', ' Inner Page Color Setting:');

//Inner page title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#2a2a2a');

//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#e05b1d');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#e05b1d');

//Inner page content box text color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtextcolor', 'colors', 'Inner page content box text color', '#303030');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#e05b1d');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#e05b1d');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#e05b1d');

//Inner page border color
addColorPalatOption($wp_customize, 'template_innerpage_bordercolor', 'colors', 'Inner page border color', '#EEE');


//Inner page table days Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledays_color', 'colors', 'Inner Page Sidebar Table Days Color', '#fff');

//Inner page table days bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledaysbg_color', 'colors', 'Inner Page Sidebar Table Days Background Color', '#2a2a2a');

//Inner page table text Color
addColorPalatOption($wp_customize, 'template_innerpage_tabletext_color', 'colors', 'Inner Page Sidebar Table Text Color', '#6b7385');

//Inner page table box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tableboxbg_color', 'colors', 'Inner Page Sidebar Table Box Background Color', '#fff');

//Inner page table btn Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtn_color', 'colors', 'Inner Page Sidebar Table, Form Button Text Color', '#fff');

//Inner page table btn bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtnbg_color', 'colors', 'Inner Page Sidebar Table Button Background Color', '#2a2a2a');

//Inner Page Social color
addColorPalatOption($wp_customize, 'template_innerpage_socials_color', 'colors', 'Inner Page Social color', '#fff');

//Inner page box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_boxbg_color', 'colors', 'Inner Page Box Background Color', '#fff');
//Inner page blog box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_blogboxbg_color', 'colors', 'Inner Page Info Box Background Color', '#eee');



//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'gurukul' ),
		'panel' => 'luzuk_general_panel',
	)
);

//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'luzuk_sticky_header_enable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'luzuk_sticky_header_enable',
		array(
			'settings'		=> 'luzuk_sticky_header_enable',
			'section'		=> 'header_settings',
			'label'			=> __( 'Sticky Header', 'gurukul' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'gurukul' ),
				'off' => __( 'Disable', 'gurukul' )
			)	
		)
	)
);
$sectionHeader = 'header_settings';


lzCustomLable($wp_customize, 'luzuk_headerbgsetColor', 'header_settings', 'Set Header Background Colors:');


addColorPalatOption($wp_customize, 'luzuk_header_topbgColor', 'header_settings', 'Header Background Color', '#fff'); 

// Adding the Label
lzCustomLable($wp_customize, 'luzuk_reservation_lblImgTxt', $sectionHeader, 'Social media icons');
//ADD TEXT BOX FOR FORM SHORTCODE
lzAddElement($wp_customize, 'luzuk_header_fb', $sectionHeader, 'text', $label = "Facebook", 'luzuk_sanitize_text', 'http://Facbook.com');
lzAddElement($wp_customize, 'luzuk_header_tw', $sectionHeader, 'text', $label = "Twitter", 'luzuk_sanitize_text', 'http://twitter.com');
lzAddElement($wp_customize, 'luzuk_header_it', $sectionHeader, 'text', $label = "GooglePlus", 'luzuk_sanitize_text', 'https://plus.google.com');
lzAddElement($wp_customize, 'luzuk_header_in', $sectionHeader, 'text', $label = "LinedIn", 'luzuk_sanitize_text', 'http://Linkedin.com');
lzAddElement($wp_customize, 'luzuk_header_yt', $sectionHeader, 'text', $label = "Youtube", 'luzuk_sanitize_text', 'https://www.youtube.com');




// FACEBOOK 
$wp_customize->add_setting('luzuk_header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_fb',
	array(
		'settings'      => 'luzuk_header_fb',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'luzuk-premium' )
	)
);
// TWITTER
$wp_customize->add_setting('luzuk_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_tw',
	array(
		'settings'      => 'luzuk_header_tw',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'luzuk-premium' )
	)
);
// GOOGLE PLUS
$wp_customize->add_setting('luzuk_header_it', array('default' => 'https://plus.google.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_it',
	array(
		'settings'      => 'luzuk_header_it',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Google Plus Url', 'luzuk-premium' )
	)
);
// LINKED IN
$wp_customize->add_setting('luzuk_header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_in',
	array(
		'settings'      => 'luzuk_header_in',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'luzuk-premium' )
	)
);
 
// Youtube IN
$wp_customize->add_setting('luzuk_header_yt',array('default'=> 'https://www.youtube.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_header_yt',
	array(
		'settings'      => 'luzuk_header_yt',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Youtube Url', 'gurukul' )
	)
);

// // Instagram
$wp_customize->add_setting('header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_insta',
	array(
		'settings'      => 'header_insta',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Instagram', 'gurukul' )
	)
); 


// colors
//Social color
addColorPalatOption($wp_customize, 'luzuk_header_socialsColor', 'header_settings', 'Header Socials color', '#fff'); 

//Social hover color
addColorPalatOption($wp_customize, 'luzuk_header_socialshoverColor', 'header_settings', 'Header Socials Hover color', '#e05b1d'); 

addColorPalatOption($wp_customize, 'luzuk_header_socialsbgColor', 'header_settings', 'Header Socials Box Background color', '#2e2e2e'); 



//medal header
$wp_customize->add_setting(
	'luzuk_header_emaillabel',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'EMAIL SUPPORT', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_header_emaillabel',
	array(
		'settings'      => 'luzuk_header_emaillabel',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Label', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'luzuk_header_email',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'contact@example.com', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_header_email',
	array(
		'settings'      => 'luzuk_header_email',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Address', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'luzuk_header_phonelabel',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'CALL SUPPORT', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_header_phonelabel',
	array(
		'settings'      => 'luzuk_header_phonelabel',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Label', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'luzuk_header_phone',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '+1 999 999 9999', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_header_phone',
	array(
		'settings'      => 'luzuk_header_phone',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'luzuk-premium' )
	)
);

//Contact label color
addColorPalatOption($wp_customize, 'luzuk_header_contactlabelColor', 'header_settings', 'Header contact label color', '#454545'); 

//Contact data color
addColorPalatOption($wp_customize, 'luzuk_header_contactdataColor', 'header_settings', 'Header contact data color', '#e05b1d'); 

//Contact email hover color
addColorPalatOption($wp_customize, 'luzuk_header_contactemailhoverColor', 'header_settings', 'Header contact email hover color', '#000'); 


//Contact border color
addColorPalatOption($wp_customize, 'luzuk_header_contactborderColor', 'header_settings', 'Header contact border color', '#ececec'); 



lzCustomLable($wp_customize, 'header_clrlblImgTxt', 'header_settings', 'Set Header Menu Colors:');

addColorPalatOption($wp_customize, 'luzuk_header_navbgColor', 'header_settings', 'Header Background Color', '#e05b1d'); 

   //Set header menu colour
addColorPalatOption($wp_customize, 'headermenu_color', 'header_settings', 'Header Menu Color', '#fff');

addColorPalatOption($wp_customize, 'headerhovermenu_color', 'header_settings', 'Header Menu Hover Color', '#000');

addColorPalatOption($wp_customize, 'headermenuhoverbg_color', 'header_settings', 'Header Menu Background Hover Color', '#fff');


	//Set Current Menu Text colour
addColorPalatOption($wp_customize, 'headercurrentmenu_color', 'header_settings', 'Header Current Menu Color', '#000');

	//Set Current Menu Text bg colour
addColorPalatOption($wp_customize, 'headercurrentmenubg_color', 'header_settings', 'Header Current Menu Background Color', '#fff');


	//Set header sub menu colour
addColorPalatOption($wp_customize, 'headersubmenu_color', 'header_settings', 'Header Dropdown Menu Color', '#fff');

addColorPalatOption($wp_customize, 'headersubmenuhover_color', 'header_settings', 'Header Dropdown Menu hover Color', '#000');

addColorPalatOption($wp_customize, 'headersubmenubghover_color', 'header_settings', 'Header Dropdown Menu Background hover Color', '#fff');

addColorPalatOption($wp_customize, 'headerdropdowncurrentsubmenu_color', 'header_settings', 'Header Dropdown Current Menu Color', '#000');

addColorPalatOption($wp_customize, 'headerdropdowncurrentsubmenubg_color', 'header_settings', 'Header Dropdown Current Menu Background Color', '#fff');

	//Header Dropdown Background Color
addColorPalatOption($wp_customize, 'headersubmenuboxbg_color', 'header_settings', 'Header Dropdown Background Color', '#e05b1d');


//responsive header colors

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', 'header_settings', 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_topsubmenuiconColor', 'header_settings', 'Header Menus Dropdown Icon Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box Background Color', '#e05b1d');
addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Menus Border Color', '#000');




//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 



$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk-premium' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox current title color', '#2a2a2a');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox current title hover color', '#e05b1d');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbbgcolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox background color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbbgbordercolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox border color', '#2a2a2a');

// end to show & hide button


//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'innerheadingfontsize_settings', ' Inner Page Heading Font Size:');


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '26px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);


//Inner Page Box Padding Setting
$wp_customize->add_section(
	'innerboxpaddiing_settings',
	array(
		'title' => __( 'Inner Page Box Padding Setting', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'innerpagebox_padding', 'innerboxpaddiing_settings', ' Inner Page Box Padding Setting:');

$wp_customize->add_setting(
    'innerpagesbox_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_toppadding',
    array(
        'settings'      => 'innerpagesbox_toppadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_bottompadding',
    array(
        'settings'      => 'innerpagesbox_bottompadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_leftpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_leftpadding',
    array(
        'settings'      => 'innerpagesbox_leftpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_rightpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_rightpadding',
    array(
        'settings'      => 'innerpagesbox_rightpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);


//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_postpagedate_settings',
	array(
		'title' => __( 'Post Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'socialpost_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'socialpost_button_display', array( 'label' => 'Post Social Media Display', 'section' => 'luzuk_postpagedate_settings', 'settings' => 'socialpost_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Social Media', 'hide' => 'Hide Post Social Media', ), ) ); 

// end to show & hide button



//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button



//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_copyright_settings',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


backgroundManager($wp_customize, 'footer', 'footer_copyright_settings', $color='#2e2e2e');


//theme Footer title Color
addColorPalatOption($wp_customize, 'footer_title_color', 'footer_copyright_settings', 'Footer Title Color', '#fff');

$wp_customize->add_setting(
	'footer_copyrighttext',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Copyright © 2019 gurukul-education. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'footer_copyrighttext',
	array(
		'settings'      => 'footer_copyrighttext',
		'section'       => 'footer_copyright_settings',
		'type'          => 'textarea',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);



//theme Footer Copyright text Color
addColorPalatOption($wp_customize, 'footer_copyrighttext_color', 'footer_copyright_settings', 'Copyright Footer Text Color', '#848484');


//theme Footer Copyright bgColor
addColorPalatOption($wp_customize, 'footer_copyrightbg_color', 'footer_copyright_settings', 'Copyright Footer Background Color', '#282828');
