<?php
/**
 * Customiser section for featured
 **/
// Start Feature section 
$wp_customize->add_section(
    'luzuk_featured_section',
    array(
        'title' => __( 'Services Section', 'gurukul' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
// ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'luzuk_featured_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_featured_section_disable',
        array(
            'settings'      => 'luzuk_featured_section_disable',
            'section'       => 'luzuk_featured_section',
            'label'         => __( 'Disable Section', 'gurukul' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'gurukul' ),
                'off' => __( 'No', 'gurukul' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'featured', 'luzuk_featured_section', $color='#f6f6f6');

$wp_customize->add_setting(
    'luzuk_featured_title_sub_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_featured_title_sub_title_heading',
        array(
            'settings'      => 'luzuk_featured_title_sub_title_heading',
            'section'       => 'luzuk_featured_section',
            'label'         => __( 'Section Title & Sub Title', 'gurukul' ),
        )
    )
);    
$wp_customize->add_setting(
    'luzuk_featured_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OUR Services', 'gurukul' )
    )
);
$wp_customize->add_control(
    'luzuk_featured_title',
    array(
        'settings'      => 'luzuk_featured_title',
        'section'       => 'luzuk_featured_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'gurukul' )
    )
);
$wp_customize->add_setting(
    'luzuk_featured_sub_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'CHOOSE YOUR DESIRED COURSE', 'gurukul' )
    )
);
$wp_customize->add_control(
    'luzuk_featured_sub_title',
    array(
        'settings'      => 'luzuk_featured_sub_title',
        'section'       => 'luzuk_featured_section',
        'type'          => 'textarea',
        'label'         => __( 'Sub Title', 'gurukul' ),
    )
);

    // Heading color
    addColorPalatOption($wp_customize, 'luzuk_featured_HeadingColor', 'luzuk_featured_section', 'Heading color '. $headingColor, '#2a2a2a');
    // Text color
    addColorPalatOption($wp_customize, 'luzuk_featured_TextColor', 'luzuk_featured_section', 'Text color', '#4f4f4f');

$wp_customize->add_setting('luzuk_featured_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_featured_npp_heading',
        array(
            'settings'      => 'luzuk_featured_npp_heading',
            'section'       => 'luzuk_featured_section',
            'label'         => __( 'Number Of featured Plans', 'gurukul' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_featured_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'luzuk_featured_npp_count',
    array(
        'settings'      => 'luzuk_featured_npp_count',
        'section'       => 'luzuk_featured_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'gurukul' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'luzuk_featured_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_featured_header'.$i,
            array(
                'settings'      => 'luzuk_featured_header'.$i,
                'section'       => 'luzuk_featured_section',
                'label'         => __( 'Featured Page ', 'gurukul' ).$i
            )
        )
    );

lzAddElement($wp_customize, 'luzuk_featured_page_title_'.$i, 'luzuk_featured_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Online Training');
lzAddElement($wp_customize, 'luzuk_featured_page_description_'.$i, 'luzuk_featured_section', $type = 'textarea', $label="Description", $callback ='luzuk_sanitize_text', $default='You can learn anything You can learn anything You can learn anything You can learn anything');

    // $wp_customize->add_setting(
    //     'luzuk_featured_page'.$i,
    //     array(
    //         'sanitize_callback' => 'absint'
    //     )
    // );
    // $wp_customize->add_control(
    //     'luzuk_featured_page'.$i,
    //     array(
    //         'settings'      => 'luzuk_featured_page'.$i,
    //         'section'       => 'luzuk_featured_section',
    //         'type'          => 'dropdown-pages',
    //         'label'         => __( 'Select a Page', 'gurukul' )
    //     )
    // );
    
	$wp_customize->add_setting(
        'luzuk_featured_page_icon'.$i,
        array(
            'default'           => 'fa fa-bell',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'luzuk_featured_page_icon'.$i,
            array(
                'settings'      => 'luzuk_featured_page_icon'.$i,
                'section'       => 'luzuk_featured_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'gurukul' ),
            )
        )
    );
	
	//my edit code
	// $wp_customize->add_control( 
	// 'luzuk_featured_page', 
	// array(
	// 'settings'=> 'luzuk_featured_page', 
	// 'section' => 'luzuk_featured_section', 
	// 'type'=>'select', 
	// 'label'=>__('Link to featured page', 'lz-featured-premium'), 
	// //'choices'=>$lz_featured_page_choice 
	// 	) 
	// );
	
	$wp_customize->add_setting(
	'luzuk_featured_image_heading', 
	array(
	'sanitize_callback' => 'luzuk_sanitize_text' 
		) 
	); 
	
	$wp_customize->add_control(
	new luzuk_Customize_Heading(
	$wp_customize, 
	'luzuk_featured_image_heading', 
	array(
	'settings' => 'luzuk_featured_image_heading', 
	'section' => 'luzuk_featured_section', 
	'label' => __( 'Right Image', 'lz-featured-premium' ), 
			) 
		) 
	); 
	
	$wp_customize->add_setting(
	'luzuk_featured_image', 
	array( 
	'sanitize_callback' => 'esc_url_raw' 
		) 
	);
	
	$wp_customize->add_control(
	new WP_Customize_Image_Control(
	$wp_customize, 
	'luzuk_featured_image', 
	array(
	'section' => 'luzuk_featured_section',
	'settings' => 'luzuk_featured_image',
	'description' => __('Recommended Image Size: 500X600px', 'lz-featured-premium') 
			)
		) 
	);

  
    // Title color
    addColorPalatOption($wp_customize, 'luzuk_featured_TitleColor', 'luzuk_featured_section', 'Title color', '#2a2a2a');
    // Icon color
    addColorPalatOption($wp_customize, 'luzuk_featured_IconColor', 'luzuk_featured_section', 'Icon color', '#ffffff');
    
}
// End Feature section 