<?php
// START APPOINTMENT SECTION 
$wp_customize->add_section(
	'lz_featured_pages',
	array(
		'title'   => __( 'Featured Pages', 'gurukul' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
    //ENABLE/DISABLE Appointment SECTION
$wp_customize->add_setting(
	'lz_featured_pages_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'lz_featured_pages_disable',
		array(
			'settings'      => 'lz_featured_pages_disable',
			'section'       => 'lz_featured_pages',
			'label'         => __( 'Disable Section', 'gurukul' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'gurukul' ),
				'off' => __( 'No', 'gurukul' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'fpage', 'lz_featured_pages', $color='#fff');

// Adding the Label
lzCustomLable($wp_customize, 'lz_featured_pages_title_subtitle_heading', 'lz_featured_pages', 'Section Title & Sub Title');

//add textarea
lzAddElement($wp_customize, 'lz_featured_pages_title', 'lz_featured_pages', 'text', $label="Title", 'luzuk_sanitize_text', 'OUR FEATURES');

//add textarea
lzAddElement($wp_customize, 'lz_featured_pages_sub_title', 'lz_featured_pages', 'textarea', $label="Sub Title", 'luzuk_sanitize_text', 'CHOOSE YOUR DESIRED COURSE');

// Heading color
addColorPalatOption($wp_customize, 'lz_featured_pages_HeadingColor', 'lz_featured_pages', 'Heading color', '#2a2a2a');
// Text color
addColorPalatOption($wp_customize, 'lz_featured_pages_SubheadingColor', 'lz_featured_pages', 'Sub Heading color', '#333333');

// Adding the Label
lzCustomLable($wp_customize, 'lz_featured_pages_npp_heading', 'lz_featured_pages', 'Number Of featured Pages');

$limit = array(1,2,3,4,5,6,7,8,9,10,11,12);
//add textarea
lzAddElement($wp_customize, 'lz_featured_pages_npp_count', 'lz_featured_pages', 'select', $label="Number of pages to show", 'luzuk_sanitize_text', 2, $limit);

// Adding the Label
lzCustomLable($wp_customize, 'lz_featured_pages_npp_heading', 'lz_featured_pages', 'Select the page');


foreach($limit as $v){	
	$wp_customize->add_setting(
        'luzuk_featured_page_'.$v,
        array(
            'sanitize_callback' => 'absint',
            'default'           => 0,
        )
    );
    $wp_customize->add_control(
        'luzuk_featured_page_'.$v,
        array(
            'settings'      => 'luzuk_featured_page_'.$v,
            'section'       => 'lz_featured_pages',
            'type'          => 'dropdown-pages',
            'label'         => __( 'Select a Page', 'gurukul' )
        )
    );
	$wp_customize->add_setting(
        'luzuk_featured_page_icon_'.$v,
        array(
            'default'           => 'fa fa-bell',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'luzuk_featured_page_icon_'.$v,
            array(
                'settings'      => 'luzuk_featured_page_icon_'.$v,
                'section'       => 'lz_featured_pages',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'gurukul' ),
            )
        )
    );
    lzAddElementSeparator($wp_customize, 'lz_featured_pages_separator_'.$v, 'lz_featured_pages');

// Odd box Icon color
addColorPalatOption($wp_customize, 'lz_featured_pages_IconoddColor', 'lz_featured_pages', 'Odd Box Icon color', '#e05b1d');

// Even box Icon color
addColorPalatOption($wp_customize, 'lz_featured_pages_IconevenColor', 'lz_featured_pages', 'Even Box Icon color', '#ffb200');

// Title color
addColorPalatOption($wp_customize, 'lz_featured_pages_TitleColor', 'lz_featured_pages', 'Title color', '#2a2a2a');

// text color
addColorPalatOption($wp_customize, 'lz_featured_pages_TextColor', 'lz_featured_pages', 'Text color', '#333333');

//Button color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonColor', 'lz_featured_pages', 'Button color', '#fff');

//odd Button bg color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonbgoddColor', 'lz_featured_pages', 'Odd Box Button background color', '#e05b1d');

//odd Button border color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonborderoddColor', 'lz_featured_pages', 'Odd Box Button border color', '#fff');

// Button odd border hover color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonborderoddhoverColor', 'lz_featured_pages', 'Odd Button border hover color', '#e05b1d');


// Button hover color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonhoverColor', 'lz_featured_pages', 'Button hover color', '#000');

//even Button bg color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonbgevenColor', 'lz_featured_pages', 'Even Box Button background color', '#ffb200');

//even Button border color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonborderevenColor', 'lz_featured_pages', 'Even Box Button border color', '#fff');

// Button even border hover color
addColorPalatOption($wp_customize, 'lz_featured_pages_buttonborderevenhoverColor', 'lz_featured_pages', 'Even Button border hover color', '#ffb200');

}

// END APPOINTMENT SECTION 