<?php

// START Gym Timing & Address SECTION
    $wp_customize->add_section(
        'luzuk_time_n_address',
        array(
            'title'=> __('Timing & Address', 'gurukul'),
            'panel'=> 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'luzuk_time_n_address_disabled',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default' => 'off'
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_time_n_address_disabled',
            array(
                'settings'=>'luzuk_time_n_address_disabled',
                'section'=>'luzuk_time_n_address',
                'label'=>__('Disable Section', 'gurukul'),
                'on_off_label'=> array(
                    'on'=> __('Yes', 'gurukul'),
                    'off'=> __('No', 'gurukul')
                )
            )
        )
    );

    backgroundManager($wp_customize, 'gym', 'luzuk_time_n_address', $color='#fff');

    $wp_customize->add_setting(
    	'luzuk_time_n_address_into', 
    	array(
    		'sanitize_callback'=>'luzuk_sanitize_text'
    	)
    );
    $wp_customize->add_control(
    	new luzuk_Customize_Heading(
    		$wp_customize, 
    		'luzuk_time_n_address_into', 
    		array(
    			'settings'=>'luzuk_time_n_address_into', 
    			'section'=>'luzuk_time_n_address', 
    			'label'=>__('Section Title & Sub Title', 'gurukul')
    		)
    	)
    );
    $wp_customize->add_setting(
    	'luzuk_time_n_address_title', 
    	array(
    		'sanitize_callback' => 'luzuk_sanitize_text', 
    		'default'=> __('Gym Timing & Address', 'gurukul')
    	)
    );
    $wp_customize->add_control(
    	'luzuk_time_n_address_title', 
    	array(
    		'settings'=>'luzuk_time_n_address_title', 
    		'section'=>'luzuk_time_n_address', 
    		'type'=>'text', 
    		'label'=> __('Title', 'gurukul')
    	)
    );
    $wp_customize->add_setting(
    	'luzuk_time_n_address_subtitle',
    	array(
    		'sanitize_callback' => 'luzuk_sanitize_text', 
    		'default'=> __('Here goes the short description for the section', 'gurukul')
    	)
    );
    $wp_customize->add_control(
    	'luzuk_time_n_address_subtitle',
    	array(
    		'settings'=>'luzuk_time_n_address_subtitle', 
    		'section'=>'luzuk_time_n_address', 
    		'type'=>'textarea', 
    		'label'=> __('Sub Title', 'gurukul')
    	)
    );

// Heading color
addColorPalatOption($wp_customize, 'luzuk_gym_HeadingColor', 'luzuk_time_n_address', 'Heading color', $headingColor);
// Text color
addColorPalatOption($wp_customize, 'luzuk_gym_TextColor', 'luzuk_time_n_address', 'Text color', '#333333');

    $wp_customize->add_setting(
    	'luzuk_time_n_address_time_section', 
    	array(
    		'sanitize_callback'=> 'luzuk_sanitize_text',
			// 'default'           => __( 'Gym Timeings', 'gurukul' )
    	)
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_time_n_address_time_section', 
            array(
            	'settings'=>'luzuk_time_n_address_time_section', 
            	'section'=>'luzuk_time_n_address', 
            	'label'=>__('Timing', 'gurukul')
            )
        )
    );
    // gym time title
    $wp_customize->add_setting(
        'luzuk_time_n_address_time_title', 
        array(
            'sanitize_callback'=> 'luzuk_sanitize_text',
            'default'           => __( 'Gym Timings', 'gurukul' )
        )
    );
    $wp_customize->add_control(
        'luzuk_time_n_address_time_title', 
        array(
            'settings'=>'luzuk_time_n_address_time_title', 
            'section'=>'luzuk_time_n_address', 
            'type'=>'text', 
            'label'=>__('Timing Title', 'gurukul')
        )
    );
    $days = array('Monday', 'Tuesday','Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
    //Gym time
    foreach ($days as $i => $value) {
        $wp_customize->add_setting(
        	'luzuk_time_n_address_time_'.($i+1), 
        	array(
        		'sanitize_callback' => 'luzuk_sanitize_text', 
        		'default' => __( '5:00 AM - 12:00 PM', 'gurukul' )
        	)
        );
        $wp_customize->add_control(
        	'luzuk_time_n_address_time_'.($i+1), 
        	array(
        		'settings'=>'luzuk_time_n_address_time_'.($i+1), 
        		'section'=>'luzuk_time_n_address', 
        		'type'=>'text', 
        		'label'=> __($value, 'gurukul')
        	)
        );
    }
    