<?php   
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Poppins:400,500,600,700&display=swap" rel="stylesheet">
<!-- <link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.carousel.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.theme.default.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/style-ltr.css" /> -->
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'Luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->

		<?php 
		if( get_theme_mod('pages_logoTmargin',true) ) {
			$pages_logoTmargin = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
		}
		if( get_theme_mod('pages_logoBmargin',true) ) {
			$pages_logoBmargin = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
		}
		if( get_theme_mod('pages_logoLmargin',true) ) {
			$pages_logoLmargin = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
		}
		if( get_theme_mod('pages_logoRmargin',true) ) {
			$pages_logoRmargin = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
		}
		?>

		<header class="site-header header-transparent header mo-left header-seo" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">

			
			<div class="container heade-border">
				<?php 
				if( get_theme_mod('pages_logoboxtoppostionset',true) ) {
					$pages_logoboxtoppostionset = 'padding-top:'.esc_attr(get_theme_mod('pages_logoboxtoppostionset')).';';
				}
				
				?>

				<div class="col-md-3 col-sm-6 col-xs-8 logo"> 
					
					<div class="logobox">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
						<?php endif; ?>
						<!-- .site-branding -->
					</div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p> 
					
				</div>
				<!-- main header -->
				<div class="col-md-9 col-sm-6 col-xs-4 sticky-header main-bar-wraper navbar-expand-lg padding0">
					<div class="main-bar clearfix ">
						<div class="top-bar-head">
							<!-- nav toggle button -->
							<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
								<span></span>
								<span></span>
								<span></span>
							</button>
							<!-- main nav -->

							<?php 
							if( get_theme_mod('pages_BottomHeaderTpadding',true) ) {
								$pages_BottomHeaderTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_BottomHeaderTpadding')).';';
							}
							if( get_theme_mod('pages_BottomHeaderBpadding',true) ) {
								$pages_BottomHeaderBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_BottomHeaderBpadding')).';';
							}
							if( get_theme_mod('pages_BottomHeaderLpadding',true) ) {
								$pages_BottomHeaderLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_BottomHeaderLpadding')).';';
							}
							if( get_theme_mod('pages_BottomHeaderRpadding',true) ) {
								$pages_BottomHeaderRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_BottomHeaderRpadding')).';';
							}
							?>

							<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown" style="<?php echo esc_attr($pages_BottomHeaderTpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderRpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderLpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderRpadding); ?>">

								<ul class="col-md-12 nav navbar-nav">	
									<?php 
									wp_nav_menu( array( 
										'theme_location' => 'primary', 
										'container_class' => 'ht-menu clearfix' ,
										'menu_class' => 'ht-clearfix wow',
										'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
									) ); 
									?>
								</ul>

							</div>
						</div>
					</div>
				</div>
				<!-- main header END -->
				<div class="clearfix"></div>
			</div>
		</header><!-- #masthead -->
	</div>