<?php 

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// $wp_customize->add_setting(
// 	'lz_fitness_headersitettl',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( 'Best Business Wordpress Theme', 'Luzuk Premium' ) 
// 	)
// );
// $wp_customize->add_control(
// 	'lz_fitness_headersitettl',
// 	array(
// 		'settings'      => 'lz_fitness_headersitettl',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'text',
// 		'label'         => __( 'Site Tagline', 'Luzuk Premium' )
// 	)
// );


addColorPalatOption($wp_customize, 'lz_fitness_sitetaglinetxt_color', 'lz_fitness_header_settings', 'Site Tagline Color', '#ffffff');


lzCustomLable($wp_customize, 'lz_fitness_header_settings', 'lz_fitness_header_settings', ' Set Header Padding:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '40px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Top Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '110px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Bottom Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '00px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Left Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Right Padding', 'lz-fitness-premium' )
	)
);



	//ENABLE/DISABLE STICKY HEADER
// $wp_customize->add_setting(
// 	'lz_fitness_sticky_header_enable',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default' => 'off'
// 	)
// );
// $wp_customize->add_control(
// 	new lz_fitness_Switch_Control(
// 		$wp_customize,
// 		'lz_fitness_sticky_header_enable',
// 		array(
// 			'settings'		=> 'lz_fitness_sticky_header_enable',
// 			'section'		=> 'lz_fitness_header_settings',
// 			'label'			=> __( 'Sticky Header', 'Luzuk Premium' ),
// 			'on_off_label' 	=> array(
// 				'on' => __( 'Enable', 'Luzuk Premium' ),
// 				'off' => __( 'Disable', 'Luzuk Premium' )
// 			)	
// 		)
// 	)
// );

//Menu colors 

//addColorPalatOption($wp_customize, 'lz_fitness_hmpmainheaderheaderbgsscl_color', 'lz_fitness_header_settings', 'Header Background Color', '#6843c4');

// for gradiant

$wp_customize->add_setting(
    'lz_fitness_header_bg_color_one', array(
        'default'           => '#bb64eb',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_header_bg_color_one',array(
            'settings'      => 'lz_fitness_header_bg_color_one',
            'section'       => 'lz_fitness_header_settings',
            'label'         => __( 'Header Background Gradient Color One ', 'Luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'lz_fitness_header_bg_color_two', array(
        'default'           => '#bb64eb',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_header_bg_color_two',array(
            'settings'      => 'lz_fitness_header_bg_color_two',
            'section'       => 'lz_fitness_header_settings',
            'label'         => __( 'Header Background Gradient Color Two ', 'Luzuk Premium' ),
        )
    )
); 


addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Header Current Menu Color', '#33129c');

addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_headerhovermenu_color', 'lz_fitness_header_settings', 'Header Menu Hover Color', '#411173');

addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubgss_color', 'lz_fitness_header_settings', 'Header Dropdown Background Color', '#ffffff');

//addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubghover_color', 'lz_fitness_header_settings', 'Header Sub Menu hover Background Color', '#0a051b');
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Sub Menu Color', '#6843c4');
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Sub Menu hover Color', '#6843c4');


addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuborderc_color', 'lz_fitness_header_settings', 'Header Sub Menu Hover Border Color', '#6843c4');

addColorPalatOption($wp_customize, 'lz_fitness_headerdropdowncurrentsubmenu_color', 'lz_fitness_header_settings', 'Header Current Sub Menu Color', '#6843c4');

//addColorPalatOption($wp_customize, 'lz_fitness_headerbackgroundclrforstickheader_color', 'lz_fitness_header_settings', 'Header Background Color For Sticky Header', '#6843c4');

//addColorPalatOption($wp_customize, 'lz_fitness_headerbackgroundclrfforallinnerpah_color', 'lz_fitness_header_settings', 'Header Background Color For Innerpages Header', '#6843c4');


//addColorPalatOption($wp_customize, 'lz_fitness_header_bgsclrfrresponsiveColor', 'lz_fitness_header_settings', 'Header background color for tablets and mobile view', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_togglebarctmainborder_color', 'lz_fitness_header_settings', 'Select Toggle Bar Color for  tablets and mobile view', '#411173');
addColorPalatOption($wp_customize, 'lz_fitness_navigationboxbgssresponsive_color', 'lz_fitness_header_settings', 'Select Navigation Box Background Color for  tablets and mobile view', '#bb64eb');
addColorPalatOption($wp_customize, 'lz_fitness_navigationboxbgssresponsivebackground_color', 'lz_fitness_header_settings', 'Select Active Menu Background Color for  tablets and mobile view', '#ffffff');

//lzCustomLable($wp_customize, 'lz_fitness_headerbgssimageremlblset_col', 'lz_fitness_header_settings', 'Innerpage Header Shape Display Settings:');
// to show & hide another button
//$wp_customize->add_setting( 'headershapeallinnerpsection_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'headershapeallinnerpsection_button_display', array( 'label' => 'Button Display', 'section' => 'lz_fitness_header_settings', 'settings' => 'headershapeallinnerpsection_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Header Shape', 'hide' => 'Hide Header Shape', ), ) ); 

// end to show & hide button


//lzCustomLable($wp_customize, 'lz_fitness_headerbgssclrforinnerpbgs_col', 'lz_fitness_header_settings', 'Set Header Background Color Innerpages Header:');

//addColorPalatOption($wp_customize, 'lz_fitness_headerbgssclrfrinnerpbgs_color', 'lz_fitness_header_settings', 'Select Background Color Innerpages Header', '#6843c4');



//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#6943c4');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#170e33');

lzCustomLable($wp_customize, 'lz_fitness_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#170e33');


// for gradiant

$wp_customize->add_setting(
    'lz_fitness_innerpagegradhead_bg_color_one', array(
        'default'           => '#5127c3',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_innerpagegradhead_bg_color_one',array(
            'settings'      => 'lz_fitness_innerpagegradhead_bg_color_one',
            'section'       => 'colors',
            'label'         => __( 'Inner page Header Background Gradient Color One ', 'Luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'lz_fitness_innerpagegradhead_bg_color_two', array(
        'default'           => '#c166ef',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_innerpagegradhead_bg_color_two',array(
            'settings'      => 'lz_fitness_innerpagegradhead_bg_color_two',
            'section'       => 'colors',
            'label'         => __( 'Inner page Header Background Gradient Color Two ', 'Luzuk Premium' ),
        )
    )
); 


addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading1 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading2 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading3 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading4 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading5 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading6 color', '#2e2e2e');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links color', '#777777');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover color', '#6843c4');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list number color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list number Background color', '#6843c4');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxallbrss_color', 'colors', 'Inner Page Sidebar border color', '#e1e1e1');


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#ffffff');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#e7ccf7');
 

// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Post Page Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Hide Post Date', 'hide' => 'Show Post Date', ), ) ); 

// end to show & hide button

$wp_customize->add_setting( 'post_social_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'post_social_button_display', array( 'label' => 'Single Post Social Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'post_social_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Hide Single Post Social', 'hide' => 'Show Single Post Social', ), ) ); 

//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2019 Hexagon | All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#170e33');

//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#ada9b7');
//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', '#fff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#a9a0be');


addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#a9a0be');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#ffffff');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Date Color', '#a9a0be');

//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#908d97');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#ffffff');

//theme Footer table text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tabletext_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Text Color', '#908d97');
//theme Footer table border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tableborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Border Color', '#281d42');

addColorPalatOption($wp_customize, 'lz_fitness_footer_formlabeltxt_color', 'lz_fitness_footer_copyright_settings', 'Footer Form label Text Color', '#ffffff');

//theme Footer form Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Text & Placeholder Text Color', '#908d97');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Form text field background Color', '#fff');


//theme Footer form button Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Text Color', '#ffffff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#a9a0be');

addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#5e5b62');
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightbgssclr_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Background Color', '#0a051b');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

//addColorPalatOption($wp_customize, 'lz_fitness_shoppageheaderbg_color', 'lz_fitness_shopsidebar_settings', 'Shop Pages Top Header Background Color', '#2e2e2e');


$wp_customize->add_section(
	'lz_fitness_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_servicepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:'); 

lzCustomLable($wp_customize, 'lz_fitness_serviceinnerpageimgdisplayset', 'lz_fitness_innerpageshortcode_page_settings', 'Note: Set Services images of equal height');

addColorPalatOption($wp_customize, 'lz_fitness_ServicesboxinnerpagettlColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Title Color', '#121212');

addColorPalatOption($wp_customize, 'lz_fitness_ServicesboxinnerpagettlhvrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Title Hover Color', '#6843c4');

addColorPalatOption($wp_customize, 'lz_fitness_ServicesboxinnerpagedescColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Text Color', '#121212');

addColorPalatOption($wp_customize, 'lz_fitness_ServicesboxinnerpagebxbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Box Background Color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_ServicesboxinnerpagebuttonColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Box Button Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_ServicesboxinnerpagebuttonbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Box Button Background Color', '#6843c4');


lzCustomLable($wp_customize, 'lz_fitness_teaminnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'lz_fitness_teaminnerpageimgdisplayset', 'lz_fitness_innerpageshortcode_page_settings', 'Note: Set team member images of equal height of size atleast 270px');

$wp_customize->add_setting(
    'lz_fitness_innerpageteamhvrovrlay_bg_color_one', array(
        'default'           => '#5127c3',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_innerpageteamhvrovrlay_bg_color_one',array(
            'settings'      => 'lz_fitness_innerpageteamhvrovrlay_bg_color_one',
            'section'       => 'lz_fitness_innerpageshortcode_page_settings',
            'label'         => __( ' Team image hover overlay Background Gradient Color One ', 'Luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'lz_fitness_innerpageteamhvrovrlay_bg_color_two', array(
        'default'           => '#c166ef',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_innerpageteamhvrovrlay_bg_color_two',array(
            'settings'      => 'lz_fitness_innerpageteamhvrovrlay_bg_color_two',
            'section'       => 'lz_fitness_innerpageshortcode_page_settings',
            'label'         => __( ' Team image hover overlay Background Gradient Color Two ', 'Luzuk Premium' ),
        )
    )
); 

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembernametextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Member Name Text color', '#6843c4');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembernametextborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Member Name Text hover Border color', '#6843c4');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermemberdesignationtextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Member Designation Text color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialiconhvrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Hover color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialbackbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Background color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialbackbgsshvrsColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Background Hover color', '#6943c4');
addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersocialbackbgsshvrsborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Social Icon Hover Border color', '#ccc');




lzCustomLable($wp_customize, 'lz_fitness_testimonialinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');
 
addColorPalatOption($wp_customize, 'lz_fitness_testiminnerpbrsscrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Image Border color', '#6943c4');
addColorPalatOption($wp_customize, 'lz_fitness_testiminnerboxbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Background color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_testiminnerboxbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Border color', '#6943c4');
addColorPalatOption($wp_customize, 'lz_fitness_testiminnerindicatorboxbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Indicator Border color', '#6943c4');

addColorPalatOption($wp_customize, 'lz_fitness_testiminnerindicatorbackColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Box Indicator Background color', '#ffffff');


addColorPalatOption($wp_customize, 'lz_fitness_testiminnerboxtxtcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Text color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_testiminnerboxnametxtcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Name Text color', '#6943c4');
addColorPalatOption($wp_customize, 'lz_fitness_testiminnerboxdesignationtxtcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Testimonial Designation Text color', '#121212');


 
lzCustomLable($wp_customize, 'lz_fitness_galleryinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors:'); 

addColorPalatOption($wp_customize, 'lz_fitness_galleryimgboxiconclrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_galleryimgboxiconhoverclrColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Icon Hover color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_galleryimgboxiconbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Icon Background color', '#6943c4');
addColorPalatOption($wp_customize, 'lz_fitness_galleryimgboxiconhoverbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Icon Hover Background color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_galleryimgboxiconallbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Icon Border color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_galleryimgboxiconhoverbordebgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Icon Hover Border color', '#6943c4');
 

lzCustomLable($wp_customize, 'lz_fitness_faqinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleIconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq No. color', '#6943c4');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleIconboxbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq No. box background color', '#f4f4f4');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Question Text color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitlehvrccolColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Question Text Hover color', '#000000');

//addColorPalatOption($wp_customize, 'lz_fitness_faqinnertitlebxbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Title Box Border color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleboxborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Question Text Box Background color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetextcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Answer Text color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetextboxbgsscbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Answer Text Box Background color', '#f4f4f4');


$wp_customize->add_section(
	'lz_fitness_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Fonts Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh1_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '24px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1', 'lz-fitness-premium' )
	)
);


lzCustomLable($wp_customize, 'lz_fitness_innerpageh2_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '23px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2', 'lz-fitness-premium' )
	)
);


lzCustomLable($wp_customize, 'lz_fitness_innerpageh3_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '20px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh4_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '19px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh5_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh6_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6', 'lz-fitness-premium' )
	)
);

$wp_customize->add_section(
	'lz_fitness_innerpage_animation_settings',
	array(
		'title' => __( 'Inner Page Animation Display Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide another button
$wp_customize->add_setting( 'innerpagesallheaderanimation_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'innerpagesallheaderanimation_button_display', array( 'label' => 'Innerpage Animation Display Setting', 'section' => 'lz_fitness_innerpage_animation_settings', 'settings' => 'innerpagesallheaderanimation_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Start animation', 'hide' => 'Stop Animation', ), ) ); 
// end to show & hide button


addColorPalatOption($wp_customize, 'lz_fitness_innerpageallheader_animatedbx_Color', 'lz_fitness_innerpage_animation_settings', 'Select Animated Box color', '#e7ccf7');

