<?php   

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'lz_fitness_premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'Hexagon' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'premium_slider_show_content',
		array(
			'settings'      => 'premium_slider_show_content',
			'section'       => 'lz_fitness_premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'Hexagon' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Hexagon' ),
				'off' => __( 'No', 'Hexagon' )
			),
		)
	)
);

$wp_customize->add_setting('lz_fitness_premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_premium_slider_section_lbl',
		array(
			'settings'		=> 'lz_fitness_premium_slider_section_lbl',
			'section'		=> 'lz_fitness_premium_slider_section',
			'label'			=> __( 'Note:', 'Hexagon' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'Hexagon' ),
		)
	)
);


// to show & hide another button
$wp_customize->add_setting( 'hexagonsliderhomepsecanimation_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'hexagonsliderhomepsecanimation_button_display', array( 'label' => 'Animation Display Setting', 'section' => 'lz_fitness_premium_slider_section', 'settings' => 'hexagonsliderhomepsecanimation_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Start animation', 'hide' => 'Stop Animation', ), ) ); 
// end to show & hide button

addColorPalatOption($wp_customize, 'lz_fitness_hexagonsliderhomepsecanimation_animationboxColor', 'lz_fitness_premium_slider_section', 'Select animated box color','#e7ccf7');



// to show & hide another button
// $wp_customize->add_setting( 'hexagonsliderhomepsectrishape_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'hexagonsliderhomepsectrishape_button_display', array( 'label' => 'Show/Hide Slider Shape:', 'section' => 'lz_fitness_premium_slider_section', 'settings' => 'hexagonsliderhomepsectrishape_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Slider Circular Shape', 'hide' => 'Hide Slider Circular Shape', ), ) ); 
// end to show & hide button




// lzCustomLable($wp_customize, 'lz_fitness_slideropacilty', 'lz_fitness_premium_slider_section', 'Set slider overlay opacity & slider overlay Background color:');


// $wp_customize->add_setting(
// 	'pages_slideopacity',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( '1', 'lz-fitness-premium' )
// 	)
// );
// $wp_customize->add_control(
// 	'pages_slideopacity',
// 	array(
// 		'settings'      => 'pages_slideopacity',
// 		'section'       => 'lz_fitness_premium_slider_section',
// 		'type'          => 'text',
// 		'label'         => __( 'Add Opacity Here:', 'lz-fitness-premium' )
// 	)
// );
// for gradiant

$wp_customize->add_setting(
    'lz_fitness_premium_slider_bg_color_one', array(
        'default'           => '#5127c3',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_premium_slider_bg_color_one',array(
            'settings'      => 'lz_fitness_premium_slider_bg_color_one',
            'section'       => 'lz_fitness_premium_slider_section',
            'label'         => __( 'Slider Background Gradient Color One ', 'Luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'lz_fitness_premium_slider_bg_color_two', array(
        'default'           => '#c166ef',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'lz_fitness_premium_slider_bg_color_two',array(
            'settings'      => 'lz_fitness_premium_slider_bg_color_two',
            'section'       => 'lz_fitness_premium_slider_section',
            'label'         => __( 'Slider Background Gradient Color Two ', 'Luzuk Premium' ),
        )
    )
); 


//addColorPalatOption($wp_customize, 'slider_overlaybgsColor', 'lz_fitness_premium_slider_section', 'Slider Highlight Box Background Color', '#6743c4'); 

addColorPalatOption($wp_customize, 'slider_overlaycompletebgsColor', 'lz_fitness_premium_slider_section', 'Slider Complete Box Background Color', '#fff');


addColorPalatOption($wp_customize, 'slider_TitleColor', 'lz_fitness_premium_slider_section', 'Slider Title Color', '#fff');
addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Color', '#fff');
addColorPalatOption($wp_customize, 'slider_HighlightTitleColor', 'lz_fitness_premium_slider_section', 'Slider Text Color', '#fff');


addColorPalatOption($wp_customize, 'slider_rightimgbrssclrColor', 'lz_fitness_premium_slider_section', 'Slider Image Border Color', '#fff');
addColorPalatOption($wp_customize, 'slider_rightimgbrssclrhighlightColor', 'lz_fitness_premium_slider_section', 'Slider Image Highlight Border Color', '#462494');



lzCustomLable($wp_customize, 'lz_fitness_sliderotherclrs', 'lz_fitness_premium_slider_section', 'Set button colors:');

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Color', '#fff');
addColorPalatOption($wp_customize, 'slider_buttontexthvrColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'slider_buttonborderColor', 'lz_fitness_premium_slider_section', 'Slider Button Border Color', '#fff');
addColorPalatOption($wp_customize, 'slider_buttonborderhverColor', 'lz_fitness_premium_slider_section', 'Slider Button Border Hover Color', '#411173');
addColorPalatOption($wp_customize, 'slider_buttonborderhvrhghtclColor', 'lz_fitness_premium_slider_section', 'Slider Button Hover Highlight Border Color', '#fff');

addColorPalatOption($wp_customize, 'slider_buttonbgsshmpColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Color', '#6943c4');
addColorPalatOption($wp_customize, 'slider_buttonbgsshverColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Hover Color', '#411173');

