<?php 
    $wp_customize->add_section(
        'about_section',
        array(
            'title' => __( 'About Section', 'Luzuk' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_section_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_section_disable',
            array(
                'settings'      => 'about_section_disable',
                'section'       => 'about_section',
                'label'         => __( 'Disable Section', 'Luzuk' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'Luzuk' ),
                    'off' => __( 'No', 'Luzuk' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'about', 'about_section', $color='#ffffff'); 


lzCustomLable($wp_customize, 'AboutDoctorSectionPadding', 'about_section', 'Section Padding');

$wp_customize->add_setting(
    'aboutTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutTpadding',
    array(
        'settings'      => 'aboutTpadding',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'aboutBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutBpadding',
    array(
        'settings'      => 'aboutBpadding',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk' )
    )
);


lzCustomLable($wp_customize, 'abutheadsettings', 'about_section', 'Heading , Sub heading Setting');

    $wp_customize->add_setting(
        'aboutmain_subtitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'About Architecture Studio', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'aboutmain_subtitle',
        array(
            'settings'      => 'aboutmain_subtitle',
            'section'       => 'about_section',
            'type'          => 'textarea',
            'label'         => __( 'Sub Heading', 'Luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'about_subheadColor', 'about_section', 'Sub Heading Color', '#979797');

    $wp_customize->add_setting(
        'about_maintitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'About Studio', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_maintitle',
        array(
            'settings'      => 'about_maintitle',
            'section'       => 'about_section',
            'type'          => 'text',
            'label'         => __( 'Heading', 'Luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'about_headColor', 'about_section', 'Heading Color', '#131313');

addColorPalatOption($wp_customize, 'about_headbrd', 'about_section', 'Heading Border Color', '#cccccc');

$wp_customize->add_setting(
        'aboutdoctor_title_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutdoctor_title_heading',
            array(
                'settings'      => 'aboutdoctor_title_heading',
                'section'       => 'about_section',
                'label'         => __( 'About Details', 'Luzuk' ),
            )
        )
    );   

        $wp_customize->add_setting(
        'about_subtitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'WE HAVE 09+ YEARS OF EXPERIENCE', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_subtitle',
        array(
            'settings'      => 'about_subtitle',
            'section'       => 'about_section',
            'type'          => 'textarea',
            'label'         => __( 'Sub Title', 'Luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'about_SubTitleColor', 'about_section', 'Sub Title Color', '#131313');


$wp_customize->add_setting(
        'about_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'We Are An Award Winning Interiour Design Studio', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_title',
        array(
            'settings'      => 'about_title',
            'section'       => 'about_section',
            'type'          => 'textarea',
            'label'         => __( 'Title', 'Luzuk' )
        )
    );
addColorPalatOption($wp_customize, 'about_TitleColor', 'about_section', 'Title Color', '#131313');

$wp_customize->add_setting(
        'about_content',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s.', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_content',
        array(
            'settings'      => 'about_content',
            'section'       => 'about_section',
            'type'          => 'textarea',
            'label'         => __( 'Content', 'Luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'about_ContentColor', 'about_section', 'Content Color', '#131313');

lzCustomLable($wp_customize, 'buttontextsettings', 'about_section', 'Button Text, Button Link & Its Colors:');


// button
$wp_customize->add_setting( 'about_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_button_display', array( 'label' => 'About Button Display', 'section' => 'about_section', 'settings' => 'about_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'about_button1',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Discover More', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_button1',
        array(
            'settings'      => 'about_button1',
            'section'       => 'about_section',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
$wp_customize->add_setting('about_link',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('about_link',
    array(
        'settings'      => 'about_link',
        'section'       => 'about_section',
        'type'          => 'url',
        'label'         => __( 'Add Link For Button:', 'Luzuk' )
    )
);    

addColorPalatOption($wp_customize, 'about_ButtonTextColor', 'about_section', 'Button Text & Arrow Color', '#fff');

addColorPalatOption($wp_customize, 'about_ButtonTexthvColor', 'about_section', 'Button Text & Arrow Hover Color', '#000');

addColorPalatOption($wp_customize, 'about_ButtonbgColor', 'about_section', 'Button Background Color', '#000');

addColorPalatOption($wp_customize, 'about_ButtonbghvColor', 'about_section', 'Button Background Hover Color', '#fff');

// end to show & hide button


//section Image

$wp_customize->add_setting(
        'about_image5_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image5_heading',
        array(
            'settings'      => 'about_image5_heading',
            'section'       => 'about_section',
            'label'         => __( 'About Section Right Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image5',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image5',
        array(
            'section' => 'about_section',
            'settings' => 'about_image5',
            'description' => __('Recommended Image Size: 350X260px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'abimgbxtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Architecture Designer', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abimgbxtxt',
    array(
        'settings'      => 'abimgbxtxt',
        'section'       => 'about_section',
        'type'          => 'text',
        'label'         => __( 'Image Box Text', 'Luzuk' )
    )
);


addColorPalatOption($wp_customize, 'abimgbxtxtcolor', 'about_section', 'Image Box Text Color', '#fff');
addColorPalatOption($wp_customize, 'abimgbxbrdcolor', 'about_section', 'Button Border Hover Color', '#000');

$wp_customize->add_setting(
    'abicntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '"Lorem ipsum dolor sit amet, consectetur adipiscing elit"', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abicntxt',
    array(
        'settings'      => 'abicntxt',
        'section'       => 'about_section',
        'type'          => 'textarea',
        'label'         => __( 'Icon Text', 'Luzuk' )
    )
);


addColorPalatOption($wp_customize, 'abicncolor', 'about_section', 'Icon Color', '#000');

addColorPalatOption($wp_customize, 'abicnhvcolor', 'about_section', 'Icon Hover Color', '#ccc');

addColorPalatOption($wp_customize, 'abicntxtcolor', 'about_section', 'Icon Text Color', '#000');