<?php 
    $wp_customize->add_section(
        'banner_area',
        array(
            'title' => __( 'Banner Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'banner_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'banner_area_disable',
            array(
                'settings'      => 'banner_area_disable',
                'section'       => 'banner_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 
    
backgroundManager($wp_customize, 'banner', 'banner_area', $color='#fff', get_template_directory_uri().'/images/bannerbg.jpg', 'color');

lzCustomLable($wp_customize, 'bannerarea_padding', 'banner_area', 'Section Padding:');

$wp_customize->add_setting(
    'banner_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_areaTpadding',
    array(
        'settings'      => 'banner_areaTpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'banner_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '11em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_areaBpadding',
    array(
        'settings'      => 'banner_areaBpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'banner_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner_title_heading',
        array(
            'settings'      => 'banner_title_heading',
            'section'       => 'banner_area',
            'label'         => __( 'Section Heading, Sub Heading Text', 'luzuk-premium' ),
        )
    )
);    

$wp_customize->add_setting(
    'banner_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<span>Its time to upgrade to a lonely planet </span>membership.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_title',
    array(
        'settings'      => 'banner_title',
        'section'       => 'banner_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'bnrara_title', 'banner_area', 'Section Title Color ', '#131313');
addColorPalatOption($wp_customize, 'bnrara_titlehg', 'banner_area', 'Section Title Highlight Color ', '#131313');

    $wp_customize->add_setting(
        'banner_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has industrys.', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'banner_text',
        array(
            'settings'      => 'banner_text',
            'section'       => 'banner_area',
            'type'          => 'textarea',
            'label'         => __( 'Section Text', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'bnrara_txt', 'banner_area', 'Section Text Color ', '#979797');



lzCustomLable($wp_customize, 'bannerarea_button_display', 'banner_area', 'Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'bannerarea_button' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'bannerarea_button', array( 'label' => 'Button Display', 'section' => 'banner_area', 'settings' => 'bannerarea_button', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'bannerareabutton',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'DISCOVER MORE' )
    )
);
$wp_customize->add_control(
    'bannerareabutton',
    array(
        'settings'      => 'bannerareabutton',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'Luzuk Theme' )
    )
);
$wp_customize->add_setting('bannerareabuttonlink',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bannerareabuttonlink',
    array(
        'settings'      => 'bannerareabuttonlink',
        'section'       => 'banner_area',
        'type'          => 'url',
        'label'         => __( 'Button Url', 'Luzuk Theme' )
    )
);

addColorPalatOption($wp_customize, 'bnrara_btntxt', 'banner_area', 'Button Text Color ', '#131313');

addColorPalatOption($wp_customize, 'bnrara_btntxthv', 'banner_area', 'Button Text Hover Color ', '#ff1944');

addColorPalatOption($wp_customize, 'bnrara_btnicnbrd', 'banner_area', 'Button Icon & Border Color ', '#ff1944');

addColorPalatOption($wp_customize, 'bnrara_btnicnbrdhv', 'banner_area', 'Button Icon & Border Hover Color ', '#1313113');