<?php 

$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Destinations Section', 'Luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading & Sub Heading', 'Luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'services_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<span>Top</span> Destinations', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle',
    array(
        'settings'      => 'services_maintitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_sectitle_color', 'service_area', 'Section Heading Color ', '#131313');
addColorPalatOption($wp_customize, 'servicearahedhg', 'service_area', 'Section Heading Highlight Color ', '#131313');

$wp_customize->add_setting(
    'services_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has industrys.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_subtitle',
    array(
        'settings'      => 'services_subtitle',
        'section'       => 'service_area', 
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_secsubtitle_color', 'service_area', 'Section Sub Heading Color ', '#979797');


$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note2:', 'Luzuk' ),  
            'description'   => __( 'Use Shortcode [DESTINATIONS] to show all services in a page & images use Same Height', 'Luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number of Destinations to show', 'Luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number of Destinations to show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$ServicesSingleChoice[] = 'Select';
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Destinations Page', 'Luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select a Destinations Page', 'Luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-street-view',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'Luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'Luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'Luzuk' ),
                )
            )
        );
    }
 
}

lzCustomLable($wp_customize, 'luzuk_sec_servicescolor', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'serimghv', 'service_area', 'Section Image Overlay Color ', '#ff1944');

addColorPalatOption($wp_customize, 'services_ServicePageTitleColor', 'service_area', 'Section Destinations Name Color ', '#131313');

addColorPalatOption($wp_customize, 'services_ServicePageTitlehv', 'service_area', 'Section Destinations Name Hover Color ', '#ff1944');

addColorPalatOption($wp_customize, 'serday', 'service_area', 'Section Duration Color ', '#979797');

addColorPalatOption($wp_customize, 'serdur', 'service_area', 'Section Days Color ', '#131313');

addColorPalatOption($wp_customize, 'services_ServicePageIconColor', 'service_area', 'Section Icon Color ', '#979797');

lzCustomLable($wp_customize, 'service_button_displaylabel', 'service_area', 'Section Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'allservices_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'allservices_button_display', array( 'label' => 'Button Display', 'section' => 'service_area', 'settings' => 'allservices_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
    'services_allservicesbtn_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'VIEW ALL DESTINATION' )
    )
);
$wp_customize->add_control(
    'services_allservicesbtn_txt',
    array(
        'settings'      => 'services_allservicesbtn_txt',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('services_allservicesbtnlink',  array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('services_allservicesbtnlink',
    array(
        'settings'      => 'services_allservicesbtnlink',
        'section'       => 'service_area',
        'type'          => 'url',
        'label'         => __( 'Add Button link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'Service_btnColor', 'service_area', 'Section Button Color', '#fff');

addColorPalatOption($wp_customize, 'Service_btnbgColor', 'service_area', 'Section Button Background Color', '#ff1944');

addColorPalatOption($wp_customize, 'Service_btnhoverColor', 'service_area', 'Section Button Hover Color', '#ff1944');

addColorPalatOption($wp_customize, 'Service_btnbghoverColor', 'service_area', 'Section Button Background Hover Color', '#131313');

