<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />

	<link rel="preconnect" href="https://fonts.gstatic.com">
	<link href="https://fonts.googleapis.com/css2?family=Meddon&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">

	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<header class="site-header header-transparent header mo-left header-seo">
			<!-- <div class="clearfix"> -->
			<div class="top-bar-head">
				<?php 	
					$header_emailid = get_theme_mod('header_emailid', 'kichensworld.com');
					$header_emailidtxt = get_theme_mod('header_emailidtxt', 'Email:');
					$header_phhone = get_theme_mod('header_phhone', '+089 678 034');
					$header_phhonetxt = get_theme_mod('header_phhonetxt', 'Call Us:');
						
					$facebook = get_theme_mod('header_fb', '//facebook.com/');
					$twitter = get_theme_mod('header_tw', '//twitter.com/');
					$instagram = get_theme_mod('header_insta', 'https://www.instagram.com/');
					$linkedin = get_theme_mod('header_in', 'https://in.linkedin.com/');
				?>
				<?php if($header_phhonetxt || $header_phhone || $header_emailidtxt || $header_emailid || $facebook || $twitter || $instagram || $linkedin){ ?>		
				<div class="head-inn"> 
					<div class="container"> 
						<div class="col-xl-6 col-md-6 col-sm-3 col-xs-3">
							<div class="header-share"> 
								<button type="button" class="btn share-icn"><i class="fa fa-share-alt" aria-hidden="true"></i> </button>
								<div class="share-btn">
									<ul>
										<?php if(!empty($facebook)){ ?>
											<li><a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a></li>
										<?php }?>

										<?php if(!empty($twitter)){ ?>
											<li><a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
										<?php }?>
										<?php if(!empty($instagram)){ ?>
											<li><a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
										<?php }?>
										<?php if(!empty($linkedin)){ ?>
											<li><a href="<?php echo $linkedin ?>" title="Linkedin" class="site-button sharp" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
										<?php }?>
										<div class="clearfix"></div>
									</ul>
								</div>
								<div class="clearfix"></div>
							</div>
						</div>
						<?php if($header_phhonetxt || $header_phhone || $header_emailidtxt || $header_emailid){ ?>
						<div class="col-xl-6 col-md-6 col-sm-9 col-xs-9 headcontact">
							<div class="Reg">
								<?php if($header_phhonetxt || $header_phhone ){ ?>
									<li><a href="tel:<?php echo $header_phhone;?>"><i class="fa fa-phone blink"></i><?php echo ($header_phhonetxt);  ?> <span class="tooltiptext"><?php echo ($header_phhone);  ?></span></a></li>
								<?php } ?>

								<?php if($header_emailidtxt || $header_emailid ){ ?>
									<li><a href="mailto:<?php echo $header_emailid;?>"><i class="fa fa-envelope-o blink"></i><?php echo ($header_emailidtxt);  ?><span class="tooltiptext"> <?php echo ($header_emailid);  ?></span></a></li>
								<?php } ?>
						 	</div>
						</div>
						<?php } ?>	
					</div> 
					<div class="clearfix"></div>
				</div>		
				<?php }?>
				<div class="container">
					<div class="row row-eq-height">
						<div class="logo col-xl-3 col-md-3 col-sm-5 col-xs-5">
							<div class="inside-full-height">
							<?php 
							
								if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
									$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
								}
								if( get_theme_mod('pages_logoTpadding',true) ) {
									$pages_logoTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTpadding')).';';
								}
								if( get_theme_mod('pages_logoBpadding',true) ) {
									$pages_logoBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBpadding')).';';
								}
								if( get_theme_mod('pages_logoLpadding',true) ) {
									$pages_logoLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLpadding')).';';
								}
								if( get_theme_mod('pages_logoRpadding',true) ) {
									$pages_logoRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRpadding')).';';
								}

							?>
								<!-- website logo -->
								<div class="logo-header mostion">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
								</div> 
								<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>  
							<!-- nav toggle button -->
								<div class="resp_header_logo">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
										<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
									<?php endif; ?>
								</div>
							</div>
						</div>
						<div class="col-xl-9 col-md-9 col-sm-7 col-xs-7 pd-0 HeaderRbx">
						  	<div class="col-xl-12 col-md-12 pd-0">
								<div class="header-right">
									<div class="row ">
										<div class="head-menu col-xl-10 col-lg-10 col-md-11 col-sm-9 col-xs-9">
											<div class="inside-full-height">
												<div class="site-navigation ">
													 <div class="nav-menus">                 
												<a class="js-nav-toggle">
													<span></span>
												</a>
												<div class="nav-wrapper">
													<nav role="navigation">
														<div class="nav-toggle">
															<span class="nav-back"></span>
															<span class="nav-title">Menu</span>
															<span class="nav-close"></span>
														</div>
														<?php
					                                      if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
					                                          wp_nav_menu ( array(
					                                              'menu_class' => 'mainm ht-clearfix',
					                                              'container'=> 'ul',
					                                              'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
					                                              'theme_location' => 'primary',  
					                                          )); 
					                                      } else {
					                                          wp_nav_menu ( array(
					                                              'menu_class' => 'mainm ht-clearfix',
					                                              'container'=> 'ul',
					                                              'theme_location' => 'primary',  
					                                          )); 
					                                      }
						                                ?>
													</nav>
												</div>
											</div>
							                        <nav class="navigation">
					                            		<div class="overlaybg"></div>
							                            <div class="menu-wrapper">
							                                <div class="menu-content">
							                                    <?php
							                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
							                                            wp_nav_menu ( array(
							                                                'menu_class' => 'mainmenu ht-clearfix',
							                                                'container'=> 'ul',
							                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
							                                                'theme_location' => 'primary',  
							                                            )); 
							                                        } else {
							                                            wp_nav_menu ( array(
							                                                'menu_class' => 'mainmenu ht-clearfix',
							                                                'container'=> 'ul',
							                                                'theme_location' => 'primary',  
							                                            )); 
							                                        }
							                                    ?>
							                                </div> <!-- /.hours-content-->
															<div class="clearfix"></div>
							                            </div><!-- /.menu-wrapper --> 
													 	<!-- <div class="mobnone">
															<div class="col-md-6 col-sm-6 col-xs-6">
														
															<?php if( get_theme_mod('shop_button_display','show' ) == 'show') :?>
																<div class="hshop">
																<?php if(function_exists ('wc_get_cart_url')){?>				
																	<a href="<?php echo wc_get_cart_url();?>" class="">
																		<i class="fa fa-shopping-basket"></i>
																	</a>
																	<div class="count">
																		<?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?>	
																	</div>
																<?php }?>
																</div>
															<?php endif ?>
															</div>
														</div>  -->
					                        		</nav>
												 	<div class="clearfix"></div>
												</div><!--  /.site-navigation -->
											</div>
										</div>
										<div class="col-xl-2 col-lg-2 col-md-1 col-sm-3 col-xs-3 hbtn ">
											<?php if( get_theme_mod('shop_button_display','show' ) == 'show') :?>
											
												<div class="hshop">
												<?php if(function_exists ('wc_get_cart_url')){?>				
													<a href="<?php echo wc_get_cart_url();?>" class="">
														<i class="fa fa-shopping-basket"></i>
													</a>
													<div class="count">
														<?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?>	
													</div> 
												<?php }?>
												</div>
											
											<?php endif ?>
										</div>
										<div class="clearfix"></div>
									</div>
									<div class="clearfix"></div>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
					</div>
				</div>
			</div>
			<!-- </div> -->			
			<div class="clearfix"></div>
		</header>
	</div>
<script type="text/javascript">
    $( document ).ready(function() {
     $( "header .share-icn" ).click(function(e) {
         $('header .share-btn').not($(this).next( "header .share-btn" )).each(function(){
            $(this).removeClass("active");
         });
     
            $(this).next( "header .share-btn" ).toggleClass( "active" );
    });   
});
</script> 