<?php  
$wp_customize->add_section(
	'luzuk_premium_contactus_section',
	array(
		'title' => __( 'Contact Us Page', 'Luzuk' ),
		'priority' =>20
	)
);

backgroundManager($wp_customize, 'con_us', 'luzuk_premium_contactus_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'allcontact_heading2label', 'luzuk_premium_contactus_section', 'Contact Heading Font Size Setting:');

$wp_customize->add_setting(
    'contactpages_innerpageheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '45px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactpages_innerpageheading2',
    array(
        'settings'      => 'contactpages_innerpageheading2',
        'section'       => 'luzuk_premium_contactus_section',
        'type'          => 'text',
        'label'         => __( 'Contact Heading Font Size', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'contactus_Form_label', 'luzuk_premium_contactus_section', 'Form Block Setting');

$wp_customize->add_setting(
	'luzuk_contactus_formtitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Enquiry Now', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'luzuk_contactus_formtitle',
	array(
		'settings'      => 'luzuk_contactus_formtitle',
		'section'       => 'luzuk_premium_contactus_section',
		'type'          => 'text',
		'label'         => __( 'Form Title', 'Luzuk Premium' )
	)
);

lzAddElement($wp_customize, 'luzuk_contactus_shortcode', 'luzuk_premium_contactus_section', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

lzCustomLable($wp_customize, 'contactus_form_clr', 'luzuk_premium_contactus_section', 'Contact Form Color Setting');

//Contact heading color
addColorPalatOption($wp_customize, 'luzuk_contactus_titleColor', 'luzuk_premium_contactus_section', 'Heading Color', '#000');

//Form Label color
addColorPalatOption($wp_customize, 'luzuk_contactus_formlabelColor', 'luzuk_premium_contactus_section', 'Form Label Color', '#000');

//Form text and placeholder color
addColorPalatOption($wp_customize, 'luzuk_contactus_formtextplaceColor', 'luzuk_premium_contactus_section', 'Form Text and Placeholder Color', '#000');

//Form border bottom color
addColorPalatOption($wp_customize, 'luzuk_contactus_formborderbottomColor', 'luzuk_premium_contactus_section', 'Form Background Color', '#f1f1f1');

addColorPalatOption($wp_customize, 'luzuk_contactus_formborderClr', 'luzuk_premium_contactus_section', 'Form Border Color', '#f1f1f1');

//Button color
addColorPalatOption($wp_customize, 'luzuk_contactus_formbtnColor', 'luzuk_premium_contactus_section', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_contactus_formbtnhoverColor', 'luzuk_premium_contactus_section', 'Form Button Text Hover Color', '#d3ad64');

//Button bg color
addColorPalatOption($wp_customize, 'luzuk_contactus_formbtnbgColor', 'luzuk_premium_contactus_section', 'Form Button Background Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_contactus_formbtnbghoverColor', 'luzuk_premium_contactus_section', 'Form Button Background Hover Color', '#000');
lzCustomLable($wp_customize, 'contact_rhsimg', 'luzuk_premium_contactus_section', 'Right Side Box Image');

$wp_customize->add_setting(
    'coninn_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'coninn_image',
        array(
            'section' => 'luzuk_premium_contactus_section',
            'settings' => 'coninn_image',
            'description' => __('Recommended Image Size: 450X350px', 'luzuk-premium')
        )
    )
);


lzCustomLable($wp_customize, 'contactus_contact_label', 'luzuk_premium_contactus_section', 'Contact Details Block Setting');

lzAddElement($wp_customize, 'luzuk_contactus_mailatitle', 'luzuk_premium_contactus_section', 'text', $label="Contact Us Email Label", 'luzuk_sanitize_text', 'EMAIL US');

lzAddElement($wp_customize, 'luzuk_contactus_email', 'luzuk_premium_contactus_section', 'text', $label="Contact Us Email", 'luzuk_sanitize_text', 'info@example.com');

lzAddElement($wp_customize, 'luzuk_contactus_phonetitle', 'luzuk_premium_contactus_section', 'text', $label="Contact Us Phone Label", 'luzuk_sanitize_text', 'CALL US');

lzAddElement($wp_customize, 'luzuk_contactus_phone', 'luzuk_premium_contactus_section', 'text', $label="Contact Us Phone", 'luzuk_sanitize_text', '+123 456 7890');

lzAddElement($wp_customize, 'luzuk_contactus_addtitle', 'luzuk_premium_contactus_section', 'text', $label="Contact Us Address Label", 'luzuk_sanitize_text', 'LOCATION');

lzAddElement($wp_customize, 'luzuk_contactus_address', 'luzuk_premium_contactus_section', 'textarea', $label="Address Line One", 'luzuk_sanitize_text', 'Add Contact Address here..');

lzAddElement($wp_customize, 'luzuk_contactus_addressdata1', 'luzuk_premium_contactus_section', 'textarea', $label="Address Line Two", 'luzuk_sanitize_text', '');

lzAddElement($wp_customize, 'luzuk_contactus_addressdata2', 'luzuk_premium_contactus_section', 'textarea', $label="Address Line Three", 'luzuk_sanitize_text', '');


lzCustomLable($wp_customize, 'contactus_Address_label', 'luzuk_premium_contactus_section', 'Address Map Setting');

// ADDRESS GOOGLE/MSN/OTHER MAP IFRAME OR EMBADE CODE
$wp_customize->add_setting('luzuk_contactus_iframe_lbl', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading($wp_customize, 'luzuk_contactus_iframe_lbl',
		array(
			'settings'      => 'luzuk_contactus_iframe_lbl',
			'section'       => 'luzuk_premium_contactus_section',
			'label'         => __( 'Location Map', 'Luzuk' ),
		)
	)
);
// field for addeding the map code
$wp_customize->add_setting('luzuk_contactus_embade', array(/*'sanitize_callback' => 'esc_url_raw',*/ 'default'=>'Add your map embade code'));
$wp_customize->add_control('luzuk_contactus_embade', array('settings'=>'luzuk_contactus_embade', 'section'=>'luzuk_premium_contactus_section','type'=>'textarea', 'label'=> __('Code for map', 'Luzuk')));

lzCustomLable($wp_customize, 'contactus_Add_color', 'luzuk_premium_contactus_section', 'Set Contact Colors:');



//Contact box color
addColorPalatOption($wp_customize, 'luzuk_contactus_boxColor', 'luzuk_premium_contactus_section', 'Contact Box Color One', '#f1f1f1');

//Contact box color
addColorPalatOption($wp_customize, 'luzuk_contactus_box1Color', 'luzuk_premium_contactus_section', 'Contact Box Color Two', '#f1f1f1');

//Contact Details icon color
addColorPalatOption($wp_customize, 'luzuk_contactus_detailiconColor', 'luzuk_premium_contactus_section', 'Contact Phone, Email, Address & Icon Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_contactus_detailiconbrdColor', 'luzuk_premium_contactus_section', 'Contact Phone, Email, Address & Icon Background Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_contactus_detailemailtitleColor', 'luzuk_premium_contactus_section', 'Contact Email & Phone No. Title Color', '#000');
//Contact Details Email color
addColorPalatOption($wp_customize, 'luzuk_contactus_detailemailColor', 'luzuk_premium_contactus_section', 'Contact Email & Phone No. Color', '#000');

//Contact Details Email hover color
addColorPalatOption($wp_customize, 'luzuk_contactus_detailemailhoverColor', 'luzuk_premium_contactus_section', 'Contact Details Email & Phone No. Hover Color', '#d3ad64');

//Contact Details Information color
addColorPalatOption($wp_customize, 'luzuk_contactus_detailinfoColor', 'luzuk_premium_contactus_section', 'Contact Details Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_contactus_detailinfobrdClr', 'luzuk_premium_contactus_section', 'Contact Details Box Border Color', '#d3ad64');


