<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );
addColorPalatOption($wp_customize, 'header_SiteColor', 'title_tagline', 'Site Title Color', '#d3ad64');
addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'title_tagline', 'Tagline Color', '#000');

lzCustomLable($wp_customize, 'pageslogosetmaxwidthl', 'title_tagline', 'Add Logo Max Width:');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'pageslogopaddingl', 'title_tagline', 'Add Logo Padding:');

$wp_customize->add_setting(
    'pages_logoTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '18px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTpadding',
    array(
        'settings'      => 'pages_logoTpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Top Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoBpadding',
    array(
        'settings'      => 'pages_logoBpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoLpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoLpadding',
    array(
        'settings'      => 'pages_logoLpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Left Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoRpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoRpadding',
    array(
        'settings'      => 'pages_logoRpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Right Padding', 'luzuk-premium' )
    )
);



//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'Luzuk Themethemes Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';

lzCustomLable($wp_customize, 'header_bgColorssettings', $sectionHeader, 'Header Setting');

addColorPalatOption($wp_customize, 'header_tpbgColor', 'header_settings', 'Top Header Background Color', '#3e454b');
addColorPalatOption($wp_customize, 'header_tpconttilebgClr', 'header_settings', 'Top Header Contact Details Background Color', '#d5ab63');
addColorPalatOption($wp_customize, 'header_bgColor', 'header_settings', 'Logo Background Color', '#fff');
addColorPalatOption($wp_customize, 'header_albgColor', 'header_settings', 'Header Background Color', '#fff');

lzCustomLable($wp_customize, 'reservation_lblImgTxt', 'header_settings' , 'Social media icons');

// FACEBOOK 
$wp_customize->add_setting('header_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_fb',
    array(
        'settings'      => 'header_fb',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);
// TWITTER
$wp_customize->add_setting('header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_tw',
    array(
        'settings'      => 'header_tw',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

//Instagram
$wp_customize->add_setting('header_insta',array('default'=> 'https://www.instagram.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_insta',
    array(
        'settings'      => 'header_insta',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

//youtube
$wp_customize->add_setting('header_in',array('default'=> 'https://in.linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_in',
    array(
        'settings'      => 'header_in',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Linkedin Url', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'header_solicnClr', 'header_settings', 'Header Social Icon Color', '#cbcdcc'); 
addColorPalatOption($wp_customize, 'header_solicnhvClr', 'header_settings', 'Header Social Icon Hover Color', '#d4ac64'); 

lzCustomLable($wp_customize, 'header_condetailsTxt', 'header_settings', 'Set Header Contact Details:');

$wp_customize->add_setting(
    'header_phhonetxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Call Us:' )
    )
);
$wp_customize->add_control(
    'header_phhonetxt',
    array(
        'settings'      => 'header_phhonetxt',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Phone Text', 'Luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'header_phhone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+089 678 034' )
    )
);
$wp_customize->add_control(
    'header_phhone',
    array(
        'settings'      => 'header_phhone',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Phone No.', 'Luzuk Premium' )
    )
);


$wp_customize->add_setting(
    'header_emailidtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Email:' )
    )
);
$wp_customize->add_control(
    'header_emailidtxt',
    array(
        'settings'      => 'header_emailidtxt',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Email Text', 'Luzuk Premium' )
    )
);

$wp_customize->add_setting(
    'header_emailid',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'kichensworld.com' )
    )
);
$wp_customize->add_control(
    'header_emailid',
    array(
        'settings'      => 'header_emailid',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Email Id', 'Luzuk Premium' )
    )
);
addColorPalatOption($wp_customize, 'header_mailphoneColor', 'header_settings', 'Email Text & Phone No. & Text Color', '#fff'); 
addColorPalatOption($wp_customize, 'header_mailphoneiconColor', 'header_settings', 'Email & Phone No. Icon Color', '#fff'); 
addColorPalatOption($wp_customize, 'header_mailphonehoverColor', 'header_settings', 'Email Text & Phone No. & Text Hover Color', '#000');

lzCustomLable($wp_customize, 'shop_button_displaylabel', 'header_settings', 'Header Shoping Cart Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'shop_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'shop_button_display', array( 'label' => 'Header Shoping Cart Display', 'section' => 'header_settings', 'settings' => 'shop_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Shop Cart', 'hide' => 'Hide Shop Cart', ), ) ); 
// end to show & hide button

addColorPalatOption($wp_customize, 'header_cartclr', 'header_settings', 'Add To Cart Icon Color', '#404549');
addColorPalatOption($wp_customize, 'header_carthvclr', 'header_settings', 'Add To Cart Icon Hover Color', '#d4ac64');
addColorPalatOption($wp_customize, 'header_carnoclr', 'header_settings', 'Add To Cart Number Color', '#fff');
addColorPalatOption($wp_customize, 'header_carnobgclr', 'header_settings', 'Add To Cart Number Background Color', '#000');

lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Colors');


addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus Color', '#4c4c4c');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover Color', '#d4ac64');

addColorPalatOption($wp_customize, 'header_topmenusbghoverClr', 'header_settings', 'Menus Background Hover Color', '#000');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#d4ac64');

//addColorPalatOption($wp_customize, 'header_actmenusbgClr', 'header_settings', 'Menus Hover Background & Active Menus Background Color', '#62cdb9');

addColorPalatOption($wp_customize, 'header_topmenusarrowColor', 'header_settings', 'Menus Dropdown Arrow Color', '#858585');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#ffffff');

addColorPalatOption($wp_customize, 'header_topsubmenushvColor', 'header_settings', 'Header Sub Menus Hover Color', '#fff');

//addColorPalatOption($wp_customize, 'header_topsubmenushvrbgColor', 'header_settings', 'Sub Menus Hover Background Color', '#d4ac64');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Background Color', '#000');


lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header ');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#000');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuttlbgColor', 'header_settings', 'Menus Title BG Color', '#d5d5d5');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuColor', 'header_settings', 'Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'header_settings', 'Menus BG Color', '#000');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#d3ad64');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#3e454b');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

lzCustomLable($wp_customize, 'innheadr_Overlay', 'colors', 'Header Overlay Color:');

$wp_customize->add_setting(
    'innheadr_Opacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.3', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innheadr_Opacity',
    array(
        'settings'      => 'innheadr_Opacity',
        'section'       => 'colors',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_headeolyclr', 'colors', 'Inner Page Header Ovaerlay Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner Page Title Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor1', 'colors', 'Inner Page Title Background Color One', '#ccc'); 
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor2', 'colors', 'Inner Page Title Background Color Two', '#0a0607'); 

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background Color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading 1 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading 2 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading 3 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading 4 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading 5 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading 6 Color', '#121a36');

addColorPalatOption($wp_customize, 'innerpagemainsectioninnerpagemainsectionboxheadingborderc1', 'colors', 'Heading Border Color', '#d3ad64');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlecolor', 'colors', 'Inner Page Sidebar Heading', '#676767');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlebordercolor', 'colors', 'Inner Page Sidebar Heading Border & Product Button Background Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text Color', '#666');

addColorPalatOption($wp_customize, 'template_innerpage_productpageboldtextcolor', 'colors', 'Inner Product Page Bold Text Color', '#000');

addColorPalatOption($wp_customize, 'template_innerpage_cartpageproducttitlecolor', 'colors', 'Inner  Cart Page Product Title Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductprice_color', 'colors', 'Inner Page Product Selling Price Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductpricedel_color', 'colors', 'Inner Page Product Price Color', '#7c8491');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextcolcolor_color', 'colors', 'Other Text Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextbgsscolcolor_color', 'colors', 'Others Fields Background Color', '#fff');



addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links Color', '#4f4c4c');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover Color', '#131313');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list number Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list number Background Color', '#b5b1b3');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionsidebarbg_color', 'colors', 'Inner Page Sidebar & text field Background Color', '#f1f1f1');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & text field Border Color', '#e4e2e2');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaytxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaybgsstxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Background Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesblockquote_color', 'colors', 'Inner Page blockquote Background Color', '#f2f2f2');


lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_pagination', 'colors', 'Color Setting For Pagination:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepagination_color', 'colors', 'Inner Page Pagination Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbg_color', 'colors', 'Inner Page Pagination Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborder_color', 'colors', 'Inner Page Pagination Border Color', '#eaeaea');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationactive_color', 'colors', 'Inner Page Pagination Hover & Active Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbgactive_color', 'colors', 'Inner Page Pagination Background Hover & Active Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborderactive_color', 'colors', 'Inner Page Pagination Border Hover & Active Color', '#d3ad64');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettnavbackttoarrdisplay', 'colors', 'Color Setting For Navigation Back to top arrow:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbgcolor', 'colors', 'Site Navigation Arrow Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbghvrcolor', 'colors', 'Site Navigation Arrow Hover Color', '#3e454b');


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Title Color', '#fff');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Current Title Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Current Title Hover Color', '#d3ad64');
// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Blog Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'allblog_heading2label', 'luzuk_blogpage_settings', 'Post Heading Font Size Setting:');

$wp_customize->add_setting(
    'blogpages_innerpageheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '23px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogpages_innerpageheading2',
    array(
        'settings'      => 'blogpages_innerpageheading2',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Post Heading Font Size', 'luzuk-premium' )
    )
);




lzCustomLable($wp_customize, 'allblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Date & Admin Display Setting:');

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date & Admin', 'hide' => 'Hide Post Date & Admin', ), ) ); 

// end to show & hide button


lzCustomLable($wp_customize, 'singleblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Social Icons Display Setting:');


//for POSTPAGEsocialsshare to show & hide button

$wp_customize->add_setting( 'postsocialsshare_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postsocialsshare_button_display', array( 'label' => 'Post social Icons Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postsocialsshare_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Social Icons', 'hide' => 'Hide Social Icons', ), ) ); 

// end to show & hide button

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogimgoverlaycolor1', 'luzuk_blogpage_settings', 'Blog Page Image Hover Overlay Color One', '#3e454b');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogimgoverlaycolor2', 'luzuk_blogpage_settings', 'Blog Page Image Hover Overlay Color Two', '#d3ad64');

//addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconcolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Color', '#000');

//addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconbgcolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Background Color', '#fff');

//addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconhovercolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Hover Color', '#fff');

//addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconbghovercolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Background Hover Color', '#000');


addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogcontainbgclr', 'luzuk_blogpage_settings', 'Blog Page Contain Box Background Color', '#fff'); 

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogdateathorclr', 'luzuk_blogpage_settings', 'Blog Page Author & Date & Comment Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogdateathoricnclr', 'luzuk_blogpage_settings', 'Blog Page Author & Date & Comment Icon Color', '#000');

//Blog page title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogtitlecolor', 'luzuk_blogpage_settings', 'Blog Page Title Color', '#3d3d3d');
//Blog page title hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogtitlehovercolor', 'luzuk_blogpage_settings', 'Blog Page Title Hover Color', '#d3ad64');

//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialcolor', 'luzuk_blogpage_settings', 'Blog Page Social Color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbgcolor', 'luzuk_blogpage_settings', 'Blog Page Social Background Color', '#d3ad64');
//Blog page social hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialhovercolor', 'luzuk_blogpage_settings', 'Blog Page Social Hover Color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbghovercolor', 'luzuk_blogpage_settings', 'Blog Page Social Background Hover Color', '#000');

lzCustomLable($wp_customize, 'singleblog_button', 'luzuk_blogpage_settings', 'Blog Button Display Setting:');

$wp_customize->add_setting(
    'blog_button1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'READ MORE', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'blog_button1',
    array(
        'settings'      => 'blog_button1',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Add Button Text Here', 'Luzuk' )
    )
);


addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbtvtxtclr', 'luzuk_blogpage_settings', 'Blog Page Button Text Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbtvtxthvclr', 'luzuk_blogpage_settings', 'Blog Page Button Text Hover Color', '#000');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbtvbgclr', 'luzuk_blogpage_settings', 'Blog Page Button Background Color', '#000');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbtvbghvclr', 'luzuk_blogpage_settings', 'Blog Page Button Background Hover Color', '#d5ab63');


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#33393f', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Set Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text:');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '© 2021 Interrio, All Rights Reserved by kitchen', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'textarea',
        'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
    )
);


addColorPalatOption($wp_customize, 'footerarea_copyright_color', 'footer_area', 'Footer Copyright Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_tpbrd_color', 'footer_area', 'Footer Top Border Color', '#d5ab63');

addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Footer Title Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Footer Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_hglightsctext_color', 'footer_area', 'Footer Hightlight Text Color', '#d5ab63');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Footer Social Icon Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_siconhover_color', 'footer_area', 'Footer Social Icon Hover Color', '#d5ab63');

addColorPalatOption($wp_customize, 'footerarea_siconbrd', 'footer_area', 'Footer Social Icon Border Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_siconbrdhv', 'footer_area', 'Footer Social Icon Border Hover Color', '#d5ab63');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Footer Menu Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Footer Menu Hover Color', '#d5ab63');

addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Active Menu Color', '#d5ab63');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_tableborder_color', 'footer_area', 'Border Color', '#555555');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerareabutton_bg_color', 'footer_area', 'Button Background Color', '#d5ab63');

addColorPalatOption($wp_customize, 'footerareabutton_bghover_color', 'footer_area', 'Button Background Hover Color', '#000');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'productpages_productheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'productpages_productheading2',
    array(
        'settings'      => 'productpages_productheading2',
        'section'       => 'luzuk_shopsidebar_settings',
        'type'          => 'text',
        'label'         => __( 'Product Heading Font Size', 'luzuk-premium' )
    )
);


$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_servicepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:'); 


lzCustomLable($wp_customize, 'luzuk_servicepagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Services page images of equal height.');


//addColorPalatOption($wp_customize, 'servicearea_Innerimghoverbg_color_one', 'luzuk_innerpageshortcode_page_settings', 'Services Image Hover Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTextColor', 'luzuk_innerpageshortcode_page_settings', 'Services Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceicnColor', 'luzuk_innerpageshortcode_page_settings', 'Service Icon Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceicnbgColor', 'luzuk_innerpageshortcode_page_settings', 'Service Icon Background Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceicnbghvColor', 'luzuk_innerpageshortcode_page_settings', 'Service Icon Border Color', '#d3ad648c');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTitleColor', 'luzuk_innerpageshortcode_page_settings', 'Service Title Color', '#131313');

addColorPalatOption($wp_customize, 'InnerSerTitlehvColor', 'luzuk_innerpageshortcode_page_settings', 'Service Title Hover Color', '#d3ad64');

addColorPalatOption($wp_customize, 'InnerSerTxtClr', 'luzuk_innerpageshortcode_page_settings', 'Service Text Color', '#858585');

//addColorPalatOption($wp_customize, 'InnerSer_cirClr', 'luzuk_innerpageshortcode_page_settings', 'Service Circle Color', '#d5ab63');

$wp_customize->add_setting(
    'ser_button',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'READ MORE', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'ser_button',
    array(
        'settings'      => 'ser_button',
        'section'       => 'luzuk_innerpageshortcode_page_settings',
        'type'          => 'text',
        'label'         => __( 'Add Button Text Here', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'InnerSer_btntxtClr', 'luzuk_innerpageshortcode_page_settings', 'Service Button Text Color', '#fff');
addColorPalatOption($wp_customize, 'InnerSer_btntxthvClr', 'luzuk_innerpageshortcode_page_settings', 'Service Button Text Hover Color', '#000');
addColorPalatOption($wp_customize, 'InnerSer_btntbgClr', 'luzuk_innerpageshortcode_page_settings', 'Service Button Background Color', '#000');
addColorPalatOption($wp_customize, 'InnerSer_btntbghvClr', 'luzuk_innerpageshortcode_page_settings', 'Service Button Background Color', '#d5ab63');


lzCustomLable($wp_customize, 'luzuk_projectpageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Project Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_projectpagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Project images of equal height.');

$wp_customize->add_setting('project_link',   array('default'=> 'Add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('project_link',
    array(
        'settings'      => 'project_link',
        'section'       => 'luzuk_innerpageshortcode_page_settings',
        'type'          => 'url',
        'label'         => __( 'Project Frist Button Add Link Here :', 'Luzuk' )
    )
); 
addColorPalatOption($wp_customize, 'pages_InnerprojectfrsticnbgClr', 'luzuk_innerpageshortcode_page_settings', 'project Frist Icon Background Color', '#000');

addColorPalatOption($wp_customize, 'pages_InnerprojectfrsticnClr', 'luzuk_innerpageshortcode_page_settings', 'project Frist Icon Color', '#fff');

addColorPalatOption($wp_customize, 'pages_InnerprojectscondicnbgClr', 'luzuk_innerpageshortcode_page_settings', 'project Second Icon Background Color', '#fff');

addColorPalatOption($wp_customize, 'pages_InnerprojectscondicnClr', 'luzuk_innerpageshortcode_page_settings', 'project Second Icon Background Color', '#000');

addColorPalatOption($wp_customize, 'pages_InnerprojecticnhvClr', 'luzuk_innerpageshortcode_page_settings', 'project Icon Background Hover Color', '#d5ab63');

addColorPalatOption($wp_customize, 'pages_InnerprojectimgbrdClr', 'luzuk_innerpageshortcode_page_settings', 'project Image Border Color', '#d5ab63');

addColorPalatOption($wp_customize, 'pages_InnerprojectoboxtitleClr', 'luzuk_innerpageshortcode_page_settings', 'project Box Title Color', '#fff');

addColorPalatOption($wp_customize, 'pages_InnerprojectoboxtitlehvClr', 'luzuk_innerpageshortcode_page_settings', 'project Box Title Hover Color', '#d5ab63');



lzCustomLable($wp_customize, 'luzuk_teaminnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_teampagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set team member images of equal height.');

addColorPalatOption($wp_customize, 'pages_InnerTeambrdColor', 'luzuk_innerpageshortcode_page_settings', 'Team Box Border Color', '#d5ab63');

addColorPalatOption($wp_customize, 'pages_InnerTeamNameCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Member Name Color', '#131313');

//addColorPalatOption($wp_customize, 'pages_InnerTeamNamehoverCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Member Name Hover Color', '#d5ab63');

addColorPalatOption($wp_customize, 'pages_InnerTeamDesignationCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Designation Color', '#d5ab63');

addColorPalatOption($wp_customize, 'pages_InnerTeamsocialsbxClr', 'luzuk_innerpageshortcode_page_settings', 'Socials Icon Background Color', '#d5ab63');

addColorPalatOption($wp_customize, 'pages_InnerTeamsocialsColor', 'luzuk_innerpageshortcode_page_settings', 'Socials Color', '#fff');

addColorPalatOption($wp_customize, 'pages_TeamsocialshvrsColor', 'luzuk_innerpageshortcode_page_settings', 'Socials Hover Color', '#000');

addColorPalatOption($wp_customize, 'Innerteamarea_Highlightbox_color_one', 'luzuk_innerpageshortcode_page_settings', 'Team Box Background Color', '#fff');

//addColorPalatOption($wp_customize, 'Innerteamarea_Highlightboxbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Team Box Border Color', '#d5ab63');


lzCustomLable($wp_customize, 'luzuk_testimonialinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_bxbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Select Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_imgbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Select Box Border Color', '#d5ab63');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_textcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Content Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_icncolor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Icon Color', '#d5ab63');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_Namecolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Color', '#d5ab63');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_postioncolor', 'luzuk_innerpageshortcode_page_settings', 'Select Box Designation Color', '#444'); 




lzCustomLable($wp_customize, 'luzuk_gallinnoaheclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'luzuk_gallinnimghvbrdClr', 'luzuk_innerpageshortcode_page_settings', 'Select Image Border Color', '#3e454b');

addColorPalatOption($wp_customize, 'luzuk_gallinnimgbrdClr', 'luzuk_innerpageshortcode_page_settings', 'Select Image Border Hover Color', '#d3ad64');


lzCustomLable($wp_customize, 'luzuk_faqinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

$wp_customize->add_setting(
    'the_tpsubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'FAQ', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'the_tpsubtitle',
    array(
        'settings'      => 'the_tpsubtitle',
        'section'       => 'luzuk_innerpageshortcode_page_settings',
        'type'          => 'text',
        'label'         => __( 'Faq Sub Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_faqinnersubheadclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Sub Heading Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_faqinnersubheadbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Sub Heading Boreder Color', '#d3ad64');

$wp_customize->add_setting(
    'the_tptitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'FREQUENTLY ASKED QUESTIONS', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'the_tptitle',
    array(
        'settings'      => 'the_tptitle',
        'section'       => 'luzuk_innerpageshortcode_page_settings',
        'type'          => 'text',
        'label'         => __( 'Faq Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_faqinnerheadclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Heading Color', '#000');

 addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Icon Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Text Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select Question Box Background Color', '#f4f4f4');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextcColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Text Color', '#444');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg1Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color One', '#fff');
addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg2Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color Two', '#fff');

lzCustomLable($wp_customize, 'faq_lhsimg', 'luzuk_innerpageshortcode_page_settings', 'Left Side Box Image');

$wp_customize->add_setting(
    'faq_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'faq_image',
        array(
            'section' => 'luzuk_innerpageshortcode_page_settings',
            'settings' => 'faq_image',
            'description' => __('Recommended Image Size: 300X400px', 'luzuk-premium')
        )
    )
);
addColorPalatOption($wp_customize, 'luzuk_faqinnerimgbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Image Border Color', '#d3ad64');

$wp_customize->add_setting(
    'the_bmsubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'TELL US NOW', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'the_bmsubtitle',
    array(
        'settings'      => 'the_bmsubtitle',
        'section'       => 'luzuk_innerpageshortcode_page_settings',
        'type'          => 'text',
        'label'         => __( 'Faq Form Sub Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_faqinnerformsubheadclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Sub Title Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_faqinnerformsubheadbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Sub Title Border Color', '#d3ad64');

$wp_customize->add_setting(
    'the_bmtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'IF YOU HAVE ANY QUESTION IN YOUR MIND', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'the_bmtitle',
    array(
        'settings'      => 'the_bmtitle',
        'section'       => 'luzuk_innerpageshortcode_page_settings',
        'type'          => 'text',
        'label'         => __( 'Faq Form Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_faqinnerformtitleclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Title  Color', '#000');


lzAddElement($wp_customize, 'luzuk_faq_shortcode', 'luzuk_innerpageshortcode_page_settings', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');


addColorPalatOption($wp_customize, 'luzuk_faqinnerformbgclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Background Color', '#f4f4f4');

addColorPalatOption($wp_customize, 'luzuk_faqinnerformlableclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Label Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_faqinnerformtxtplaceholderclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Text & Placeholder Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_faqinnerformbtnbgclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Button Background Color', '#d3ad64');

addColorPalatOption($wp_customize, 'luzuk_faqinnerformbtnbghvclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Button Background Hover Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_faqinnerformbtntextclr', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Form Button Text Color', '#fff');

$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpage_titlepaddset', 'luzuk_innerpagefont_settings', ' Set Header Title Box Padding:');


$wp_customize->add_setting(
    'inner_headertitleboxTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxTpadding',
    array(
        'settings'      => 'inner_headertitleboxTpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'inner_headertitleboxBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxBpadding',
    array(
        'settings'      => 'inner_headertitleboxBpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'luzuk_innerpageh1_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '35px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);


lzCustomLable($wp_customize, 'luzuk_innerpageh2_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);
 

lzCustomLable($wp_customize, 'luzuk_innerpageh3_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh4_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh5_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '17px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh6_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '16px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);