<?php
$wp_customize->add_section(
    'aboutus_section',
    array(
        'title' => __( 'About Us Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'aboutus_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'aboutus_section_disable',
        array(
            'settings'      => 'aboutus_section_disable',
            'section'       => 'aboutus_section',
            'label'         => __( 'Disable/ Enable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);


backgroundManager($wp_customize, 'aboutileft', 'aboutus_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutus_sectionpadding', 'aboutus_section', 'Padding For Section:');

$wp_customize->add_setting(
    'abtsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'abtsection_toppadding',
    array(
        'settings'      => 'abtsection_toppadding',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'abtsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'abtsection_bottompadding',
    array(
        'settings'      => 'abtsection_bottompadding',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'about_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_subtitle',
        array(
            'settings'      => 'about_subtitle',
            'section'       => 'aboutus_section',
            'label'         => __( 'About Heading & Sub Heading ', 'Luzuk' ),
        )
    )
);   

$wp_customize->add_setting(
    'about_subtitle1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'ABOUT US', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_subtitle1',
    array(
        'settings'      => 'about_subtitle1',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'about_subheadingClr', 'aboutus_section', 'Section Sub Heading Color', '#3d444a'); 

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Kitchen Interior Designs.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'aboutus_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Heading ', 'Luzuk' )
    )
);


addColorPalatOption($wp_customize, 'about_headingClr', 'aboutus_section', 'Section Heading Color', '#3e454b'); 
addColorPalatOption($wp_customize, 'about_headingbrdClr', 'aboutus_section', 'Section Heading Border Color', '#d4ad62'); 

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('We provide a comprehensive cabinetry design & installation service for  your perfect space.', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings' =>'about_text',
        'section' => 'aboutus_section',
        'type'=> 'textarea',
        'label'=> __('Content for the section', 'Luzuk')
    )
);

$wp_customize->add_setting(
    'about_extatext',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('Our design professionals are equipped to help you determine the  products  and design.', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_extatext',
    array(
        'settings' =>'about_extatext',
        'section' => 'aboutus_section',
        'type'=> 'textarea',
        'label'=> __('Extra Content for the section', 'Luzuk')
    )
);
addColorPalatOption($wp_customize, 'aboutReservation_alltxtColor', 'aboutus_section', 'Section Content Color', '#3e454b'); 

lzCustomLable($wp_customize, 'buttontexts', 'aboutus_section', 'Button Text, Button Link & Its Colors:');

// button
$wp_customize->add_setting( 'about_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_button_display', array( 'label' => 'About Button Display', 'section' => 'aboutus_section', 'settings' => 'about_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'about_button1',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'ABOUT US', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'about_button1',
        array(
            'settings'      => 'about_button1',
            'section'       => 'aboutus_section',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );
$wp_customize->add_setting('about_link',   array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('about_link',
    array(
        'settings'      => 'about_link',
        'section'       => 'aboutus_section',
        'type'          => 'url',
        'label'         => __( 'Add Link For Button:', 'Luzuk' )
    )
);  

addColorPalatOption($wp_customize, 'abt_btnbgclr', 'aboutus_section', 'Button Background Color', '#d4ac64'); 

addColorPalatOption($wp_customize, 'abt_btnbghvclr', 'aboutus_section', 'Button Background Hover Color', '#3e454b'); 

addColorPalatOption($wp_customize, 'abt_btntxtclr', 'aboutus_section', 'Button Text Color', '#fff'); 

addColorPalatOption($wp_customize, 'abt_btntxthvclr', 'aboutus_section', 'Button Text Hover Color', '#d4ac64'); 

lzCustomLable($wp_customize, 'about_rhsimg', 'aboutus_section', 'Right Side Box Image');

$wp_customize->add_setting(
    'smash_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'smash_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'smash_image',
            'description' => __('Recommended Image Size: 500X460px', 'luzuk-premium')
        )
    )
);


$wp_customize->add_setting(
    'about_num',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('100%', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_num',
    array(
        'settings' =>'about_num',
        'section' => 'aboutus_section',
        'type'=> 'text',
        'label'=> __('Image Box Number', 'Luzuk')
    )
);

addColorPalatOption($wp_customize, 'abt_imgbxnumclr', 'aboutus_section', 'Image Box Number Color', '#fff'); 

$wp_customize->add_setting(
    'about_sboxt1',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('GUARRENTED', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_sboxt1',
    array(
        'settings' =>'about_sboxt1',
        'section' => 'aboutus_section',
        'type'=> 'text',
        'label'=> __('Small Box Highlight Text', 'Luzuk')
    )
);

addColorPalatOption($wp_customize, 'abt_imgbxhgtxtclr', 'aboutus_section', 'Image Box Highlight Text Color', '#d4ac64'); 


$wp_customize->add_setting(
    'about_sboxt2',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('WORK', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_sboxt2',
    array(
        'settings' =>'about_sboxt2',
        'section' => 'aboutus_section',
        'type'=> 'text',
        'label'=> __('Image Box Text', 'Luzuk')
    )
);

addColorPalatOption($wp_customize, 'abt_imgbxtxtclr', 'aboutus_section', 'Image Box Text Color', '#fff');

addColorPalatOption($wp_customize, 'abt_imgbgclr', 'aboutus_section', 'Image Small Box Background Color', '#100e1b');

addColorPalatOption($wp_customize, 'abt_imgbrdclr', 'aboutus_section', 'Image Small Box Border Color', '#d4ac64');