<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'Luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/serbg.jpg', 'color');

lzCustomLable($wp_customize, 'service_Overlay', 'service_area', 'Section Overlay:');

$wp_customize->add_setting(
    'ser_Opacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.8', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_Opacity',
    array(
        'settings'      => 'ser_Opacity',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'ser_olyclr', 'service_area', 'Section Overlay Color ', '#3d454b');

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);



$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading & Sub Heading', 'Luzuk' ),
        )
    )
);
$wp_customize->add_setting(
    'services_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'What WE Do?', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_subtitle',
    array(
        'settings'      => 'services_subtitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_secsubtitle_color', 'service_area', 'Section Sub Heading Color ', '#fff');

$wp_customize->add_setting(
    'services_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Services We Do', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle',
    array(
        'settings'      => 'services_maintitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_sectitle_color', 'service_area', 'Section Heading Color ', '#fff');
addColorPalatOption($wp_customize, 'servicearea_sectitlebrdclr', 'service_area', 'Section Border Heading Color ', '#d5ab63');

$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note:', 'Luzuk' ),  
            'description'   => __( '{a} Use Shortcode [SERVICES] to show all services in a page.
             {b} Image use same height(250px*270px)', 'Luzuk' ),
        )
    )
);

$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number of Services to show', 'Luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$ServicesSingleChoice[] = 'Select';
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service Page ', 'Luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select a Service Page ', 'Luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-language',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'Luzuk' ),
//             )
//         )
//     );

    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'Luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'Luzuk' ),
                )
            )
        );
    }
 
}

lzCustomLable($wp_customize, 'services_bxclr', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'services_Simghvclr', 'service_area', 'Section Image Hover Color ', '#d4ac64');

addColorPalatOption($wp_customize, 'services_Sbrdclr', 'service_area', 'Section Border Color ', '#fff');

addColorPalatOption($wp_customize, 'services_Sbxclr', 'service_area', 'Section Contain Box Color ', '#3e454b');

addColorPalatOption($wp_customize, 'services_ServicePageTitleColor', 'service_area', 'Section Title Color ', '#fff');

addColorPalatOption($wp_customize, 'services_ServicePageTitlehvColor', 'service_area', 'Section Title Hover Color ', '#d4ac64');

addColorPalatOption($wp_customize, 'service_txtClr', 'service_area', 'Section Text Color ', '#fff');


lzCustomLable($wp_customize, 'service_slidebtn', 'service_area', 'Section Slider Button Color');

addColorPalatOption($wp_customize, 'ser_slibgclr', 'service_area', 'Slider Button Background Color ', '#fff');

addColorPalatOption($wp_customize, 'ser_slibghvclr', 'service_area', 'Slider Button Background Hover Color ', '#d4ac64');

addColorPalatOption($wp_customize, 'ser_slibgarowclr', 'service_area', 'Slider Button Arrow Color ', '#000');

addColorPalatOption($wp_customize, 'ser_slibgarowhvclr', 'service_area', 'Slider Button Arrow Hover Color ', '#fff');