<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />

	<link rel="preconnect" href="https://fonts.gstatic.com">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>

	<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.image-popup.js"></script>
	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header mo-left header-seo">
			<div class="clearfix">
				<div class="top-bar-head">
					<?php 
						$headerinquirytitle = get_theme_mod('headermain_btntitle', 'Donate'); 
						$headerinquiry = get_theme_mod('header_btnlink', '#');
					?>
					<div class="row row-eq-height">
						<div class="container head-inn pd-0">
							<div class="logo col-xl-3 col-md-3 col-sm-3 col-xs-12">
									<div class="inside-full-height">
								<?php 
								
									if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
										$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
									}
									if( get_theme_mod('pages_logoTpadding',true) ) {
										$pages_logoTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTpadding')).';';
									}
									if( get_theme_mod('pages_logoBpadding',true) ) {
										$pages_logoBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBpadding')).';';
									}
									if( get_theme_mod('pages_logoLpadding',true) ) {
										$pages_logoLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLpadding')).';';
									}
									if( get_theme_mod('pages_logoRpadding',true) ) {
										$pages_logoRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRpadding')).';';
									}

								?>
									<!-- website logo -->
										<div class="logo-header mostion">
											<?php 
											if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
												the_custom_logo();
										else : 
											if ( is_front_page() ) : ?>
												<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
												<?php else : ?>
													<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
												<?php endif; ?>
											<?php endif; ?>
										</div> 
										<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>  
									<!-- nav toggle button -->
										<div class="resp_header_logo">
											<?php 
											if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
												the_custom_logo();
										else : 
											if ( is_front_page() ) : ?>
												<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
												<?php else : ?>
													<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
												<?php endif; ?>
												<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
											<?php endif; ?>
										</div>
									</div>
								</div>
							<div class="col-xl-9 col-md-9 col-sm-9 pd-0 HeaderRbx">
							 	<div class="col-xl-10 col-md-10 col-sm-9">
								<?php 	
									$Regtxt = get_theme_mod('Regtxt', 'Reg No : ');
									$Regno = get_theme_mod('Regno_no', '255-58888');
								?>
									<div class="Reg">
										<?php if($Regno || $Regtxt){ ?>
											<?php echo $Regtxt ;?><span><?php echo $Regno ;?></span>
										<?php } ?>
									</div>
								</div>		
								<div class="headerbtn col-xl-2 col-md-2 col-sm-3 pd-0">
								<?php if( get_theme_mod('cds_button_display','show' ) == 'show') :
									?>
									<div class="header-btn">
										
								<?php if(!empty($headerinquiry)){ ?>
									<div class='head-button '>
										<div class="eff-8"></div>
										<a href="<?php echo $headerinquiry ?>"><?php echo ($headerinquirytitle);  ?>
											
										</a>
									</div>
								<?php }?> 
									</div>
								<?php endif ?>
								</div>
											
							  	<div class="clearfix"></div>
							  	<div class="col-xl-12 col-md-12 pd-0">
									<div class="header-right">
										<!-- <div class="hd-b-area "></div> -->
										<div class="row ">
											<!-- <div class="inner-nav-clip pd-0"> -->
											<div class="head-menu col-xl-10 col-lg-10 col-md-9 col-sm-11">
												<div class="inside-full-height">
													<div class="site-navigation ">
								                        <div class="hamburger-menus">
								                            <span></span>
								                            <span></span>
								                            <span></span>
								                            <span></span>
								                            <span></span>
								                            <span></span>
								                            <span></span>
								                            <span></span>
								                            <span></span>
								                        </div>
								                        <nav class="navigation">
						                            		<div class="overlaybg"></div><!--  /.overlaybg -->
						                            <!-- Main Menu -->
								                            <div class="menu-wrapper">
								                                <div class="menu-content">
								                                    <?php
								                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
								                                            wp_nav_menu ( array(
								                                                'menu_class' => 'mainmenu ht-clearfix',
								                                                'container'=> 'ul',
								                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
								                                                'theme_location' => 'primary',  
								                                            )); 
								                                        } else {
								                                            wp_nav_menu ( array(
								                                                'menu_class' => 'mainmenu ht-clearfix',
								                                                'container'=> 'ul',
								                                                'theme_location' => 'primary',  
								                                            )); 
								                                        }
								                                    ?>
								                                </div> <!-- /.hours-content-->
																<div class="clearfix"></div>
								                            </div><!-- /.menu-wrapper --> 
											               <?php 
																$facebook = get_theme_mod('header_fb', '//facebook.com/');
																$twitter = get_theme_mod('header_tw', '//twitter.com/');
																$instagram = get_theme_mod('header_insta', 'https://www.instagram.com/');
															?> 
														 	 <div class="mobnone">
																<div class="share-btn">
														<ul>
															<?php if(!empty($facebook)){ ?>
																<li><a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a></li>
															<?php }?>

															<?php if(!empty($twitter)){ ?>
																<li><a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa fa-twitter"></i></a></li>
															<?php }?>
															<?php if(!empty($instagram)){ ?>
																<li><a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
															<?php }?>
															
															<div class="clearfix"></div>
														</ul>
													</div>
															</div> 
						                        		</nav>
													 	<div class="clearfix"></div>
													</div><!--  /.site-navigation -->
												</div>
											</div>
											<div class="col-xl-2 col-lg-2 col-md-3 col-xs-12 pd-0">
											<?php 	
												$facebook = get_theme_mod('header_fb', '//facebook.com/');
												$twitter = get_theme_mod('header_tw', '//twitter.com/');
												$instagram = get_theme_mod('header_insta', 'https://www.instagram.com/');
												//$youtube = get_theme_mod('header_you', '//youtube.com/');
											?>
											<div class="header-share"> 
													<div class="share-btn">
														<ul>
															<?php if(!empty($facebook)){ ?>
																<li><a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a></li>
															<?php }?>

															<?php if(!empty($twitter)){ ?>
																<li><a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa fa-twitter"></i></a></li>
															<?php }?>
															<?php if(!empty($instagram)){ ?>
																<li><a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
															<?php }?>
															
															<div class="clearfix"></div>
														</ul>
													</div>
													<div class="clearfix"></div>
												</div>
											</div>
											<div class="clearfix"></div>
										</div>
										<div class="clearfix"></div>
									</div>
								</div>
							</div>
						<div class="clearfix"></div>
					</div>
				</div>
				</div>
			</div>			
			<div class="clearfix"></div>
		</header>
	</div>
