<?php
$wp_customize->add_section(
    'aboutus_section',
    array(
        'title' => __( 'About Us Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'aboutus_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'aboutus_section_disable',
        array(
            'settings'      => 'aboutus_section_disable',
            'section'       => 'aboutus_section',
            'label'         => __( 'Disable/ Enable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'about', 'aboutus_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'sec_aboutpadding', 'aboutus_section', 'Section Padding');

$wp_customize->add_setting(
    'aboutTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '10em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutTpadding',
    array(
        'settings'      => 'aboutTpadding',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'aboutBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '10em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'aboutBpadding',
    array(
        'settings'      => 'aboutBpadding',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'Luzuk' )
    )
);
 //airoplane Image
lzCustomLable($wp_customize, 'airo_btn', 'aboutus_section', 'Airoplane Image Setting');

$wp_customize->add_setting( 'airoplane_image_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'airoplane_image_display', array( 'label' => 'Section Airoplane Image Display', 'section' => 'aboutus_section', 'settings' => 'airoplane_image_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
    'airoplane_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'airoplane_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'airoplane_image',
            'description' => __('Recommended Image Size: 530X250px', 'luzuk-premium')
        )
    )
);

 //award Image
$wp_customize->add_setting(
        'abtdot_image_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'abtdot_image_heading',
        array(
            'settings'      => 'abtdot_image_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'About Section Best Award Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'abtdot_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'abtdot_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'abtdot_image',
            'description' => __('Recommended Image Size: 125X125px', 'luzuk-premium')
        )
    )
);

// Main Image

$wp_customize->add_setting(
        'abt_image_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'abt_image_heading',
        array(
            'settings'      => 'abt_image_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'About Section Main Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'abt_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'abt_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'abt_image',
            'description' => __('Recommended Image Size: 400X500px', 'luzuk-premium')
        )
    )
);

addColorPalatOption($wp_customize, 'abou_minimgbrdclr', 'aboutus_section', 'Section Main Image Border Color', '#62cdb9'); 
addColorPalatOption($wp_customize, 'abou_minimgbrdhvclr', 'aboutus_section', 'Section Main Image Border Hover Color', '#62cdb9'); 

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'About Heading & Sub Heading', 'Luzuk' ),
        )
    )
);   

$wp_customize->add_setting(
    'about_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_subtitle',
    array(
        'settings'      => 'about_subtitle',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading ', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'abou_subheadclr', 'aboutus_section', 'Section Sub Heading Color', '#62cdb9'); 
addColorPalatOption($wp_customize, 'abou_subheadbrdclr', 'aboutus_section', 'Section Sub Heading Border Color', '#62cdb9'); 


$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'ABOUT US', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Heading ', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'about_headingClr', 'aboutus_section', 'Section Heading Color', '#444'); 

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('Lorem ipsum dolor sit amet, consectetur adipiscing elit is, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida.', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings' =>'about_text',
        'section' => 'aboutus_section',
        'type'=> 'textarea',
        'label'=> __('Content for the section', 'Luzuk')
    )
);

addColorPalatOption($wp_customize, 'aboutReservation_alltxtColor', 'aboutus_section', 'Section Text Color', '#858585'); 

$wp_customize->add_setting(
    'about_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our mission & vision', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_title2',
    array(
        'settings'      => 'about_title2',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Title ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'about_alltitleClr', 'aboutus_section', 'Section Title Color', '#62cdb9');

$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'Number Of About List', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'aboutus_section',
        'type'          => 'select',
        'label'         => __( 'Number of About List to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 4; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'aboutus_section',
                'label'         => __( 'About List ', 'luzuk-premium' ).$i
            )
        )
    );

    //  $wp_customize->add_setting(
    //     'aboutus_page_icon'.$i,
    //     array(
    //         'default'           => 'fa fa-arrow-right',
    //         'sanitize_callback' => 'luzuk_sanitize_text'
    //     )
    // );        
    // $wp_customize->add_control(
    //     new luzuk_Fontawesome_Icon_Chooser(
    //         $wp_customize,
    //         'aboutus_page_icon'.$i,
    //         array(
    //             'settings'      => 'aboutus_page_icon'.$i,
    //             'section'       => 'aboutus_section',
    //             'type'          => 'icon',
    //             'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
    //         )
    //     )
    // );

    lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'aboutus_section', $type = 'textarea', $label="Icon Text", $callback ='luzuk_sanitize_text', $default='Lorem ipsum dolor sit amet, consectetur adipiscing elite.');  
}

lzCustomLable($wp_customize, 'about_color', 'aboutus_section', 'Section Color Setting');

addColorPalatOption($wp_customize, 'about_icnClr', 'aboutus_section', 'Section Icon Color', '#62cdb9'); 
addColorPalatOption($wp_customize, 'about_icntxtColor', 'aboutus_section', 'Section Icon Text Color', '#696969'); 

//certificate image
$wp_customize->add_setting(
        'smash_image_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'smash_image_heading',
        array(
            'settings'      => 'smash_image_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'Section certificate Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'smash_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'smash_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'smash_image',
            'description' => __('Recommended Image Size: 180X240px', 'luzuk-premium')
        )
    )
);