<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'luzuk-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'luzuk-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Set midle header colour
addColorPalatOption($wp_customize, 'headertagline_color', 'title_tagline', 'Tagline Color', '#000');

//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');


$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'luzuk-premium' )
	)
);


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );



//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'header_settings',
			'label'			=> __( 'Sticky Header', 'luzuk-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'luzuk-premium' ),
				'off' => __( 'Disable', 'luzuk-premium' )
			)	
		)
	)
);

$sectionHeader = 'header_settings';


lzCustomLable($wp_customize, 'header_clrlblbgTxt', 'header_settings', 'Set Header Background Colors:');


//Set top header colour
addColorPalatOption($wp_customize, 'topheader_color', 'header_settings', 'Top Header Color', '#292929');

//Set midle header colour
addColorPalatOption($wp_customize, 'midleheader_color', 'header_settings', 'Midle Header Color', '#fff');

//Set nevigation header colour
addColorPalatOption($wp_customize, 'headernav_color', 'header_settings', 'Navigation Header Color', '#171717');

$wp_customize->add_setting(
	'headermain_address',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Anmoore Road Brooklyn, NY 11230', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_address',
	array(
		'settings'      => 'headermain_address',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Address', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'headermain_time',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '8.00am - 10.00pm Mon - Sun', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_time',
	array(
		'settings'      => 'headermain_time',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Time', 'luzuk-premium' )
	)
);

//Set header Contact Address Time icon  colour
addColorPalatOption($wp_customize, 'header_contactaddtimeiconColor', 'header_settings', 'Header Contact Address Time Icon Color', '#a0c716');

//Set header Contact Address Time text colour
addColorPalatOption($wp_customize, 'header_contactaddtimeColor', 'header_settings', 'Header Contact Address Time Text Color', '#fff');

// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');


// FACEBOOK 
$wp_customize->add_setting('header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_fb',
	array(
		'settings'      => 'header_fb',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'negocio-business' )
	)
);
// TWITTER
$wp_customize->add_setting('header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_tw',
	array(
		'settings'      => 'header_tw',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'negocio-business' )
	)
);
// // Instagram
$wp_customize->add_setting('header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_insta',
	array(
		'settings'      => 'header_insta',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Instagram', 'negocio-business' )
	)
); 

// // Pinterest
$wp_customize->add_setting('header_pintrest', array('default' => 'https://in.pinterest.com/', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_pintrest',
	array(
		'settings'      => 'header_pintrest',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Pinterest', 'negocio-business' )
	)
);

// LINKED IN
$wp_customize->add_setting('header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_in',
	array(
		'settings'      => 'header_in',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'negocio-business' )
	)
);

// Youtube
$wp_customize->add_setting('header_youtube',array('default'=> 'https://www.youtube.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_youtube',
	array(
		'settings'      => 'header_youtube',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Youtube Url', 'negocio-business' )
	)
);


//Set header social colour
addColorPalatOption($wp_customize, 'header_socialiconColor', 'header_settings', 'Header Social Color', '#fff');

//Set header social hover colour
addColorPalatOption($wp_customize, 'header_socialiconhoverColor', 'header_settings', 'Header Social Hover Color', '#000');

lzCustomLable($wp_customize, 'header_lblbutton1display', 'header_settings', 'Header Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_button_display', array( 'label' => 'Button Display', 'section' => 'header_settings', 'settings' => 'cds_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
	'headermain_headerbtntitle',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'GET A QUOTE' )
	)
);
$wp_customize->add_control(
	'headermain_headerbtntitle',
	array(
		'settings'      => 'headermain_headerbtntitle',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Header Button Text', 'luzuk-premium' )
	)
);
$wp_customize->add_setting('header_headerbtn',	array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_headerbtn',
	array(
		'settings'      => 'header_headerbtn',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Add "Header Button" link here', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'header_clrlbtnTxt', 'header_settings', 'Set Header Button Colors:');

//Set header button colour
addColorPalatOption($wp_customize, 'headerbtn_color', 'header_settings', 'Header Button Color', '#fff');

//Set header button bg colour
addColorPalatOption($wp_customize, 'headerbtnbg_color', 'header_settings', 'Header Button Background Color', '#8fb310');

//Set header button hover colour
addColorPalatOption($wp_customize, 'headerbtnhover_color', 'header_settings', 'Header Button Hover Color', '#fff');

//Set header button bg hover colour
addColorPalatOption($wp_customize, 'headerbtnbghover_color', 'header_settings', 'Header Button Background Hover Color', '#292929');

//Set header highlight colour
addColorPalatOption($wp_customize, 'header_highlightbgColor', 'header_settings', 'Header Highlight Color', '#a0c716');


$wp_customize->add_setting(
	'headermain_phonelabel',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Call Us Now', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_phonelabel',
	array(
		'settings'      => 'headermain_phonelabel',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Label', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '012 345 6789', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_phone',
	array(
		'settings'      => 'headermain_phone',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'headermain_emaillabel',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Email Us', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_emaillabel',
	array(
		'settings'      => 'headermain_emaillabel',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Label', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'cleaningservices@gmail.com', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'headermain_email',
	array(
		'settings'      => 'headermain_email',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Email', 'luzuk-premium' )
	)
);


lzCustomLable($wp_customize, 'header_clrlblcontactTxt', 'header_settings', 'Set Header Contact Details Colors:');

//Set header contact icon  colour
addColorPalatOption($wp_customize, 'header_iconColor', 'header_settings', 'Header Contact Icon Color', '#a0c716');

//Set header contact icon hover colour
addColorPalatOption($wp_customize, 'header_iconhoverColor', 'header_settings', 'Header Contact Icon Hover Color', '#292929');

//Set header contact label colour
addColorPalatOption($wp_customize, 'header_contactlabelColor', 'header_settings', 'Header Contact Label Color', '#a0c716');

//Set header contact data colour
addColorPalatOption($wp_customize, 'header_contactdataColor', 'header_settings', 'Header Contact Data Color', '#464646');

//Set header contact email hover  colour
addColorPalatOption($wp_customize, 'header_contactemailhoverColor', 'header_settings', 'Header Contact Emali hover Color', '#a0c716');

//Set header contact border colour
addColorPalatOption($wp_customize, 'header_contactborderColor', 'header_settings', 'Header Contact Border Color', '#c0c0c0');

lzCustomLable($wp_customize, 'header_clrlblImgTxt', 'header_settings', 'Set Header Menu Colors:');

//Set header menu colour
addColorPalatOption($wp_customize, 'headermenu_color', 'header_settings', 'Header Menu Color', '#fff');

//Set header current menu colour
addColorPalatOption($wp_customize, 'headercurrentmenu_color', 'header_settings', 'Header Current Menu Color', '#fff');

//Set header current menu bg colour
addColorPalatOption($wp_customize, 'headercurrentmenubg_color', 'header_settings', 'Header Current Menu Background Color', '#a0c716');

//Set header menu hover colour
addColorPalatOption($wp_customize, 'headermenuhover_color', 'header_settings', 'Header Menu Hover Color', '#fff');

//Set header menu bg hover colour
addColorPalatOption($wp_customize, 'headermenuhoverbg_color', 'header_settings', 'Header Menu Hover background Color', '#a0c716');

//Set header sub menu colour
addColorPalatOption($wp_customize, 'headersubmenu_color', 'header_settings', 'Header Sub Menu Color', '#fff');

//Set header dropdown Background colour
addColorPalatOption($wp_customize, 'headerdropdownbg_color', 'header_settings', 'Header dropdown Background Color', '#171717');

//Set header dropdown border colour
addColorPalatOption($wp_customize, 'headerdropdownborder_color', 'header_settings', 'Header dropdown Border Color', '#a0c716');


//Set header sub menu hover colour
addColorPalatOption($wp_customize, 'headersubmenuhover_color', 'header_settings', 'Header Sub Menu Hover Color', '#a0c716');

//Set header sub menu arrow hover colour
addColorPalatOption($wp_customize, 'headersubmenuarrowhover_color', 'header_settings', 'Header Sub Menu Arrow Hover Color', '#a0c716');

//Set header current sub menu colour
addColorPalatOption($wp_customize, 'headercurrentsubmenu_color', 'header_settings', 'Header Current Sub Menu Color', '#fff');

//Set header current sub menu bg colour
addColorPalatOption($wp_customize, 'headercurrentsubmenubg_color', 'header_settings', 'Header Current Sub Menu background Color', '#a0c716');

//responsive header colors

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', 'header_settings', 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_topsubmenuiconColor', 'header_settings', 'Header Menus Dropdown Icon Color', '#a0c716');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#a0c716');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box Background Color', '#171717');
addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Menus Border Color', '#a0c716');


//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'luzuk-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'template_primary_color', 'colors', 'Theme Primary Color', '#a0c716');
//Inner page title color
addColorPalatOption($wp_customize, 'template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#a0c716');
// touggle bar color
addColorPalatOption($wp_customize, 'template_togglebar_color', 'colors', 'Toggle bar color', '#a0c716');

//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#333333');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#333333');

//Inner page content box text color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtextcolor', 'colors', 'Inner page content box text color', '#303030');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#a0c716');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#a0c716');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#404040');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettnavbackttoarrdisplay', 'colors', 'Color Setting For Navigation Back to top arrow:');

addColorPalatOption($wp_customize, 'sitenav_arowcolor', 'colors', 'Site Navigation Arrow Color', '#8fb310');
addColorPalatOption($wp_customize, 'sitenav_arowhvcolor', 'colors', 'Site Navigation Arrow Hover Color', '#858585');


//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'innerheadingfontsize_settings', ' Inner Page Heading Font Size:');


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '26px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);



//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

// end to show & hide button

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'unboxthemes' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'unboxthemes' )
        )
    );


//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#222222');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#a0c716');

//Inner page breadcrumbbox current hover title color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#222222');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');

//Inner page breadcrumbbox border color
addColorPalatOption($wp_customize, 'template_innerpage_breadcrumbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#222222');


//INNER SHORTCODE PAGE COLOR SETTINGS
$wp_customize->add_section(
	'shortcode_page_settings',
	array(
		'title' => __( 'Shortcode Page Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'servicesshortcode', 'shortcode_page_settings', ' Services shortcode Page colors:');


// image border color
addColorPalatOption($wp_customize, 'lz_featuredinnerimgborder_Color', 'shortcode_page_settings', 'Image border color', '#fff');

// image hover btn box color
addColorPalatOption($wp_customize, 'lz_featuredinnerimghoverbtnbox_Color', 'shortcode_page_settings', 'Image overlay button box color', '#a0c716');

// image hover btn color
addColorPalatOption($wp_customize, 'lz_featuredinnerimghoverbtn_Color', 'shortcode_page_settings', 'Image overlay button color', '#fff');

// image hover btn border color
addColorPalatOption($wp_customize, 'lz_featuredinnerimghoverbtnborder_Color', 'shortcode_page_settings', 'Image overlay button border color', '#fff');

// title color
addColorPalatOption($wp_customize, 'lz_featuredinnertitle_Color', 'shortcode_page_settings', 'Title color', '#fff');

// title hover color
addColorPalatOption($wp_customize, 'lz_featuredinnertitlehover_Color', 'shortcode_page_settings', 'Title hover color', '#a0c716');

// text color
addColorPalatOption($wp_customize, 'lz_featuredinnertext_Color', 'shortcode_page_settings', 'Text color', '#fff');

// text hover color
addColorPalatOption($wp_customize, 'lz_featuredinnertexthover_Color', 'shortcode_page_settings', 'Text hover color', '#323232');

//box bg color
addColorPalatOption($wp_customize, 'lz_featuredboxinnerbg_Color', 'shortcode_page_settings', 'Box background color', '#a0c716');

//box bg hover color
addColorPalatOption($wp_customize, 'lz_featuredboxinnerbghover_Color', 'shortcode_page_settings', 'Box background hover color', '#fff');

// border color
addColorPalatOption($wp_customize, 'lz_featuredboxinnerborder_Color', 'shortcode_page_settings', 'Box border color', '#fff');

// border hover  color
addColorPalatOption($wp_customize, 'lz_featuredboxinnerborderhover_Color', 'shortcode_page_settings', 'Box border hover color', '#a0c716');


lzCustomLable($wp_customize, 'galleryshortcode', 'shortcode_page_settings', ' Gallery shortcode Page colors:');

// Img border color
addColorPalatOption($wp_customize, 'galleryinner_borderColor', 'shortcode_page_settings', 'Image border color', '#a0c716');

// Img border hover color
addColorPalatOption($wp_customize, 'galleryinner_borderhoverColor', 'shortcode_page_settings', 'Image border hover color', '#333333');

// Img overlay color
addColorPalatOption($wp_customize, 'galleryinner_imgoverayColor', 'shortcode_page_settings', 'Image overlay color', '#a0c716');

lzCustomLable($wp_customize, 'teamshortcode', 'shortcode_page_settings', ' Team shortcode Page colors:');

$wp_customize->add_setting('teaminner_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'teaminner_section_lbl',
		array(
			'settings'		=> 'teaminner_section_lbl',
			'section'		=> 'shortcode_page_settings',
			'label'			=> __( 'Note:', 'luzuk-premium' ),	
			'description'	=> __( 'Kindly add the same size of the height image. Recommended image height size should be at least 340px .', 'luzuk-premium' ),
		)
	)
);

// title color
addColorPalatOption($wp_customize, 'teaminner_TitleColor', 'shortcode_page_settings', 'Title color', '#fff');


// desg color
addColorPalatOption($wp_customize, 'teaminner_DesColor', 'shortcode_page_settings', 'Designation color', '#a0c716');


// social color
addColorPalatOption($wp_customize, 'teaminner_SocialColor', 'shortcode_page_settings', 'Social color', '#a0c716');

// social box color
addColorPalatOption($wp_customize, 'teaminner_SocialboxColor', 'shortcode_page_settings', 'Social background color', '#fff');

// social hover color
addColorPalatOption($wp_customize, 'teaminner_SocialhoverColor', 'shortcode_page_settings', 'Social hover color', '#fff');

// social box hover color
addColorPalatOption($wp_customize, 'teaminner_SocialboxhoverColor', 'shortcode_page_settings', 'Social background hover color', '#a0c716');

// image hover color
addColorPalatOption($wp_customize, 'teaminner_imghoverColor', 'shortcode_page_settings', 'Image hover color', '#000');


lzCustomLable($wp_customize, 'testimonialsshortcode', 'shortcode_page_settings', ' Testimonial shortcode Page colors:');


// image border hover color
addColorPalatOption($wp_customize, 'testimonialalsinner_imgborderhoverColor', 'shortcode_page_settings', 'Image border hover color', '#a0c716');


// text color
addColorPalatOption($wp_customize, 'testimonialalsinner_TextColor', 'shortcode_page_settings', 'Testimonial color', '#fff');

// title color
addColorPalatOption($wp_customize, 'testimonialalsinner_TitleColor', 'shortcode_page_settings', 'Title color', '#fff');

// title hover color
addColorPalatOption($wp_customize, 'testimonialalsinner_TitlehoverColor', 'shortcode_page_settings', 'Title hover color', '#a0c716');


// desg color
addColorPalatOption($wp_customize, 'testimonialalsinner_desgColor', 'shortcode_page_settings', 'Designation color', '#fff');

// Box border color
addColorPalatOption($wp_customize, 'testimonialalsinner_borderColor', 'shortcode_page_settings', 'Box border color', '#a0c716');

// Box color
addColorPalatOption($wp_customize, 'testimonialalsinner_bgColor', 'shortcode_page_settings', 'Box color', '#292929');


lzCustomLable($wp_customize, 'faqshortcode', 'shortcode_page_settings', ' FAQS shortcode Page colors:');

//Content box bg color
addColorPalatOption($wp_customize, 'faqsinner_contentboxbgColor', 'shortcode_page_settings', 'Content box background color', '#fff');

//Content box border color
addColorPalatOption($wp_customize, 'faqsinner_contentboxborderColor', 'shortcode_page_settings', 'Content box border color', '#292929');

//Content box dark border color
addColorPalatOption($wp_customize, 'faqsinner_contentboxdarkborderColor', 'shortcode_page_settings', 'Content box dark border color', '#a0c716');

//down arrow text color
addColorPalatOption($wp_customize, 'faqsinner_QdownarrowColor', 'shortcode_page_settings', 'Question indicator arrow color', '#fff');

//down arrow bg color
addColorPalatOption($wp_customize, 'faqsinner_QdownarrowbgColor', 'shortcode_page_settings', 'Question indicator arrow background color', '#000');

//down arrow border color
addColorPalatOption($wp_customize, 'faqsinner_QdownarrowborderColor', 'shortcode_page_settings', 'Question indicator arrow border color', '#a0c716');

//ques text color
addColorPalatOption($wp_customize, 'faqsinner_QtextColor', 'shortcode_page_settings', 'Question text color', '#000');

//ans text color
addColorPalatOption($wp_customize, 'faqsinner_AtextColor', 'shortcode_page_settings', 'Answer text color', '#303030');

//ans border color
addColorPalatOption($wp_customize, 'faqsinner_AborderColor', 'shortcode_page_settings', 'Answer border color', '#303030');
  
//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2019 Cleaning Services. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'footer_copyrighttext',
	array(
		'settings'      => 'footer_copyrighttext',
		'section'       => 'footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'footer_copyright_settings', $color='#333333', get_template_directory_uri().'/images/default-gray.png', 'img');


//theme Footer title Color
addColorPalatOption($wp_customize, 'footer_title_color', 'footer_copyright_settings', 'Footer Title Color', '#fff');


//theme Footer title border Color
addColorPalatOption($wp_customize, 'footer_titleborder_color', 'footer_copyright_settings', 'Footer Title Border Color', '#a0c716');


//theme Footer icon Color
addColorPalatOption($wp_customize, 'footer_icon_color', 'footer_copyright_settings', 'Footer Icon Color', '#a0c716');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'footer_iconhover_color', 'footer_copyright_settings', 'Footer Icon Hover Color', '#fff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'footer_text_color', 'footer_copyright_settings', 'Footer Text Color', '#fff');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'footer_menu_color', 'footer_copyright_settings', 'Footer Menu Color', '#fff');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'footer_menuhover_color', 'footer_copyright_settings', 'Footer Menu Hover Color', '#a0c716');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'footer_menudate_color', 'footer_copyright_settings', 'Footer Menu Date Color', '#a0c716');

//theme Footer menu icon Color
addColorPalatOption($wp_customize, 'footer_navicon_color', 'footer_copyright_settings', 'Footer Menu Icon Color', '#fff');

//theme Footer menu icon hover Color
addColorPalatOption($wp_customize, 'footer_menuiconhover_color', 'footer_copyright_settings', 'Footer Menu Icon Hover Color', '#a0c716');


//theme Footer social Color
addColorPalatOption($wp_customize, 'footer_social_color', 'footer_copyright_settings', 'Footer Social Color', '#fff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'footer_socialhover_color', 'footer_copyright_settings', 'Footer Social Hover Color', '#fff');

//theme Footer Social Background hover Color
addColorPalatOption($wp_customize, 'footer_socialbghover_color', 'footer_copyright_settings', 'Footer Social Background hover Color', '#a0c716');


//theme Footer Social border Color
addColorPalatOption($wp_customize, 'footer_socialborder_color', 'footer_copyright_settings', 'Footer  Social Border Color', '#4c3a37');

//theme Footer Social border hover Color
addColorPalatOption($wp_customize, 'footer_socialborderhover_color', 'footer_copyright_settings', 'Footer  Social Border Hover Color', '#a0c716');

//theme Footer form Color
addColorPalatOption($wp_customize, 'footer_form_color', 'footer_copyright_settings', 'Footer Form Color', '#fff');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'footer_formborder_color', 'footer_copyright_settings', 'Footer Form Border Color', '#fff');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'footer_formbtn_color', 'footer_copyright_settings', 'Footer Form Button Color', '#303030');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'footer_formbtnbg_color', 'footer_copyright_settings', 'Footer Form Button Background Color', '#a0c716');

//theme Footer copyright Text Color
addColorPalatOption($wp_customize, 'footer_copyrighttext_color', 'footer_copyright_settings', 'Copyright Footer Text Color', '#fff');


//theme Footer copyright bg Color
addColorPalatOption($wp_customize, 'footer_copyrightbg_color', 'footer_copyright_settings', 'Copyright Footer Background Color', '#232323');

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Postpage Date Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 