<?php
/**
 * Createing an about us pannel for customizer
 */

// START ABOUT SECTION 
    $wp_customize->add_section(
        'premium_aboutus_section',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'lz_fitness_premium_home_panel'
        )
    );
    // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'premium_aboutus_section_disable',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Switch_Control(
            $wp_customize,
            'premium_aboutus_section_disable',
            array(
                'settings'      => 'premium_aboutus_section_disable',
                'section'       => 'premium_aboutus_section',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

    backgroundManager($wp_customize, 'about', 'premium_aboutus_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


$wp_customize->add_setting(
        'about_image_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'about_image_heading',
            array(
                'settings'      => 'about_image_heading',
                'section'       => 'premium_aboutus_section',
                'label'         => __( 'Left Image', 'luzuk-premium' ),
            )
        )
    );

      $wp_customize->add_setting(
        'about_image',
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'about_image',
            array(
                'section' => 'premium_aboutus_section',
                'settings' => 'about_image',
                'description' => __('Recommended Image Size: 500X600px', 'luzuk-premium')
            )
        )
    );

     // image border color
    addColorPalatOption($wp_customize, 'aboutus_page_imgborderColor', 'premium_aboutus_section', 'Image hover border color', '#a0c716');

     // image overlay color
    addColorPalatOption($wp_customize, 'aboutus_page_imgoverlayColor', 'premium_aboutus_section', 'Image overlay color', '#a0c716');

      $wp_customize->add_setting(
        'aboutus_title_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'aboutus_title_heading',
            array(
                'settings'      => 'aboutus_title_heading',
                'section'       => 'premium_aboutus_section',
                'label'         => __( 'ABOUT Title & Text', 'luzuk-premium' ),
            )
        )
    );  

    $wp_customize->add_setting(
        'aboutus_title',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'About Us', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'aboutus_title',
        array(
            'settings'      => 'aboutus_title',
            'section'       => 'premium_aboutus_section',
            'type'          => 'text',
            'label'         => __( 'Title for section', 'luzuk-premium' )
        )
    );

     // Heading color
    addColorPalatOption($wp_customize, 'aboutus_page_HeadingColor', 'premium_aboutus_section', 'Section Heading color', '#303030');

    // Heading border color
    addColorPalatOption($wp_customize, 'aboutus_HeadingborderColor', 'premium_aboutus_section', 'Section Heading border color', '#a0c716');

      $wp_customize->add_setting(
        'aboutus_subtitle',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Clean Home Bringing Excellence in Residential & Commercial cleaning services', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'aboutus_subtitle',
        array(
            'settings'      => 'aboutus_subtitle',
            'section'       => 'premium_aboutus_section',
            'type'          => 'textarea',
            'label'         => __( 'Sub Title', 'luzuk-premium' )
        )
    );

     // Sub title color
    addColorPalatOption($wp_customize, 'aboutus_page_subheadeingColor', 'premium_aboutus_section', 'Sub title color', '#303030');

    $wp_customize->add_setting(
        'aboutus_subText',
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('There are many variations of passages of Lorem Ipsum available, but majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything.', 'luzuk-premium')
        )
    );
    $wp_customize->add_control(
        'aboutus_subText',
        array(
            'settings' =>'aboutus_subText',
            'section' => 'premium_aboutus_section',
            'type'=> 'textarea',
            'label'=> __('Content for the section', 'luzuk-premium')
        )
    );


       // Text color
    addColorPalatOption($wp_customize, 'aboutus_page_TextColor', 'premium_aboutus_section', 'Text color', '#303030');

    // Text highlight color
    addColorPalatOption($wp_customize, 'aboutus_page_TexthighlightColor', 'premium_aboutus_section', 'Text highlight color', '#a0c716');


    $wp_customize->add_setting(
        'aboutus_text',
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('<ul><li>Cleaning Services System.</li> <li>Carpet Cleaning Instrument.</li> <li>Residential Cleaning Service.</li></ul>', 'luzuk-premium')
        )
    );
    $wp_customize->add_control(
        'aboutus_text',
        array(
            'settings' =>'aboutus_text',
            'section' => 'premium_aboutus_section',
            'type'=> 'textarea',
            'label'=> __('List for the section', 'luzuk-premium')
        )
    );


      // Text list icon color
    addColorPalatOption($wp_customize, 'aboutus_page_listiconColor', 'premium_aboutus_section', 'List icon color', '#a0c716');

      // Text list color
    addColorPalatOption($wp_customize, 'aboutus_page_listColor', 'premium_aboutus_section', 'List color', '#303030');


    // END ABOUT SECTION 