<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_section',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'lz_fitness_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_section_disable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'blog_section_disable',
		array(
			'settings'      => 'blog_section_disable',
			'section'       => 'blog_section',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_section', $color='#f7f7f7', get_template_directory_uri().'/images/default-gray.png', 'img');


$wp_customize->add_setting(
	'blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text'
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'blog_title_subtitle_heading',
		array(
			'settings'      => 'blog_title_subtitle_heading',
			'section'       => 'blog_section',
			'label'         => __( 'Section Title', 'luzuk-premium' ),
		)
	)
);

$wp_customize->add_setting(
	'blog_title',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'RECENT BLOGS', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_title',
	array(
		'settings'      => 'blog_title',
		'section'       => 'blog_section',
		'type'          => 'text',
		'label'         => __( 'Title', 'luzuk-premium' )
	)
);


// Heading color
addColorPalatOption($wp_customize, 'blog_HeadingColor', 'blog_section', 'Heading color', '#303030');

 // Heading border color
addColorPalatOption($wp_customize, 'blog_HeadingborderColor', 'blog_section', 'Section Heading border color', '#a0c716');


//BLOG SETTINGS
$wp_customize->add_setting(
	'blog_post_count',
	array(
		'default'           => '3',
		'sanitize_callback' => 'lz_fitness_sanitize_choices'
	)
);
$wp_customize->add_control(
	new lz_fitness_Dropdown_Chooser(
		$wp_customize,
		'blog_post_count',
		array(
			'settings'      => 'blog_post_count',
			'section'       => 'blog_section',
			'label'         => __( 'Number of Posts to show', 'luzuk-premium' ),
			'choices'       => $lz_fitness_post_count_choice
		)
	)
);
$wp_customize->add_setting(
	'blog_cat_exclude',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text'
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Checkbox_Multiple(
		$wp_customize,
		'blog_cat_exclude',
		array(
			'label' => __('Exclude Category from Blog Posts', 'luzuk-premium'),
			'section' => 'blog_section',
			'settings' => 'blog_cat_exclude',
			'choices' => $lz_fitness_cat
		)
	)
);
// END BLOG SECTION FOR HOME PAGE
/****************************/


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
	'premium_blog_section',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'lz_fitness_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_section',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('blog_categories', array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Customize_Checkbox_Multiple(
		$wp_customize,
		'blog_categories',
		array(
			'label' => __('Exclude Category from Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_section',
			'settings' => 'blog_categories',
			'choices' => $cat
		)
	)
);


// image overlay color
addColorPalatOption($wp_customize, 'blog_imghoverColor', 'blog_section', 'Image overlay color', '#fff');

// btn bg color
addColorPalatOption($wp_customize, 'blog_btnbgColor', 'blog_section', 'Button background color', '#a0c716');

// btn icon color
addColorPalatOption($wp_customize, 'blog_btniconColor', 'blog_section', 'Button icon color', '#fff');

// btn bg hover color
addColorPalatOption($wp_customize, 'blog_btnbghoverColor', 'blog_section', 'Button background hover color', '#292929');

// btn icon hover color
addColorPalatOption($wp_customize, 'blog_btniconhoverColor', 'blog_section', 'Button icon hover color', '#fff');

// Title color
addColorPalatOption($wp_customize, 'blog_TitleColor', 'blog_section', 'Title color', '#303030');

// admin text color
addColorPalatOption($wp_customize, 'blog_admintextColor', 'blog_section', 'Admin text color', '#323232');

// admin icon color
addColorPalatOption($wp_customize, 'blog_adminiconColor', 'blog_section', 'Admin icon color', '#a0c716');

// admin border color
addColorPalatOption($wp_customize, 'blog_adminborderColor', 'blog_section', 'Admin border color', '#323232');


// date text color
addColorPalatOption($wp_customize, 'blog_dateColor', 'blog_section', 'Date text color', '#323232');

// Date icon color
addColorPalatOption($wp_customize, 'blog_dateiconColor', 'blog_section', 'Date icon color', '#a0c716');


//Blog box color
addColorPalatOption($wp_customize, 'blog_boxColor', 'blog_section', 'Blog box color', '#fff');

//Blog box overlay color
addColorPalatOption($wp_customize, 'blog_boxoverlayColor', 'blog_section', 'Blog box overlay color', '#a0c716');


//Blog hover border color
addColorPalatOption($wp_customize, 'blog_boxborderhoverColor', 'blog_section', 'Blog hover border color', '#a0c716');