<?php

// START APPOINTMENT SECTION 
$section = 'faq_section';
$wp_customize->add_section(
	$section,
	array(
		'title'   => __( 'FAQ Section', 'luzuk-premium' ),
		'panel'   => 'lz_fitness_premium_home_panel',
	)
);
$wp_customize->add_setting(
    'faq_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'faq_section_disable',
        array(
            'settings'      => 'faq_section_disable',
            'section'       => $section,
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'faq', $section, $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

// Adding the Label
lzCustomLable($wp_customize, $section.'_title_subtitle_heading', $section, 'Section Title');

//add textarea
lzAddElement($wp_customize, $section.'_title', $section, 'text', $label="Title", 'lz_fitness_sanitize_text', 'FAQs');

if(!is_array($faqSingleChoice)){
    $wp_customize->add_setting($section.'_faq_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
    $wp_customize->add_control(
        new lz_fitness_Info_Text( 
            $wp_customize,
            $section.'_faq_section_lbl',
            array(
                'settings'      => $section.'_faq_section_lbl',
                'section'       => $section,
                'label'         => __( 'Note:', 'luzuk-premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the FAQs.</strong> <br/>Please add the FAQs from "FAQs menu" and then select FAQs to show information.', 'luzuk-premium' ),
            )
        )
    );
}
$wp_customize->add_setting($section.'_premium_faq_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Info_Text( 
        $wp_customize,
        $section.'_premium_faq_section_lbl',
        array(
            'settings'      => $section.'_premium_faq_section_lbl',
            'section'       => $section,
            'label'         => __( 'Note:', 'luzuk-premium' ), 
            'description'   => __( 'Just place the shortcode "[FAQS]" in your page to list the FAQs in a page ', 'luzuk-premium' ),
        )
    )
);
//FAQS PAGES
// for( $i = 1; $i < 6; $i++ ){
//     $wp_customize->add_setting(
//         $section.'_faq_heading'.$i,
//         array(
//             'sanitize_callback' => 'lz_fitness_sanitize_text'
//         )
//     );
//     $wp_customize->add_control(
//         new lz_fitness_Customize_Heading(
//             $wp_customize,
//             $section.'_faq_heading'.$i,
//             array(
//                 'settings'      => $section.'_faq_heading'.$i,
//                 'section'       => $section,
//                 'label'         => __( 'Client FAQs ', 'luzuk-premium' ).$i,
//             )
//         )
//     );
//     $wp_customize->add_setting(
//         $section.'_faq_page'.$i,
//         array(
//             'sanitize_callback' => 'absint'
//         )
//     );
//     $wp_customize->add_control(
//         $section.'_faq_page'.$i,
//         array(
//             'settings'      => $section.'_faq_page'.$i,
//             'section'       => $section,
//             'type'=> 'select',
//             'label'         => __( 'Select a Client FAQs', 'luzuk-premium' ),
//             'choices' => $lzFitnessfaqSingleChoice,
//         )
//     );
// }


// // Adding the Label
// lzCustomLable($wp_customize, $section.'_npp_heading', $section, 'Number Of FAQ\'s at home page');

// $limit = array(1,2,3,4,5,6,7,8);
// //add textarea
// lzAddElement($wp_customize, $section.'_npp_count', $section, 'select', $label="Number of FAQ to show", 'lz_fitness_sanitize_text', 2, $limit);

// // Adding the Label
// lzCustomLable($wp_customize, $section.'_page', $section, 'Select the FAQ PAGE');

// 	$wp_customize->add_setting(
//         $section.'_page_link',
//         array(
//             'sanitize_callback' => 'absint',
//             'default'           => 0,
//         )
//     );
//     $wp_customize->add_control(
//         $section.'_page_link',
//         array(
//             'settings'      => $section.'_page_link',
//             'section'       => $section,
//             'type'          => 'dropdown-pages',
//             'label'         => __( 'Select a FAQ', 'luzuk-premium' )
//         )
//     );
// END FAQ SECTION 
// Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_faq_HeadingColor', $section, 'Heading color', '#161616');
// Title color
 addColorPalatOption($wp_customize, 'lz_fitness_faq_TitleColor', $section, 'Title color', '#161616');
// Text color
    addColorPalatOption($wp_customize, 'lz_fitness_faq_TextColor', $section, 'Text color', '#333333');

//FAQS BUTTON
for( $i = 1; $i <= 1; $i++ ){

    $wp_customize->add_setting(
        'lz_fitness_faq_page_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_faq_page_header'.$i,
            array(
                'settings'      => 'lz_fitness_faq_page_header'.$i,
                'section'       => $section,
                'label'         => __( 'Button Details '.$i, 'luzuk-premium' )
            )
        )
    );

     lzAddElement($wp_customize, 'faq_button_url_'.$i, $section, $type = 'text', $label="Button Link".$i."&nbsp;", $callback ='esc_url', $default='Add link here');


    /*code for button text*/
    // $wp_customize->add_setting(
 //        'lz_fitness_project_button'.$i,
 //        array(
 //            'sanitize_callback'=>'lz_fitness_sanitize_text',
 //            'default'=> __('View all Project', 'luzuk-premium')
 //        )
 //    );
 //    $wp_customize->add_control(
 //        'lz_fitness_project_button'.$i,
 //        array(
 //            'settings' =>'lz_fitness_project_button'.$i,
 //            'section' => 'lz_fitness_project_section',
 //            'type'=> 'text',
 //            'label'=> __('Button Text', 'luzuk-premium')
 //        )
 //    );

}