<?php 
/**
 * Customiser section for featured
 **/
// Featured Section
$wp_customize->add_section(
    'services_section',
    array(
        'title'         => __( 'Services Section', 'luzuk-premium' ),
        'panel'   => 'lz_fitness_premium_home_panel',
    )
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
    'services_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'services_section_disable',
        array(
            'settings'      => 'services_section_disable',
            'section'       => 'services_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'featured', 'services_section', $color='#f4f4f4', get_template_directory_uri().'/images/default-gray.png', 'img');


$wp_customize->add_setting(
    'services_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'services_title_sub_title_heading',
        array(
            'settings'      => 'services_title_sub_title_heading',
            'section'       => 'services_section',
            'label'         => __( 'Section Title', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_setting(
    'services_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'our <strong>Services</strong>', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'services_title',
    array(
        'settings'      => 'services_title',
        'section'       => 'services_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'luzuk-premium' )
    )
);

// Heading color
addColorPalatOption($wp_customize, 'lz_featured_HeadingColor', 'services_section', 'Heading color','#303030');

// border color
addColorPalatOption($wp_customize, 'lz_featured_HeadingborderColor', 'services_section', 'Heading Border color', '#a0c716');


$wp_customize->add_setting('services_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'services_npp_heading',
        array(
            'settings'      => 'services_npp_heading',
            'section'       => 'services_section',
            'label'         => __( 'Number Of services to show', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('services_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 5));
$wp_customize->add_control(
    'services_npp_count',
    array(
        'settings'      => 'services_npp_count',
        'section'       => 'services_section',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

// TEAM PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'services_section',
                'label'         => __( 'Services ', 'luzuk-premium' ).$i,
            )
        )
    );

    if(is_array($featuresSingleChoice)){
    $wp_customize->add_setting(
        'services_page_icon1'.$i,
        array(
            'default'           => 'fa fa-home',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'services_page_icon1'.$i,
            array(
                'settings'      => 'services_page_icon1'.$i,
                'section'       => 'services_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'services_section',
                'type'=> 'select',
                'label'         => __( 'Select a service', 'luzuk-premium' ),
                'choices' => $featuresSingleChoice,
            )
        );
  


    }else{
        $wp_customize->add_setting('lz_fitness_Service_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
        $wp_customize->add_control(
            new lz_fitness_Info_Text( 
                $wp_customize,
                'lz_fitness_Service_section_lbl'.$i,
                array(
                    'settings'      => 'lz_fitness_Service_section_lbl'.$i,
                    'section'       => 'services_section',
                    'label'         => __( 'Note:', 'luzuk-premium' ), 
                    'description'   => __( '<strong>Changes will not reflect unless you select a service.</strong> <br/>Please add the service from "Service menu" and then select service to show information.', 'luzuk-premium' ),
                )
            )
        );
    }
}

// icon color
addColorPalatOption($wp_customize, 'lz_featuredicon_Color', 'services_section', 'Icon color', '#fff');

// icon hover color
addColorPalatOption($wp_customize, 'lz_featurediconhover_Color', 'services_section', 'Icon hover color', '#2b2b2b');

// icon bg color
addColorPalatOption($wp_customize, 'lz_featurediconbg_Color', 'services_section', 'Icon background color', '#a0c716');

// icon bg hover color
addColorPalatOption($wp_customize, 'lz_featurediconbghover_Color', 'services_section', 'Icon background hover color', '#f5f5f5');

// title color
addColorPalatOption($wp_customize, 'lz_featuredtitle_Color', 'services_section', 'Title color', '#303030');

// title hover color
addColorPalatOption($wp_customize, 'lz_featuredtitlehover_Color', 'services_section', 'Title hover color', '#a0c716');

// text color
addColorPalatOption($wp_customize, 'lz_featuredtext_Color', 'services_section', 'Text color', '#323232');

// box color
addColorPalatOption($wp_customize, 'lz_featuredbox_Color', 'services_section', 'Box color', '#fff');


// border color
addColorPalatOption($wp_customize, 'lz_featuredboxhoverborder_Color', 'services_section', 'Box hover border color', '#a0c716');
