<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'luzuk-premium' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'premium_slider_show_content',
		array(
			'settings'      => 'premium_slider_show_content',
			'section'       => 'premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			),
		)
	)
);

$wp_customize->add_setting('lz_fitness_premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_premium_slider_section_lbl',
		array(
			'settings'		=> 'lz_fitness_premium_slider_section_lbl',
			'section'		=> 'premium_slider_section',
			'label'			=> __( 'Note:', 'luzuk-premium' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'luzuk-premium' ),
		)
	)
);

backgroundManager($wp_customize, 'slider', 'premium_slider_section', $color='#fff', get_template_directory_uri().'/images/slider.jpg', 'color');

// Slider Sub Title color
addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'premium_slider_section', 'Slider Sub Title Color', '#fff');

// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'premium_slider_section', 'Slider Title Color', '#fff');

// Slider Title highlight color
addColorPalatOption($wp_customize, 'slider_TitlehighlightColor', 'premium_slider_section', 'Slider Title Highlight Color', '#a0c716');

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'premium_slider_section', 'Slider Button Text Color', '#fff');

// Slider Button border color
addColorPalatOption($wp_customize, 'slider_buttonborderColor', 'premium_slider_section', 'Slider Button Border Color', '#fff');

// Slider Button Text hover color
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'premium_slider_section', 'Slider Button Text Hover Color', '#fff');

// Slider Button Background hover color
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'premium_slider_section', 'Slider Button Background Hover Color', '#a0c716');

// Slider Button border hover color
addColorPalatOption($wp_customize, 'slider_buttonborderhoverColor', 'premium_slider_section', 'Slider Button Border hover Color', '#a0c716');

// Slider image border color
addColorPalatOption($wp_customize, 'slider_imgborderColor', 'premium_slider_section', 'Slider Image Border Color', '#a0c716');