<?php 
/**
 * Createing an about us pannel for customizer
 *
 */
// TEAM SECTION START HERE 
/*============TEAM SECTION PANEL============*/
$wp_customize->add_section(
	'team_section',
	array(
		'title'         => __( 'Team Section', 'luzuk-premium' ),
		'panel'   => 'lz_fitness_premium_home_panel',
	)
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
	'team_section_disable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'team_section_disable',
		array(
			'settings'      => 'team_section_disable',
			'section'       => 'team_section',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

//backgroundManager($wp_customize, 'team', 'team_section', $color='#efefef');
backgroundManager($wp_customize, 'team', 'team_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

$wp_customize->add_setting(
	'team_title_subtitle_heading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'team_title_subtitle_heading',
		array(
			'settings'      => 'team_title_subtitle_heading',
			'section'       => 'team_section',
			'label'         => __( 'Section Title', 'luzuk-premium' ),
		)
	)
);
$wp_customize->add_setting(
	'team_title',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'OUR TEAM', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'team_title',
	array(
		'settings'      => 'team_title',
		'section'       => 'team_section',
		'type'          => 'text',
		'label'         => __( 'Title', 'luzuk-premium' )
	)
);

// Heading color
addColorPalatOption($wp_customize, 'team_HeadingColor', 'team_section', 'Heading color','#303030');

// Heading border color
addColorPalatOption($wp_customize, 'team_HeadingborderColor', 'team_section', 'Section Heading border color', '#a0c716');

$wp_customize->add_setting('team_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'team_npp_heading',
		array(
			'settings'      => 'team_npp_heading',
			'section'       => 'team_section',
			'label'         => __( 'Number Of team to show', 'luzuk-premium' ),
		)
	)
);    
$wp_customize->add_setting('team_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 2));
$wp_customize->add_control(
	'team_npp_count',
	array(
		'settings'      => 'team_npp_count',
		'section'       => 'team_section',
		'type'          => 'select',
		'label'         => __( 'Number of team members to show', 'luzuk-premium' ),
		'choices'=>array(1,2,3,4,5,6,7,8)
	)
);

$wp_customize->add_setting(
	'teamnote_heading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'teamnote_heading',
		array(
			'settings'      => 'teamnote_heading',
			'section'       => 'team_section',
			'label'         => __( 'Kindly add the same size of the team image', 'luzuk-premium' ),
		)
	)
);

// TEAM PAGES
for( $i = 1; $i <= 8; $i++ ){
	$wp_customize->add_setting(
		'team_heading'.$i,
		array(
			'sanitize_callback' => 'lz_fitness_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new lz_fitness_Customize_Heading(
			$wp_customize,
			'team_heading'.$i,
			array(
				'settings'      => 'team_heading'.$i,
				'section'       => 'team_section',
				'label'         => __( 'Team Member ', 'luzuk-premium' ).$i,
			)
		)
	);
	if(is_array($TeamsSingleChoice)){
		$wp_customize->add_setting(
			'team_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'team_page'.$i,
			array(
				'settings'      => 'team_page'.$i,
				'section'       => 'team_section',
				'type'=> 'select',
				'label'         => __( 'Select a Trainer', 'luzuk-premium' ),
				'choices' => $TeamsSingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('team_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
		$wp_customize->add_control(
			new lz_fitness_Info_Text( 
				$wp_customize,
				'team_section_lbl'.$i,
				array(
					'settings'		=> 'team_section_lbl'.$i,
					'section'		=> 'team_section',
					'label'			=> __( 'Note:', 'luzuk-premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the team member.</strong> <br/>Please add the team from "Teams menu" and then select team member to show information.', 'luzuk-premium' ),
				)
			)
		);
	}
}

//social color
addColorPalatOption($wp_customize, 'team_SocialColor', 'team_section', 'Social color', '#fff');

//social box hover link color
addColorPalatOption($wp_customize, 'team_SociaboxlinkColor', 'team_section', 'Social box hover social color', '#fff');

//social box hover link hover color
addColorPalatOption($wp_customize, 'team_SocialhoverColor', 'team_section', 'Social box hover social hover color', '#292929');

//social box color
addColorPalatOption($wp_customize, 'team_SocialboxColor', 'team_section', 'Social box color', '#292929');

//social box hover color
addColorPalatOption($wp_customize, 'team_SocialboxhoverColor', 'team_section', 'Social box hover color', '#a0c716');

// member name color
addColorPalatOption($wp_customize, 'team_TitleColor', 'team_section', 'Title color', '#303030');

// member name hover color
addColorPalatOption($wp_customize, 'team_TitlehoverColor', 'team_section', 'Title hover color', '#fff');

// member designation color
addColorPalatOption($wp_customize, 'team_DesColor', 'team_section', 'Designation color', '#a0c716');

// member designation hover color
addColorPalatOption($wp_customize, 'team_DeshoverColor', 'team_section', 'Designation hover color', '#fff');

//image hover color
addColorPalatOption($wp_customize, 'team_textColor', 'team_imghoverColor', 'Image hover color', '#292929');

// TEAM SECTION END HERE 