<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package LZ Fitness Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins|Roboto:400,900" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Lato|Roboto+Condensed:700" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<!--new for faq-->
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js" crossorigin="anonymous"></script>
	<!--new faq-->
	<!--end script for search bar-->
	<script>
		function buttonUp(){
			var valux = $('.sb-search-input').val(); 
			valux = $.trim(valux).length;
			if(valux !== 0){
				$('.sb-search-submit').css('z-index','99');
			} else{
				$('.sb-search-input').val(''); 
				$('.sb-search-submit').css('z-index','-999');
			}
		}

		$(document).ready(function(){
			var submitIcon = $('.sb-icon-search');
			var submitInput = $('.sb-search-input');
			var searchBox = $('.sb-search');
			var isOpen = false;

			$(document).mouseup(function(){
				if(isOpen == true){
					submitInput.val('');
					$('.sb-search-submit').css('z-index','-999');
					submitIcon.click();
				}
			});

			submitIcon.mouseup(function(){
				return false;
			});

			searchBox.mouseup(function(){
				return false;
			});

			submitIcon.click(function(){
				if(isOpen == false){
					searchBox.addClass('sb-search-open');
					isOpen = true;
				} else {
					searchBox.removeClass('sb-search-open');
					isOpen = false;
				}
			});

		});
	</script><!--end script for search bar-->

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/ie.css" />
	

</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'gurukul' ); ?></a>
		<header id="ht-masthead" class="ht-site-header">
			<div class="main-header">
				<div class="container">
					
					<div class="col-md-6 col-sm-6">
						<?php 
						$email = get_theme_mod('lz_fitness_headermain_email', 'name@yourdomain.com');
						$phone = get_theme_mod('lz_fitness_headermain_phone', '(+100) 123 456 7890'); 
						?>
						<div class="header-right-box">
							<div class="header-menu-box">
								<ul>
									<?php if(!empty($phone)){ ?>
										<li><i class="fa fa-phone"></i><?php echo esc_html($phone);  ?> </li>
									<?php }?> 
									<?php if(!empty($email)){ ?>
										<li><i class="fa fa-envelope"></i><?php echo esc_html($email);  ?> </li>
									<?php }?> 
								</ul>								
							</div>
						</div>
					</div>
					<div class="col-md-6 col-sm-6 text-right"> 
						<?php
						$myaccounttitle = get_theme_mod('lz_fitness_headermain_myaccounttitle', 'My Account'); 
						$myaccount = get_theme_mod('lz_fitness_header_myaccount', 'add myaccount page link here');
						$checkouttitle = get_theme_mod('lz_fitness_headermain_checkouttitle', 'Checkout'); 
						$checkout = get_theme_mod('lz_fitness_header_checkout', 'add checkout page link here');
							//$wishlist = get_theme_mod('lz_fitness_header_wishlist', 'add wishlist page link here');
						?>
						<ul class="header-sm-links">
							<?php if(!empty($myaccount)){ ?>
								<li><a href="<?php echo $myaccount ?>" title="myaccount"><span class="fa fa-user"></span><?php echo esc_html($myaccounttitle);  ?></a></li>
							<?php }?> 
							<?php if(!empty($checkout)){ ?>
								<li><a href="<?php echo $checkout ?>" title="checkout"><span class="fa fa-check"></span><?php echo esc_html($checkouttitle);  ?></a></li>
							<?php }?> 
								<!-- <?php //if(!empty($wishlist)){ //?>
									<li><a href="<?php //echo $wishlist ?>" title="wishlist"><span class="fa fa-heart"></span> Wishlist</a></li>
									<?php// }?> -->
								</ul>
							</div>	

						</div>	
						<div class="clearfix"></div>

					</div>

					<div class="lower-header">
						<div class="container">	
							<div class="header-left col-md-3 col-sm-3">
								<div class="logobox">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
										<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
									<?php endif; ?>
									<!-- .site-branding -->
								</div>
							</div>

							<div class="col-sm-6 col-md-offset-1 ">
								<div id="sb-search" class="sb-search">
									   <form role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
										<label class="screen-reader-text" for="s"><?php _e( 'Search for:', 'woocommerce' ); ?></label>
										<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search Products&hellip;', 'placeholder', 'woocommerce' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'woocommerce' ); ?>" />
										<input type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'woocommerce' ); ?>" />
										<input type="hidden" name="post_type" value="product" />
									</form>
								</div>	
							</div>

							<div class="col-sm-2 upper-header padding0">	
								<div class="total-count pull-left">				
									<?php if(function_exists ('wc_get_cart_url')){?>				
										<a href="<?php echo wc_get_cart_url();?>" class=""><img src="<?php echo get_template_directory_uri(); ?>/images/carticon.png"  alt=""></a>
										<div class="count"><?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?></div>

										<!--<a href="#<?php //echo get_permalink(120); ?>"><img src="<?php //echo get_template_directory_uri(); ?>/images/wishlists.png"  alt=""></a>-->
									</div>
									<div class="header-cart-text text-left">
										<?php
										$lz_fitness_header_mycarttextboxss = get_theme_mod('lz_fitness_header_mycarttextboxss', 'My Cart');
										?>
										<p> <?php echo $lz_fitness_header_mycarttextboxss;?> <br><?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?> items</p>
									</div>
								<?php }?>
							</div>

						</div>
						<div class="clearfix"></div>
					</div>
					<div class="clearfix"></div>
					<div class="header-main-box">
						<div class="container">
							<?php if(class_exists('woocommerce')){ ?>
								<div class="col-md-3 col-sm-4 header-category-box padding0">
									<?php
									$lz_fitness_header_browsebydept = get_theme_mod('lz_fitness_header_browsebydept', 'ALL CATEGORY');
									?>
									<button class="product-btn"><?php echo esc_html_e($lz_fitness_header_browsebydept,'lz-fashion-ecommerce'); ?><i class="fa fa-bars" aria-hidden="true"></i></button>
									<div class="product-cat" style="display: none">
											<?php
											$args = array(
											          'taxonomy' => 'product_cat',
											          'hide_empty' => false,
											          'parent'   => 0
											      );
											  $product_cat = get_terms( $args );

											  foreach ($product_cat as $parent_product_cat)
											  {

											  echo '
											      <ul>
											        <li><a href="'.get_term_link($parent_product_cat->term_id).'">'.$parent_product_cat->name.'</a>
											        <ul>
											          ';
											  $child_args = array(
											              'taxonomy' => 'product_cat',
											              'hide_empty' => false,
											              'parent'   => $parent_product_cat->term_id
											          );
											  $child_product_cats = get_terms( $child_args );
											  foreach ($child_product_cats as $child_product_cat)
											  {
											    echo '<li class="sucat"><a href="'.get_term_link($child_product_cat->term_id).'">'.$child_product_cat->name.'</a>
					 							<ul>
											          ';
											  $child_child_args = array(
											              'taxonomy' => 'product_cat',
											              'hide_empty' => false,
											              'parent'   => $child_product_cat->term_id
											          );
											  $child_child_product_cats = get_terms( $child_child_args );
											  foreach ($child_child_product_cats as $child_child_product_cat)
											  {
											    echo '<li class="sucat"><a href="'.get_term_link($child_child_product_cat->term_id).'">'.$child_child_product_cat->name.'</a>
											    			<ul>
											          ';
											  $child_child_child_args = array(
											              'taxonomy' => 'product_cat',
											              'hide_empty' => false,
											              'parent'   => $child_child_product_cat->term_id
											          );
											  $child_child_child_product_cats = get_terms( $child_child_child_args );
											  foreach ($child_child_child_product_cats as $child_child_child_product_cat)
											  {
											    echo '<li class="sucat"><a href="'.get_term_link($child_child_child_product_cat->term_id).'">'.$child_child_child_product_cat->name.'</a></li>';

												}
												echo '</ul>
													</li>';




											    ;

												}
												echo '</ul>
													</li>';

											  }

											  echo ' </ul>	
											  </li>					    
											    </ul>';
											  }
											?>
										</div>
									</div>
								<?php }else {
									echo '<h6>'.esc_html('Please Install Woocommerce Plugin','lz-fashion-ecommerce').'<h6>'; }?>

									<div class="col-md-9">
										<nav id="ht-site-navigation" class="ht-main-navigation">

											<div class="toggle-bar"><span><i class="fa fa-bars" aria-hidden="true"></i></span></div>
											<?php 
											wp_nav_menu( array( 
												'theme_location' => 'primary', 
												'container_class' => 'ht-menu clearfix' ,
												'menu_class' => 'ht-clearfix',
												'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
											) ); 
											?>

										</nav><!-- #ht-site-navigation -->
									</div>
									<div class="clearfix"></div>

								</div>

							</div>
							<div class="clearfix"></div>
						</header><!-- #masthead -->
					</div>
