<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'lz-fitness-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'lz-fitness-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'lz-fitness-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#6a9529');

// Set heading/title colour
//addColorPalatOption($wp_customize, 'lz_fitness_title_color', 'colors', 'Heading Text Color', '#fe5722');

//theme Secondary color
//addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#f15a24');

//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'lz-fitness-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'lz-fitness-premium' ),
				'off' => __( 'Disable', 'lz-fitness-premium' )
			)	
		)
	)
);
//top header
// $wp_customize->add_setting(
// 	'lz_fitness_headermain_tagline',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default'           => __( 'Just another WordPress site', 'lz-fitness-premium' )
// 	)
// );
// $wp_customize->add_control(
// 	'lz_fitness_headermain_tagline',
// 	array(
// 		'settings'      => 'lz_fitness_headermain_tagline',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'text',
// 		'label'         => __( 'Tagline', 'lz-fitness-premium' )
// 	)
// );
$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '(+100) 123 456 7890' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'name@yourdomain.com', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email', 'lz-fitness-premium' )
	)
);
// My Account
$wp_customize->add_setting(
	'lz_fitness_headermain_myaccounttitle',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'My Account' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_myaccounttitle',
	array(
		'settings'      => 'lz_fitness_headermain_myaccounttitle',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'My Account Text', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting('lz_fitness_header_myaccount',	array('default'=> 'add myaccount page link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_myaccount',
	array(
		'settings'      => 'lz_fitness_header_myaccount',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'My account Page Url', 'gurukul' )
	)
);
// Checkout
$wp_customize->add_setting(
	'lz_fitness_headermain_checkouttitle',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Checkout' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_checkouttitle',
	array(
		'settings'      => 'lz_fitness_headermain_checkouttitle',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Checkout Text', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting('lz_fitness_header_checkout',	array('default'=> 'add checkout page link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_checkout',
	array(
		'settings'      => 'lz_fitness_header_checkout',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Checkout Page Url', 'gurukul' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_header_browsebydept',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'ALL CATEGORY' )
	)
);
$wp_customize->add_control(
	'lz_fitness_header_browsebydept',
	array(
		'settings'      => 'lz_fitness_header_browsebydept',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Category box text', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_header_mycarttextboxss',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'My Cart' )
	)
);
$wp_customize->add_control(
	'lz_fitness_header_mycarttextboxss',
	array(
		'settings'      => 'lz_fitness_header_mycarttextboxss',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'My Cart Text', 'lz-fitness-premium' )
	)
);

// Wishlist
// $wp_customize->add_setting('lz_fitness_header_wishlist',	array('default'=> 'add wishlist Page link here', 'sanitize_callback' => 'esc_url_raw'));
// $wp_customize->add_control('lz_fitness_header_wishlist',
// 	array(
// 		'settings'      => 'lz_fitness_header_wishlist',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'url',
// 		'label'         => __( 'wishlist Page Url', 'gurukul' )
// 	)
// );
// $sectionHeader = 'lz_fitness_header_settings';
// // Adding the Label
// lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');
// //ADD TEXT BOX FOR FORM SHORTCODE
// lzAddElement($wp_customize, 'lz_fitness_header_fb', $sectionHeader, 'text', $label = "Facebook", 'lz_fitness_sanitize_text', 'http://Facbook.com');
// lzAddElement($wp_customize, 'lz_fitness_header_tw', $sectionHeader, 'text', $label = "Twitter", 'lz_fitness_sanitize_text', 'http://twitter.com');
// lzAddElement($wp_customize, 'lz_fitness_header_in', $sectionHeader, 'text', $label = "LinedIn", 'lz_fitness_sanitize_text', 'http://Linkedin.com');

// lzAddElement($wp_customize, 'lz_fitness_header_it', $sectionHeader, 'text', $label = "Instagram", 'lz_fitness_sanitize_text', 'http://Instragram.com');


 // header background color
addColorPalatOption($wp_customize, 'lz_fitness_header_TbackgroundColor', 'lz_fitness_header_settings', 'Top Header Background color', '#2c2c2c'); 

addColorPalatOption($wp_customize, 'lz_fitness_header_backgroundColor', 'lz_fitness_header_settings', 'Main Header Background color', '#ffffff'); 
addColorPalatOption($wp_customize, 'lz_fitness_header_carticonColor', 'lz_fitness_header_settings', 'Cart Icon Background color', '#eeeeee'); 
addColorPalatOption($wp_customize, 'lz_fitness_header_CategoryboxColor', 'lz_fitness_header_settings', 'Category Box Background color', '#ffffff'); 
addColorPalatOption($wp_customize, 'lz_fitness_header_CategoryTextColor', 'lz_fitness_header_settings', 'Category Box Text color', '#000000'); 
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2018 FashionStore. All Rights Reserved', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'lz-fitness-premium' )
	)
);

