<?php
/**
 * Customiser section for featured
 **/
// Start Feature section 
$wp_customize->add_section(
    'lz_fitness_featured_section',
    array(
        'title' => __( 'Featured Products', 'lz-fitness-premium' ), 
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'lz_fitness_featured_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_featured_section_disable',
        array(
            'settings'      => 'lz_fitness_featured_section_disable',
            'section'       => 'lz_fitness_featured_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ), 
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'featured', 'lz_fitness_featured_section', $color='#ffffff');

$wp_customize->add_setting(
    'lz_fitness_featured_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_featured_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_featured_title_sub_title_heading',
            'section'       => 'lz_fitness_featured_section',
            'label'         => __( 'Section Title', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_featured_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'FEATURED', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_featured_title',
    array(
        'settings'      => 'lz_fitness_featured_title',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'lz-fitness-premium' )
    )
);
/*$wp_customize->add_setting(
    'lz_fitness_featured_sub_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Best of Photos', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_featured_sub_title',
    array(
        'settings'      => 'lz_fitness_featured_sub_title',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'textarea',
        'label'         => __( 'Sub Title', 'lz-fitness-premium' ),
    )
);*/


// Heading color
addColorPalatOption($wp_customize, 'lz_fitness_featured_HeadingColor', 'lz_fitness_featured_section', 'Heading color ', '#ffffff');
// Text color
addColorPalatOption($wp_customize, 'lz_fitness_featured_TextColor', 'lz_fitness_featured_section', 'Text color', '#333333');
// Price Text color
addColorPalatOption($wp_customize, 'lz_fitness_featuredPrice_TextColor', 'lz_fitness_featured_section', 'Price Text color', '#333333');
// Icon  color
addColorPalatOption($wp_customize, 'lz_fitness_featuredIcon_TextColor', 'lz_fitness_featured_section', 'Icon color', '#ffffff');
// product title wrap color
addColorPalatOption($wp_customize, 'lz_fitness_producttitlewrap_TextColor', 'lz_fitness_featured_section', 'Product Title Wrap Color', '#ffffff');
// Preview Button Color
addColorPalatOption($wp_customize, 'lz_fitness_PreviewButtonColor_TextColor', 'lz_fitness_featured_section', 'Preview Button Background Color', '#88b14b');





