<?php
/**
 * Customiser section for support
 **/
// Start Support section 
$wp_customize->add_section(
    'lz_fitness_support_section',
    array(
        'title' => __( 'support Section', 'lz-fitness-premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE SUPPORT SECTION
$wp_customize->add_setting(
    'lz_fitness_support_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_support_section_disable',
        array(
            'settings'      => 'lz_fitness_support_section_disable',
            'section'       => 'lz_fitness_support_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'support', 'lz_fitness_support_section', $color='#ffffff');

//$wp_customize->add_setting(
    //'lz_fitness_support_title_sub_title_heading',
    //array(
       // 'sanitize_callback' => 'lz_fitness_sanitize_text'
    //)
//);
//$wp_customize->add_control(
   // new lz_fitness_Customize_Heading(
        //$wp_customize,
        //'lz_fitness_support_title_sub_title_heading',
        //array(
           // 'settings'      => 'lz_fitness_support_title_sub_title_heading',
           // 'section'       => 'lz_fitness_premium_support_section',
           // 'label'         => __( 'Section Title & Sub Title', 'lz-fitness-premium' ),
        //)
   // )
//);    
//$wp_customize->add_setting(
   // 'lz_fitness_support_title',
   // array(
      //  'sanitize_callback' => 'lz_fitness_sanitize_text',
      //  'default'           => __( 'How we  can help you', 'lz-fitness-premium' )
    //)
//);
//$wp_customize->add_control(
    //'lz_fitness_support_title',
   // array(
     //   'settings'      => 'lz_fitness_support_title',
       // 'section'       => 'lz_fitness_premium_support_section',
       // 'type'          => 'text',
       // 'label'         => __( 'Title', 'lz-fitness-premium' )
  //  )
//);
/*$wp_customize->add_setting(
    'lz_fitness_support_sub_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Here goes the short description for the section', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_support_sub_title',
    array(
        'settings'      => 'lz_fitness_support_sub_title',
        'section'       => 'lz_fitness_premium_support_section',
        'type'          => 'textarea',
        'label'         => __( 'Sub Title', 'lz-fitness-premium' ),
    )
);*/
    
   

$wp_customize->add_setting('lz_fitness_support_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_support_npp_heading',
        array(
            'settings'      => 'lz_fitness_support_npp_heading',
            'section'       => 'lz_fitness_support_section',
            'label'         => __( 'Number Of support Plans', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting('lz_fitness_support_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 3));
$wp_customize->add_control(
    'lz_fitness_support_npp_count',
    array(
        'settings'      => 'lz_fitness_support_npp_count',
        'section'       => 'lz_fitness_support_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'lz-fitness-premium' ),
        'choices'=>array(1,2,3,4)
    )
);

//support PAGES
for( $i = 1; $i <= 4; $i++ ){
    $wp_customize->add_setting(
        'lz_fitness_support_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_support_header'.$i,
            array(
                'settings'      => 'lz_fitness_support_header'.$i,
                'section'       => 'lz_fitness_support_section',
                'label'         => __( 'support Page ', 'lz-fitness-premium' ).$i
            )
        )
    );

    
    lzAddElement($wp_customize, 'lz_fitness_support_page_title_'.$i, 'lz_fitness_support_section', $type = 'text', $label="Title", $callback ='lz_fitness_sanitize_text', $default='MONEY BACK GUARANTEE');
  
 lzAddElement($wp_customize, 'lz_fitness_support_page_desc_'.$i, 'lz_fitness_support_section', $type = 'text', $label="description", $callback ='lz_fitness_sanitize_text', $default='100% money back guarantee.');

  /*$wp_customize->add_setting(
        'lz_fitness_support_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'lz_fitness_support_page'.$i,
        array(
            'settings'      => 'lz_fitness_support_page'.$i,
            'section'       => 'lz_fitness_support_section',
            'type'          => 'dropdown-pages',
            'label'         => __( 'Select a Page', 'lz-fitness-premium' )
        )
    );*/
    $wp_customize->add_setting(
        'lz_fitness_support_page_icon'.$i,
        array(
            'default'           => 'fa fa-check-circle',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'lz_fitness_support_page_icon'.$i,
            array(
                'settings'      => 'lz_fitness_support_page_icon'.$i,
                'section'       => 'lz_fitness_support_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'lz-fitness-premium' ),
            )
        ) 
    );  
    
}
 // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_support_HeadingColor', 'lz_fitness_support_section', 'Title Color', '#000000');
    // Description color
    addColorPalatOption($wp_customize, 'lz_fitness_support_DescriptionColor', 'lz_fitness_support_section', 'Description Color', '#000000');
     // Icon color
    addColorPalatOption($wp_customize, 'lz_fitness_support_IconColor', 'lz_fitness_support_section', 'Icon Color', '#000000');
// End support section 