<?php
/**
* The template for displaying search results pages.
*
* @package publishable Lite
*/

get_header(); ?>
<header class="page-main-header">
	<div>
		<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
		<img src="<?php echo !empty($image)?$image : get_template_directory_uri().'/images/default-gray.png';?>" class="ht-page-header-img" alt="<?php the_title();?>" />
	</div>
	<div class="container">
		<h1 class="ht-main-title"><?php printf( esc_html__( 'Search Results for: %s', 'total' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
		<?php do_action( 'total_breadcrumbs' ); ?>
		<div class="clearfix"></div>
	</div>
</header><!-- .entry-header -->
<main id="innerpage-box">
	<div class="container">
	<section id="primary" class="content-area">
		<main id="main" class="site-main">
			<?php if ( have_posts() ) : ?>
				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>
					<?php
					/**
					 * Run the loop for the search to output the results.
					 * If you want to overload this in a child theme then include a file
					 * called content-search.php and that will be used instead.
					 */
					get_template_part( 'template-parts/content', 'search' );
					?>
				<?php endwhile; ?>
				<?php 
				the_posts_pagination( 
					array(
						'prev_text' => __( 'Prev', 'total' ),
						'next_text' => __( 'Next', 'total' ),
					)
				); 
				?>
			<?php else : ?>
			<?php get_template_part( 'template-parts/content', 'none' ); ?>
			<?php endif; ?>
		</main><!-- #main -->
	</section><!-- #primary -->
<!-- 	<?php //get_sidebar(); ?>
 --></div>
</main>
<?php get_footer();
