<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Raleway:600" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Raleway:300,400" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Aguafina+Script" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Anton|Passion+One" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Ubuntu:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Bree+Serif" rel="stylesheet">
	<!-- <script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script> -->
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
<script>
$(document).bind('cbox_complete', function(){
  setTimeout($.colorbox.next, 1500);
});
</script>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'Luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<header class="site-header header-transparent header mo-left header-seo" id="myHeader">

		<div class="main-header">
				<div class="col-md-10 col-md-offset-1">
					<div class="col-md-7 col-sm-5 col-xs-12 headertop-box">
						<?php 
						$email = get_theme_mod('lz_fitness_headermain_email', 'info@companyname.com');
						//$location = get_theme_mod('lz_fitness_headermain_location', '9870 St Vinset Place,Glasgow, DC 45 Fr 45');
							//$time = get_theme_mod('lz_fitness_contactus_time', 'Mon-Sat 0900-1900');
						?>
						<div class="header-right-box">
							<div class="header-menu-box">
								
									
								<?php if($email){ ?>
								<i class="fa fa-envelope"></i>
								<?php echo esc_html($email);  ?> 
								<?php } ?>
							</div>

							

							</div>
						</div>
						<div class="col-md-5 pull-right col-sm-7 col-xs-12 padding0">
							<div class="col-sm-7 col-xs-12 upper-header padding0">					
								<?php 
								$callnow = get_theme_mod('lz_fitness_headermain_callnow', 'CALL NOW');
								$email = get_theme_mod('lz_fitness_headermain_email', 'info@companyname.com');
								$facebook = get_theme_mod('lz_fitness_header_fb','Facebook');
								$twitter = get_theme_mod('lz_fitness_header_tw','Twitter');
								$instagram = get_theme_mod('lz_fitness_header_it','Instagram');
								$linkedIn = get_theme_mod('lz_fitness_header_in','Linked In');
								$youtube = get_theme_mod('lz_fitness_header_yt','Youtube');
								?>
								<div class="header-social-links">
									<?php if(!empty($facebook)){ ?>
									<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
									<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
									<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
									<?php }?>
									<?php if(!empty($instagram)){ ?>
									<a href="<?php echo $instagram ?>" target="_blank" title="Instagram"><span class="fa fa-instagram"></span></a>
									<?php }?>
									<?php if(!empty($youtube)){ ?>
									<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
									<?php }?>
								</div>
							</div>
							<div class="col-sm-5 col-xs-12 phone-box"> 
							<?php if($callnow){ ?>
								<i class="fa fa-phone"></i>
								<?php echo esc_html($callnow);  ?> 
								<?php } ?>
							</div>
						</div>	

					</div>	
					<div class="clearfix"></div>
				</div>

			<?php 
				if( get_theme_mod('header_Tpadding',true) ) {
	                $header_Tpadding = 'padding-top:'.esc_attr(get_theme_mod('header_Tpadding')).';';
	            }
	            if( get_theme_mod('header_Bpadding',true) ) {
	                $header_Bpadding = 'padding-bottom:'.esc_attr(get_theme_mod('header_Bpadding')).';';
	            }
	            if( get_theme_mod('header_Lpadding',true) ) {
	                $header_Lpadding = 'padding-left:'.esc_attr(get_theme_mod('header_Lpadding')).';';
	            }
	            if( get_theme_mod('header_Rpadding',true) ) {
	                $header_Rpadding = 'padding-right:'.esc_attr(get_theme_mod('header_Rpadding')).';';
	            }
				?>

			<div class="lower-header"  style="<?php echo esc_attr($header_Tpadding); ?>" "<?php echo esc_attr($header_Bpadding); ?>" "<?php echo esc_attr($header_Lpadding); ?>" "<?php echo esc_attr($header_Rpadding); ?>">
				<div class="col-md-10 col-md-offset-1">	

				<?php 
					if( get_theme_mod('pages_logoTmargin',true) ) {
		                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
		            }
		            if( get_theme_mod('pages_logoBmargin',true) ) {
		                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
		            }
		            if( get_theme_mod('pages_logoLmargin',true) ) {
		                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
		            }
		            if( get_theme_mod('pages_logoRmargin',true) ) {
		                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
		            }
		            if( get_theme_mod('pages_logomaxwidth',true) ) {
		                $pages_logomaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logomaxwidth')).';';
		            }

				?>
			<div class="header-left col-md-2 col-sm-10 col-xs-10 padding0 logo"> 
			
				<div class="logobox" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>" "<?php echo esc_attr($pages_logomaxwidth); ?>" >
					<?php 
					if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
						the_custom_logo();
				else : 
					if ( is_front_page() ) : ?>
						<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php endif; ?>
					<?php endif; ?>
					<!-- .site-branding -->
					<div class="clearfix"></div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
				</div>
			</div>
			<!-- main header -->
			<div class="col-md-9 col-md-offset-1 col-xs-2 col-sm-2 padding0 sticky-header main-bar-wraper navbar-expand-lg">
				<div class="main-bar clearfix ">
					<div class="top-bar-head">

						<!-- nav toggle button -->
						<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
							<span></span>
							<span></span>
							<span></span>
						</button>
						<!-- main nav -->


						<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown" >
							<div class="reslogobox">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
								<?php endif; ?>
								<!-- .site-branding -->
								<div class="clearfix"></div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
							</div>

							<ul class="nav navbar-nav wow slideInLeft ">	
								<?php 
								wp_nav_menu( array( 
									'theme_location' => 'primary', 
									'container_class' => 'ht-menu clearfix' ,
									'menu_class' => 'ht-clearfix wow',
									'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								) ); 
								?>
							</ul>

						</div>

					</div>
				</div>
			</div>
		</div>
				<div class="clearfix"></div>
		</div>
			<!-- main header END -->
			<div class="clearfix"></div>

		</header><!-- #masthead -->

	</div>
