<?php
/**
 * Use for the show the notes at home page and in notes page with shortcode
 * @param int $pageId default is null the id of a post
 * @param boolean $isCustomizer default is false if set to true it mean the output is set for the home page
 * @param int $i default null
 * @param boolean $showStaticVals default is false
 * @return string
 * @author Dipika Ingle <dipika1.radical@outlook.com>
 * */
function projectShortCode($pageId = null, $isCustomizer = false, $i = null) {

    ob_start();

    $args = array('post_type' => 'project');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $args['posts_per_page'] = -1;
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('project_npp_count',7);  
    ++$cols;
    switch ($cols) {
        case 1:
        $colCls = 'col-md-12 col-sm-12 col-xs-12';
        break;
        case 2:
        $colCls = 'col-md-6 col-sm-6 col-xs-12';
        break;
        case 4:
        $colCls = 'col-md-3 col-sm-6 col-xs-12';
        break;       
        case 5:
        case 6:
        default: 
        $colCls = 'col-md-4 col-sm-6 col-xs-12';
        break;
    }
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $lz_fitness_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-project-thumb');
            $post = get_post();

            if (($postN % 3) == 0 && $isCustomizer == false) {
                ?>
                <div class="clearfix paddingBot20"></div>
            </div>
            <div class="row">
                <?php
            }
            ++$postN;
            ?>
            
            <div class="<?php echo $colCls; ?>">
                <div class="ht-project-member paddingBot20">
                    <div class="ht-project-member-image">
                        <?php
                        if (has_post_thumbnail()) {
                            $image_url = $lz_fitness_image[0];
                        } else {
                            $image_url = get_template_directory_uri() . '/images/project.jpg';
                        }
                        ?>                                                          
                        <img class="secondry-bg img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php the_title(); ?>" />

                    </div>
                    <div class="project-main-box">  
                        <div class="ht-title-Project">
                            <h6 class="member-name"><?php the_title(); ?></h6>                     
                            
                        </div>
                        <div class="ht-Project-contents">
                          <p><?php
                          if (has_excerpt()) {
                            echo get_the_excerpt();
                        } else {
                            echo lz_fitness_excerpt(get_the_content(), 100);
                        }
                        ?>
                    </p>
                    <div class="project-button">
                       <a class="btn " href="<?php echo esc_url(get_permalink()); ?>">VIEW PROJECT</a>
                   </div>
               </div>
           </div>
           
           
       </div>
   </div>
   <?php
endwhile;
$text = ob_get_contents();
ob_clean();
endif;
wp_reset_postdata();
return $text;
}

add_shortcode('PROJECTLIST', 'projectShortCode');




